/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.fileparsing.common.interceptor;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.fileparsing.beans.ResultBean;
import com.digiwin.fileparsing.reasoning.pipeline.Pipeline;
import com.digiwin.fileparsing.reasoning.search.config.AppTokenConfig;
import com.digiwin.fileparsing.reasoning.search.config.IamHostConfig;
import java.io.IOException;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
public class UserLoginInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(UserLoginInterceptor.class);
    @Value(value="${dyn-params.iamAddr}")
    private String iamAddr;
    @Autowired
    private AppTokenConfig appTokenConfig;
    private String SCRUMBI_TOKEN = "4oAdURv.P4J5bdL2YXepKsnlp";
    private String ERR_MESSAGE = "\u7528\u6236token\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55\u6216\u8054\u7cfb\u5ba2\u670d\u4e13\u5458";
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private IamHostConfig iamHostConfig;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String userToken;
        boolean result = false;
        String uri = request.getRequestURI();
        if (uri.contains("swagger") || uri.contains("api-docs")) {
            result = true;
        }
        if (StringUtils.isNotEmpty((CharSequence)(userToken = request.getHeader("token")))) {
            Pipeline.addUserToken((String)userToken);
        }
        String routerKey = request.getHeader("routerKey");
        log.info("UserLoginInterceptor routerKey is exist: {}", (Object)routerKey);
        if (StringUtils.isNotEmpty((CharSequence)routerKey)) {
            Pipeline.addRouterKey((String)routerKey);
        }
        String messageId = request.getHeader("messageId");
        String scrumbiToken = request.getHeader("scrumbiToken");
        if (this.SCRUMBI_TOKEN.equals(scrumbiToken)) {
            return true;
        }
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        headers.add("digi-middleware-auth-app", this.appTokenConfig.getAthena());
        headers.add("digi-middleware-auth-user", userToken);
        HttpEntity httpEntity = new HttpEntity((Object)new JSONObject(), (MultiValueMap)headers);
        try {
            ResponseEntity responseEntity = this.restTemplate.postForEntity(this.iamHostConfig.getAnalyzeAddr(), (Object)httpEntity, JSONObject.class, new Object[0]);
            log.info("UserLoginInterceptor#preHandle responseEntity\uff1a{}", responseEntity.getBody());
            if (!responseEntity.getStatusCode().is2xxSuccessful()) {
                this.returnTokenCheckJson(response, Optional.ofNullable(responseEntity.getBody()).map(e -> e.getString("errorMessage")).orElse(this.ERR_MESSAGE));
                return false;
            }
        }
        catch (Exception e2) {
            this.returnTokenCheckJson(response, this.ERR_MESSAGE);
            return false;
        }
        return true;
    }

    public void returnTokenCheckJson(HttpServletResponse response, String returnMsg) {
        response.setCharacterEncoding("utf-8");
        response.setContentType("application/json; charset=utf-8");
        response.setStatus(HttpStatus.UNAUTHORIZED.value());
        try {
            response.getWriter().print(JSON.toJSONString((Object)ResultBean._401((String)returnMsg)));
        }
        catch (IOException e) {
            log.warn("****** \u8bf7\u6c42token\u8bb8\u53ef\u62e6\u622a\u5668\u8fd4\u56de\u7ed3\u679c\u5f02\u5e38\uff1a{} ******", (Object)e.getMessage());
        }
    }

    public void setIamAddr(String iamAddr) {
        this.iamAddr = iamAddr;
    }
}

