/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.fileparsing.common.util;

import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class DateTimeUtil {
    public static final Log logger = LogFactory.getLog(DateTimeUtil.class);
    public static final String DEFAULT_DATETIME_PATTERN_MILL = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final DateTimeFormatter DEFAULT_DATETIME_FORMATTER_MILL = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
    public static final String DEFAULT_DATETIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final DateTimeFormatter DEFAULT_DATETIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public static final String FormatterPattern_US = "MM/dd/yyyy HH:mm:ss a";
    public static final List<String> PATTERNS = new ArrayList();
    public static final DateTimeFormatter DefaultFormatter;
    public final SimpleDateFormat Formatter_US = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss a", Locale.US);
    public static final LocalDateTime DefaultDate;

    public static double getUnixEpoch(LocalDateTime dateTime) {
        return dateTime.toEpochSecond(ZoneOffset.ofHours(0)) * 1000L;
    }

    public static int dayDiffer(Date startDate, Date endDate) {
        long day = endDate.getTime() - startDate.getTime();
        return (int)(day / 86400000L);
    }

    public static int minutesDiffer(Date startDate, Date endDate) {
        long diff = Math.abs(endDate.getTime() - startDate.getTime());
        long diffMinutes = diff / 60000L;
        return (int)diffMinutes;
    }

    public static int dayDiffer(LocalDate startDate, LocalDate endDate) {
        long day = endDate.toEpochDay() - startDate.toEpochDay();
        return (int)(day / 86400000L);
    }

    public static Date formatDateStr(String DateStr) throws Exception {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        if (DateStr.length() == 6) {
            df = new SimpleDateFormat("yyMMdd");
        } else if (DateStr.length() == 10) {
            df = new SimpleDateFormat("yyyy/MM/dd");
        } else if (DateStr.length() == 17) {
            df = new SimpleDateFormat("yyyy/MM/dd HHmmss");
        } else if (DateStr.length() == 19) {
            df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        }
        return df.parse(DateStr);
    }

    public static String format(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return df.format(date);
    }

    public static String format(Date date, String pattern) {
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        return df.format(date);
    }

    public static Date parse(String dateStr, String pattern) {
        if (StringUtils.isBlank((CharSequence)dateStr)) {
            return null;
        }
        dateStr = dateStr.replaceAll("[a-zA-Z]", " ").trim();
        if (StringUtils.isBlank((CharSequence)pattern)) {
            pattern = "yyyy-MM-dd HH:mm:ss";
        }
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        try {
            return df.parse(dateStr);
        }
        catch (Exception var4) {
            return null;
        }
    }

    public static String formatter(Date date, String pattern) {
        if (StringUtils.isBlank((CharSequence)pattern)) {
            pattern = "yyyy-MM-dd HH:mm:ss";
        }
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        try {
            return df.format(date);
        }
        catch (Exception var4) {
            return null;
        }
    }

    public static String getDateFormatterPattern(String dateStr) {
        SimpleDateFormat df = null;
        dateStr = dateStr.replaceAll("[a-zA-Z]", " ").trim();
        String realPattern = null;
        for (String pattern : PATTERNS) {
            try {
                df = new SimpleDateFormat(pattern);
                Date date = df.parse(dateStr);
                if (dateStr == null || !dateStr.equals(df.format(date))) continue;
                realPattern = pattern;
                break;
            }
            catch (Exception exception) {
            }
        }
        return realPattern;
    }

    public static String getDateFormatterPattern(Date date) {
        SimpleDateFormat df = null;
        String realPattern = null;
        for (String pattern : PATTERNS) {
            try {
                df = new SimpleDateFormat(pattern);
                String dateStr = df.format(date);
                if (!StringUtils.isNotBlank((CharSequence)dateStr)) continue;
                realPattern = pattern;
                break;
            }
            catch (Exception exception) {
            }
        }
        return realPattern;
    }

    public static String getNextWeekTimeToString(Integer amountDay) {
        if (amountDay == null) {
            amountDay = 31;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.add(6, amountDay);
        return DateTimeUtil.formatter((Date)calendar.getTime(), null);
    }

    public static Integer getNextWeekTimeToInt(Integer amountDay) {
        if (amountDay == null) {
            amountDay = 31;
        }
        return amountDay * 24 * 60 * 60;
    }

    public static LocalDateTime parseUseDefaultPattern(String dateTime) {
        if (null == dateTime || dateTime.trim().isEmpty()) {
            return LocalDateTime.MIN;
        }
        return LocalDateTime.parse(dateTime, DEFAULT_DATETIME_FORMATTER);
    }

    public static Boolean isBeforeNowDateTime(String otherDateTimeStr) {
        LocalDateTime localDateTime = DateTimeUtil.parseUseDefaultPattern((String)otherDateTimeStr);
        return localDateTime.isBefore(LocalDateTime.now());
    }

    public static Boolean isAfterNowDatetime(String otherDateTimeStr) {
        LocalDateTime localDateTime = DateTimeUtil.parseUseDefaultPattern((String)otherDateTimeStr);
        return localDateTime.isAfter(LocalDateTime.now());
    }

    public static void main(String[] args) {
        System.out.println(DateTimeUtil.getNextWeekTimeToString((Integer)9));
        System.out.println(DateTimeUtil.isBeforeNowDateTime((String)"2030-01-01 09:00:00"));
        System.out.println(DateTimeUtil.isBeforeNowDateTime((String)"2024-01-01 09:00:00"));
    }

    static {
        PATTERNS.add("yyyy-MM-dd HH:mm:ss");
        PATTERNS.add("yyyy-MM-dd HH:mm");
        PATTERNS.add("yyyy-MM-dd HH");
        PATTERNS.add("yyyy-MM-dd");
        PATTERNS.add("yyyyMMddHHmmss");
        PATTERNS.add("yyyyMMddHHmm");
        PATTERNS.add("yyyyMMddHH");
        PATTERNS.add("yyyyMMdd");
        PATTERNS.add("yyyyMM");
        PATTERNS.add("yyyy-MM");
        PATTERNS.add("yyyy/MM/dd HH:mm:ss");
        PATTERNS.add("yyyy/MM/dd HH:mm");
        PATTERNS.add("yyyy/MM/dd HH");
        PATTERNS.add("yyyy/MM/dd");
        PATTERNS.add("yyyy\u5e74MM\u6708dd\u65e5HH\u65f6mm\u5206ss\u79d2");
        PATTERNS.add("yyyy\u5e74MM\u6708dd\u65e5HH\u65f6mm\u5206");
        PATTERNS.add("yyyy\u5e74MM\u6708dd\u65e5HH\u65f6");
        PATTERNS.add("yyyy\u5e74MM\u6708dd\u65e5");
        PATTERNS.add("yyyy\u5e74MM\u6708");
        PATTERNS.add("yyyy\u5e74");
        PATTERNS.add("MM/dd/yyyy HH:mm:ss a");
        PATTERNS.add("MM/dd/yyyy HH:mm:ss");
        PATTERNS.add("MM/dd/yyyy HH:mm");
        PATTERNS.add("MM/dd/yyyy HH");
        PATTERNS.add("MM/dd/yyyy");
        PATTERNS.add("MMddyyyyHHmmss");
        PATTERNS.add("MMddyyyyHHmm");
        PATTERNS.add("MMddyyyyHH");
        PATTERNS.add("MMddyyyy");
        PATTERNS.add("yyyy-M-dd HH:mm:ss");
        PATTERNS.add("yyyy-M-dd HH:mm");
        PATTERNS.add("yyyy-M-dd HH");
        PATTERNS.add("yyyy-M-dd");
        PATTERNS.add("yyyyMddHHmmss");
        PATTERNS.add("yyyyMddHHmm");
        PATTERNS.add("yyyyMddHH");
        PATTERNS.add("yyyyMdd");
        PATTERNS.add("yyyyM");
        PATTERNS.add("yyyy-M");
        PATTERNS.add("yyyy/M/dd HH:mm:ss");
        PATTERNS.add("yyyy/M/dd HH:mm");
        PATTERNS.add("yyyy/M/dd HH");
        PATTERNS.add("yyyy/M/dd");
        PATTERNS.add("yyyy\u5e74M\u6708dd\u65e5HH\u65f6mm\u5206ss\u79d2");
        PATTERNS.add("yyyy\u5e74M\u6708dd\u65e5HH\u65f6mm\u5206");
        PATTERNS.add("yyyy\u5e74M\u6708dd\u65e5HH\u65f6");
        PATTERNS.add("yyyy\u5e74M\u6708dd\u65e5");
        PATTERNS.add("yyyy\u5e74M\u6708");
        PATTERNS.add("yyyy\u5e74");
        PATTERNS.add("M/dd/yyyy HH:mm:ss a");
        PATTERNS.add("M/dd/yyyy HH:mm:ss");
        PATTERNS.add("M/dd/yyyy HH:mm");
        PATTERNS.add("M/dd/yyyy HH");
        PATTERNS.add("M/dd/yyyy");
        PATTERNS.add("MddyyyyHHmmss");
        PATTERNS.add("MddyyyyHHmm");
        PATTERNS.add("MddyyyyHH");
        PATTERNS.add("Mddyyyy");
        PATTERNS.add("yyyy-M-d HH:mm:ss");
        PATTERNS.add("yyyy-M-d HH:mm");
        PATTERNS.add("yyyy-M-d HH");
        PATTERNS.add("yyyy-M-d");
        PATTERNS.add("yyyyMdHHmmss");
        PATTERNS.add("yyyyMdHHmm");
        PATTERNS.add("yyyyMdHH");
        PATTERNS.add("yyyyMd");
        PATTERNS.add("yyyyM");
        PATTERNS.add("yyyy-M");
        PATTERNS.add("yyyy/M/d HH:mm:ss");
        PATTERNS.add("yyyy/M/d HH:mm");
        PATTERNS.add("yyyy/M/d HH");
        PATTERNS.add("yyyy/M/d");
        PATTERNS.add("yyyy\u5e74M\u6708d\u65e5HH\u65f6mm\u5206ss\u79d2");
        PATTERNS.add("yyyy\u5e74M\u6708d\u65e5HH\u65f6mm\u5206");
        PATTERNS.add("yyyy\u5e74M\u6708d\u65e5HH\u65f6");
        PATTERNS.add("yyyy\u5e74M\u6708d\u65e5");
        PATTERNS.add("yyyy\u5e74M\u6708");
        PATTERNS.add("yyyy\u5e74");
        PATTERNS.add("M/d/yyyy HH:mm:ss a");
        PATTERNS.add("M/d/yyyy HH:mm:ss");
        PATTERNS.add("M/d/yyyy HH:mm");
        PATTERNS.add("M/d/yyyy HH");
        PATTERNS.add("M/d/yyyy");
        PATTERNS.add("MdyyyyHHmmss");
        PATTERNS.add("MdyyyyHHmm");
        PATTERNS.add("MdyyyyHH");
        PATTERNS.add("Mdyyyy");
        PATTERNS.add("yyyy-MM-d HH:mm:ss");
        PATTERNS.add("yyyy-MM-d HH:mm");
        PATTERNS.add("yyyy-MM-d HH");
        PATTERNS.add("yyyy-MM-d");
        PATTERNS.add("yyyyMMdHHmmss");
        PATTERNS.add("yyyyMMdHHmm");
        PATTERNS.add("yyyyMMdHH");
        PATTERNS.add("yyyyMMd");
        PATTERNS.add("yyyyMM");
        PATTERNS.add("yyyy-MM");
        PATTERNS.add("yyyy/MM/d HH:mm:ss");
        PATTERNS.add("yyyy/MM/d HH:mm");
        PATTERNS.add("yyyy/MM/d HH");
        PATTERNS.add("yyyy/MM/d");
        PATTERNS.add("yyyy\u5e74MM\u6708d\u65e5HH\u65f6mm\u5206ss\u79d2");
        PATTERNS.add("yyyy\u5e74MM\u6708d\u65e5HH\u65f6mm\u5206");
        PATTERNS.add("yyyy\u5e74MM\u6708d\u65e5HH\u65f6");
        PATTERNS.add("yyyy\u5e74MM\u6708d\u65e5");
        PATTERNS.add("yyyy\u5e74MM\u6708");
        PATTERNS.add("yyyy\u5e74");
        PATTERNS.add("MM/d/yyyy HH:mm:ss a");
        PATTERNS.add("MM/d/yyyy HH:mm:ss");
        PATTERNS.add("MM/d/yyyy HH:mm");
        PATTERNS.add("MM/d/yyyy HH");
        PATTERNS.add("MM/d/yyyy");
        PATTERNS.add("MMdyyyyHHmmss");
        PATTERNS.add("MMdyyyyHHmm");
        PATTERNS.add("MMdyyyyHH");
        PATTERNS.add("MMdyyyy");
        DefaultFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        DefaultDate = LocalDateTime.of(1970, 1, 1, 0, 0);
    }
}

