/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.fileparsing.common.util;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

class LocalDataTypeAdapter
implements JsonSerializer<LocalDateTime>,
JsonDeserializer<LocalDateTime> {
    DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    LocalDataTypeAdapter() {
    }

    public LocalDateTime deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        if (jsonElement.toString().indexOf("date") > 0) {
            return (LocalDateTime)new Gson().fromJson(jsonElement.toString(), LocalDateTime.class);
        }
        if (jsonElement.toString().indexOf(32) == 11) {
            this.format = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        } else if (jsonElement.toString().indexOf(84) == 11) {
            this.format = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss");
        }
        return LocalDateTime.parse(jsonElement.getAsJsonPrimitive().getAsString(), this.format);
    }

    public JsonElement serialize(LocalDateTime localDate, Type type, JsonSerializationContext jsonSerializationContext) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        return new JsonPrimitive(dateTimeFormatter.format(localDate));
    }
}

