/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.fileparsing.common.util;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
public class RedisUtil {
    private static final Logger log = LoggerFactory.getLogger(RedisUtil.class);
    public static RedisTemplate<String, Object> redisTemplate;

    public static Object get(String key) {
        return key == null ? null : redisTemplate.opsForValue().get((Object)key);
    }

    public static Boolean expire(String key, long time) {
        return RedisUtil.expire((String)key, (long)time, (TimeUnit)TimeUnit.SECONDS);
    }

    public static Boolean expire(String key, long time, TimeUnit timeUnit) {
        return redisTemplate.expire((Object)key, time, timeUnit);
    }

    public static Long incr(String key) {
        return redisTemplate.opsForValue().increment((Object)key);
    }

    public static long getExpire(String key) {
        return Optional.ofNullable(redisTemplate.getExpire((Object)key, TimeUnit.SECONDS)).orElse(0L);
    }

    public static void set(String key, Object value) {
        redisTemplate.opsForValue().set((Object)key, value);
    }

    public static void set(String key, Object value, long time) {
        RedisUtil.set((String)key, (Object)value, (long)time, (TimeUnit)TimeUnit.SECONDS);
    }

    public static void set(String key, Object value, long time, TimeUnit timeUnit) {
        redisTemplate.opsForValue().set((Object)key, value, time, timeUnit);
    }

    public static boolean setIfAbsent(String key, Object value) {
        return Optional.ofNullable(redisTemplate.opsForValue().setIfAbsent((Object)key, value)).orElse(false);
    }

    public static boolean setIfAbsent(String key, Object value, long time) {
        return RedisUtil.setIfAbsent((String)key, (Object)value, (long)time, (TimeUnit)TimeUnit.SECONDS);
    }

    public static boolean setIfAbsent(String key, Object value, long time, TimeUnit timeUnit) {
        return Optional.ofNullable(redisTemplate.opsForValue().setIfAbsent((Object)key, value, time, timeUnit)).orElse(false);
    }

    public static void delete(String key) {
        if (StringUtils.isEmpty((CharSequence)key)) {
            return;
        }
        redisTemplate.delete((Object)key);
    }

    public static void delete(Collection<String> keys) {
        redisTemplate.delete(keys);
    }

    public static void deleteLike(String likeKey) {
        Set keys = redisTemplate.keys((Object)likeKey);
        if (keys != null && keys.size() > 0) {
            redisTemplate.delete((Collection)keys);
        }
    }

    public static List<Object> multiGet(Collection<String> keys) {
        return redisTemplate.opsForValue().multiGet(keys);
    }

    public static Set intersect(String firstKey, String secondKey) {
        return redisTemplate.opsForSet().intersect((Object)firstKey, (Object)secondKey);
    }

    public static void intersectAndStore(List<String> keys, String destKey) {
        log.info("redis intersectAndStore keys={} ", keys);
        String key = keys.get(0);
        keys.remove(key);
        log.info("redis intersectAndStore key={} otherKeys={} ", (Object)key, keys);
        redisTemplate.opsForSet().intersectAndStore((Object)key, keys, (Object)destKey);
        RedisUtil.expire((String)destKey, (long)1200L);
        keys.add(key);
    }

    public static void intersectAndStore(String key, String otherKey, String destKey) {
        redisTemplate.opsForSet().intersectAndStore((Object)key, (Object)otherKey, (Object)destKey);
        RedisUtil.expire((String)destKey, (long)1200L);
    }

    public static void unionAndStore(List<String> keys, String destKey) {
        log.info("redis unionAndStore keys={} ", keys);
        String key = keys.get(0);
        keys.remove(key);
        log.info("redis unionAndStore key={} otherKeys={} ", (Object)key, keys);
        redisTemplate.opsForSet().unionAndStore((Object)key, keys, (Object)destKey);
        RedisUtil.expire((String)destKey, (long)1200L);
        keys.add(key);
    }

    public static void differenceAndStore(String key, String otherKey, String destKey) {
        redisTemplate.opsForSet().differenceAndStore((Object)key, (Object)otherKey, (Object)destKey);
        RedisUtil.expire((String)destKey, (long)1200L);
    }

    public static void addSet(String key, Object ... setValue) {
        redisTemplate.opsForSet().add((Object)key, setValue);
        RedisUtil.expire((String)key, (long)1200L);
    }

    public static Set getSet(String key) {
        return redisTemplate.opsForSet().members((Object)key);
    }

    public static long getSetSize(String key) {
        return redisTemplate.opsForSet().size((Object)key);
    }

    public static Set union(String firstKey, String secondKey) {
        return redisTemplate.opsForSet().union((Object)firstKey, (Object)secondKey);
    }

    public static Set difference(String firstKey, String secondKey) {
        return redisTemplate.opsForSet().difference((Object)firstKey, (Object)secondKey);
    }

    public static Boolean isMember(String key, String value) {
        return redisTemplate.opsForSet().isMember((Object)key, (Object)value);
    }

    public static Set members(String key) {
        return redisTemplate.opsForSet().members((Object)key);
    }

    public static void addList(String key, Object ... setValue) {
        redisTemplate.opsForList().rightPush((Object)key, (Object)setValue);
        RedisUtil.expire((String)key, (long)600L);
    }

    public static Long getListSize(String key) {
        return redisTemplate.opsForList().size((Object)key);
    }

    public static List<Object> getList(String key) {
        return redisTemplate.opsForList().range((Object)key, 0L, -1L);
    }
}

