/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.fileparsing.config;

import java.util.concurrent.TimeUnit;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

@Configuration
public class RestTemplateConfig {
    @Bean
    public RestTemplate restTemplate() {
        PoolingHttpClientConnectionManager pollingConnectionManager = new PoolingHttpClientConnectionManager();
        pollingConnectionManager.setMaxTotal(2000);
        pollingConnectionManager.setDefaultMaxPerRoute(400);
        HttpClientBuilder httpClientBuilder = HttpClients.custom();
        httpClientBuilder.evictExpiredConnections();
        httpClientBuilder.evictIdleConnections(30L, TimeUnit.SECONDS);
        httpClientBuilder.setConnectionManager((HttpClientConnectionManager)pollingConnectionManager);
        httpClientBuilder.setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(3, true));
        CloseableHttpClient httpClient = httpClientBuilder.build();
        HttpComponentsClientHttpRequestFactory clientHttpRequestFactory = new HttpComponentsClientHttpRequestFactory((HttpClient)httpClient);
        clientHttpRequestFactory.setConnectTimeout(20000);
        clientHttpRequestFactory.setReadTimeout(20000);
        clientHttpRequestFactory.setConnectionRequestTimeout(200);
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.setRequestFactory((ClientHttpRequestFactory)clientHttpRequestFactory);
        restTemplate.setErrorHandler((ResponseErrorHandler)new /* Unavailable Anonymous Inner Class!! */);
        return restTemplate;
    }
}

