/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.fileparsing.controller;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.fileparsing.beans.AdqFileModel;
import com.digiwin.fileparsing.beans.AdqPPTModel;
import com.digiwin.fileparsing.beans.ResultBean;
import com.digiwin.fileparsing.beans.pojos.ReportV2Dto;
import com.digiwin.fileparsing.common.util.CommonUtil;
import com.digiwin.fileparsing.common.util.DateTimeUtil;
import com.digiwin.fileparsing.common.util.JSONUtils;
import com.digiwin.fileparsing.service.AdqService;
import com.digiwin.fileparsing.service.AnalysisReportService;
import com.digiwin.fileparsing.service.ChatBiService;
import com.digiwin.fileparsing.service.CreateFileService;
import com.digiwin.fileparsing.service.DmcService;
import com.github.houbb.opencc4j.util.ZhConverterUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import javax.annotation.Resource;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"fileparsing"})
@Api(value="FileparsingController", tags={"FileparsingController"})
public class FileparsingController {
    private static final Logger log = LoggerFactory.getLogger(FileparsingController.class);
    @Resource
    private AnalysisReportService analysisReportService;
    @Resource
    private CreateFileService createFileService;
    @Resource
    private AdqService adqService;
    @Value(value="${file.expireDate}")
    private int amountDay;
    @Resource
    private DmcService dmcService;
    @Resource
    private ChatBiService chatBiService;

    @PostMapping(value={"/pushReport/v2"})
    @ApiOperation(value="\u63a8\u9001\u62a5\u8868")
    public ResultBean<JSONObject> pushReportV2(@RequestBody ReportV2Dto reportV2Dto, @RequestHeader(value="locale", required=false) String locale) {
        log.info("FileparsingController#pushReportV2 reportV2Dto: {}", (Object)reportV2Dto);
        StopWatch stopWatch = StopWatch.createStarted();
        try {
            JSONObject res = this.analysisReportService.pushReportV2(reportV2Dto, locale);
            log.info("FileparsingController#pushReportV2 elapsed time: {}ms", (Object)stopWatch.getTime());
            return ResultBean.ok((Object)res);
        }
        catch (Exception e) {
            log.info("FileparsingController#pushReportV2 elapsed time: {}ms", (Object)stopWatch.getTime());
            log.error("pushReportV2\u5931\u8d25\uff1a{}", (Throwable)e);
            return ResultBean.fail((String)("zh_TW".equals(locale) ? ZhConverterUtil.toTraditional((String)e.getMessage()) : ZhConverterUtil.toSimple((String)e.getMessage())));
        }
    }

    @PostMapping(value={"getDmcShareUrl"})
    public ResultBean<String> getDmcShareUrl(@RequestBody Map<String, Object> excelRequest, @RequestHeader(value="locale", required=false) String locale) {
        log.info("FileparsingController#getDmcShareUrl getDmcShareUrl: {}", (Object)JSONUtils.toJsonString(excelRequest));
        StopWatch stopWatch = StopWatch.createStarted();
        String tenantId = "";
        if (!CollectionUtils.isEmpty(excelRequest)) {
            if (excelRequest.get("tenantId") == null || !StringUtils.hasLength((String)((String)excelRequest.get("tenantId")))) {
                return ResultBean.fail((String)CommonUtil.getMessageUtils().getMessageByLangName("message.fileparsing.create.excel.error.tenant.empty", locale));
            }
            tenantId = (String)excelRequest.get("tenantId");
            if (excelRequest.get("fileName") == null) {
                return ResultBean.fail((String)CommonUtil.getMessageUtils().getMessageByLangName("message.fileparsing.create.excel.error.filename.empty", locale));
            }
            if (CollectionUtils.isEmpty((Collection)((Collection)excelRequest.get("fileData")))) {
                return ResultBean.fail((String)CommonUtil.getMessageUtils().getMessageByLangName("message.fileparsing.create.excel.error.data.empty", locale));
            }
        }
        try {
            String shareUrl = this.analysisReportService.getDmcShareUrl(excelRequest, tenantId, locale);
            log.info("FileparsingController#getDmcShareUrl elapsed time: {}ms", (Object)stopWatch.getTime());
            return ResultBean.ok((Object)shareUrl);
        }
        catch (Exception e) {
            log.info("FileparsingController#getDmcShareUrl elapsed time: {}ms", (Object)stopWatch.getTime());
            log.error("getDmcShareUrl\uff1a{}", (Throwable)e);
            return ResultBean.fail((String)("zh_TW".equals(locale) ? ZhConverterUtil.toTraditional((String)e.getMessage()) : ZhConverterUtil.toSimple((String)e.getMessage())));
        }
    }

    @PostMapping(value={"getPPTDmcShareUrl"})
    public ResultBean<Object> getPPTDmcShareUrl(@RequestBody Map<String, Object> pptContentRequest, @RequestHeader(value="locale", required=false) String locale, @RequestHeader(value="token", required=false) String token) {
        log.info("FileparsingController#getPPTDmcShareUrl getPPTDmcShareUrl: {}", (Object)JSONUtils.toJsonString(pptContentRequest));
        StopWatch stopWatch = StopWatch.createStarted();
        String tenantId = "";
        if (!CollectionUtils.isEmpty(pptContentRequest)) {
            if (pptContentRequest.get("tenantId") == null || !StringUtils.hasLength((String)((String)pptContentRequest.get("tenantId")))) {
                return ResultBean.fail((String)CommonUtil.getMessageUtils().getMessageByLangName("message.fileparsing.create.ppt.error.tenant.empty", locale));
            }
            tenantId = (String)pptContentRequest.get("tenantId");
            if (CollectionUtils.isEmpty((Collection)((Collection)pptContentRequest.get("pptData")))) {
                return ResultBean.fail((String)CommonUtil.getMessageUtils().getMessageByLangName("message.fileparsing.create.ppt.error.data.empty", locale));
            }
        }
        try {
            Map result = this.createFileService.getFileDmcShareUrl(pptContentRequest, token, tenantId, locale);
            log.info("FileparsingController#getPPTDmcShareUrl elapsed time: {}ms", (Object)stopWatch.getTime());
            if (MapUtils.isNotEmpty((Map)result)) {
                if (result.get("errorMessage") != null) {
                    return ResultBean.fail((String)((String)result.get("errorMessage")));
                }
                return ResultBean.ok((Object)result);
            }
        }
        catch (Exception e) {
            log.info("FileparsingController#getPPTDmcShareUrl elapsed time: {}ms", (Object)stopWatch.getTime());
            log.error("getPPTDmcShareUrl\uff1a{}", (Throwable)e);
            return ResultBean.fail((String)("zh_TW".equals(locale) ? ZhConverterUtil.toTraditional((String)e.getMessage()) : ZhConverterUtil.toSimple((String)e.getMessage())));
        }
        return ResultBean.fail((String)CommonUtil.getMessageUtils().getMessageByLangName("message.fileparsing.get.dmc.token.error", locale));
    }

    @PostMapping(value={"getPDFDmcShareUrl"})
    public ResultBean<String> getPDFDmcShareUrl(@RequestBody Map<String, Object> pdfContentRequest, @RequestHeader(value="locale", required=false) String locale, @RequestHeader(value="token", required=true) String token) {
        AdqFileModel adqFileModel;
        log.info("FileparsingController#getPDFDmcShareUrl getPDFDmcShareUrl: {}", (Object)JSONUtils.toJsonString(pdfContentRequest));
        StopWatch stopWatch = StopWatch.createStarted();
        String tenantId = "";
        String fileId = "";
        String userId = "";
        if (!CollectionUtils.isEmpty(pdfContentRequest)) {
            if (pdfContentRequest.get("tenantId") == null || !StringUtils.hasLength((String)((String)pdfContentRequest.get("tenantId")))) {
                return ResultBean.fail((String)CommonUtil.getMessageUtils().getMessageByLangName("message.fileparsing.create.pdf.error.tenant.empty", locale));
            }
            tenantId = (String)pdfContentRequest.get("tenantId");
            if (!StringUtils.hasText((String)((String)pdfContentRequest.get("fileId")))) {
                return ResultBean.fail((String)CommonUtil.getMessageUtils().getMessageByLangName("message.fileparsing.create.pdf.error.fileId.empty", locale));
            }
            fileId = (String)pdfContentRequest.get("fileId");
            if (!StringUtils.hasText((String)((String)pdfContentRequest.get("userId")))) {
                return ResultBean.fail((String)CommonUtil.getMessageUtils().getMessageByLangName("message.fileparsing.exception.tenantIdOrUserId.empty", locale));
            }
            userId = (String)pdfContentRequest.get("userId");
        }
        if ((adqFileModel = this.adqService.getFile(tenantId, userId, locale, token, fileId)) != null && StringUtils.hasText((String)adqFileModel.getUrl())) {
            return ResultBean.ok((Object)adqFileModel.getUrl());
        }
        log.error("\u6ca1\u627e\u5230\u5386\u53f2\u8f6c\u6362\u6587\u4ef6\uff0c\u6545\u91cd\u65b0\u751f\u6210");
        try {
            String shareUrl = this.createFileService.coverPPTToPDF(fileId, (String)pdfContentRequest.get("fileName"), tenantId, locale, token, userId);
            if (!StringUtils.hasText((String)shareUrl) || !shareUrl.contains("http")) {
                return ResultBean.fail((String)CommonUtil.getMessageUtils().getMessageByLangName("message.fileparsing.cover.file.error", locale));
            }
            log.info("FileparsingController#getPDFDmcShareUrl elapsed time: {}ms", (Object)stopWatch.getTime());
            return ResultBean.ok((Object)shareUrl);
        }
        catch (Exception e) {
            log.info("FileparsingController#getPDFDmcShareUrl elapsed time: {}ms", (Object)stopWatch.getTime());
            log.error("getPDFDmcShareUrl\uff1a{}", (Object)e.getMessage());
            return ResultBean.fail((String)("zh_TW".equals(locale) ? ZhConverterUtil.toTraditional((String)e.getMessage()) : ZhConverterUtil.toSimple((String)e.getMessage())));
        }
    }

    @PostMapping(value={"deleteFile"})
    public ResultBean<Object> deleteFile(@RequestBody Map<String, String> request, @RequestHeader(value="locale", required=false) String locale, @RequestHeader(value="token", required=false) String token) {
        String userId = request.get("userId");
        String tenantId = request.get("tenantId");
        String fileId = request.get("pptId");
        String dmcFileId = request.get("pptDocId");
        AdqPPTModel pptModel = this.adqService.getPPT(tenantId, userId, locale, token, fileId);
        if (pptModel == null) {
            return ResultBean.fail((String)CommonUtil.getMessageUtils().getMessageByLangName("message.fileparsing.file.is.not.exits", locale));
        }
        if ("create".equals(pptModel.getPptType()) && DateTimeUtil.isBeforeNowDateTime((String)pptModel.getExpireDate()).booleanValue()) {
            return ResultBean.fail((String)CommonUtil.getMessageUtils().getMessageByLangName("message.fileparsing.The.resource.has.expired", locale));
        }
        Boolean flag = this.adqService.deletePPT(token, tenantId, locale, fileId, dmcFileId);
        if (flag.booleanValue()) {
            return ResultBean.ok((Object)CommonUtil.getMessageUtils().getMessageByLangName("message.fileparsing.delete.success", locale));
        }
        return ResultBean.fail((String)CommonUtil.getMessageUtils().getMessageByLangName("message.fileparsing.delete.error", locale));
    }

    @PostMapping(value={"modifyFile"})
    public ResultBean<Object> modifyFile(@RequestBody Map<String, String> request, @RequestHeader(value="locale", required=false) String locale, @RequestHeader(value="token", required=false) String token) {
        Boolean flag;
        String userId = request.get("userId");
        String tenantId = request.get("tenantId");
        String fileId = request.get("pptId");
        String dmcFileId = request.get("pptDocId");
        String fileName = request.get("fileName");
        Boolean template = request.get("template") == null ? false : Boolean.valueOf(request.get("template"));
        AdqPPTModel pptModel = this.adqService.getPPT(tenantId, userId, locale, token, fileId);
        if (pptModel == null) {
            return ResultBean.fail((String)CommonUtil.getMessageUtils().getMessageByLangName("message.fileparsing.file.is.not.exits", locale));
        }
        if ("create".equals(pptModel.getPptType()) && DateTimeUtil.isBeforeNowDateTime((String)pptModel.getExpireDate()).booleanValue()) {
            return ResultBean.fail((String)CommonUtil.getMessageUtils().getMessageByLangName("message.fileparsing.The.resource.has.expired", locale));
        }
        if ("template".equals(pptModel.getPptType())) {
            pptModel.setDefaultPpt(template);
        }
        if ((flag = this.createFileService.modifyFile(dmcFileId, pptModel, fileName, userId, tenantId, locale, token)).booleanValue()) {
            return ResultBean.ok((Object)CommonUtil.getMessageUtils().getMessageByLangName("message.fileparsing.modify.success", locale));
        }
        return ResultBean.fail((String)CommonUtil.getMessageUtils().getMessageByLangName("message.fileparsing.modify.error", locale));
    }

    @PostMapping(value={"listFile"})
    public ResultBean<Object> listFile(@RequestBody Map<String, String> request, @RequestHeader(value="locale", required=false) String locale, @RequestHeader(value="token", required=false) String token) {
        List adqPPTModelList;
        String userId = request.get("userId");
        String tenantId = request.get("tenantId");
        String pptType = request.get("pptType");
        Boolean defaultPpt = request.get("defaultPpt") == null ? null : Boolean.valueOf(request.get("defaultPpt"));
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("pptType", pptType);
        if (defaultPpt != null) {
            params.put("defaultPpt", defaultPpt);
        }
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        if (!"template".equals(pptType)) {
            result.put("limitDay", this.amountDay);
        }
        if (!CollectionUtils.isEmpty((Collection)(adqPPTModelList = this.adqService.listPPT(tenantId, userId, locale, token, params)))) {
            ArrayList<Object> newPPTList = new ArrayList<Object>(adqPPTModelList.size());
            Boolean hasDefaultPpt = false;
            for (Object adqPPTModel : adqPPTModelList) {
                if (adqPPTModel.getDefaultPpt().booleanValue()) {
                    hasDefaultPpt = true;
                }
                if ("create".equals(adqPPTModel.getPptType()) && DateTimeUtil.isBeforeNowDateTime((String)adqPPTModel.getExpireDate()).booleanValue()) {
                    boolean bl = this.adqService.deletePPT(token, tenantId, locale, adqPPTModel.getPptId(), adqPPTModel.getPptDocId());
                    if (bl) continue;
                    log.error("ppt\u5220\u9664\u5931\u8d25\uff0cppt\u4e3a:{}", (Object)JSONUtils.toJsonString((Object)adqPPTModel));
                    continue;
                }
                newPPTList.add(adqPPTModel);
            }
            if (!hasDefaultPpt.booleanValue()) {
                AdqPPTModel defaultSystemPPT = this.adqService.setDefaultSystemPPT(tenantId, locale, token);
                for (AdqPPTModel adqPPTModel : newPPTList) {
                    if (!adqPPTModel.getPptId().equals(defaultSystemPPT.getPptId())) continue;
                    adqPPTModel.setDefaultPpt(Boolean.valueOf(true));
                    this.adqService.savePPT(token, userId, tenantId, locale, adqPPTModel);
                    break;
                }
            }
            if (!CollectionUtils.isEmpty(newPPTList)) {
                int i;
                ArrayList systemPPTList = new ArrayList(2);
                for (i = 0; i < newPPTList.size(); ++i) {
                    if (!"system".equals(((AdqPPTModel)newPPTList.get(i)).getDataType())) continue;
                    systemPPTList.add(newPPTList.get(i));
                }
                for (i = 0; i < newPPTList.size(); ++i) {
                    if ("system".equals(((AdqPPTModel)newPPTList.get(i)).getDataType())) continue;
                    systemPPTList.add(newPPTList.get(i));
                }
                result.put("pptData", systemPPTList);
            } else {
                result.put("pptData", Collections.EMPTY_LIST);
            }
        } else {
            result.put("pptData", Collections.EMPTY_LIST);
        }
        return ResultBean.ok(result);
    }

    @PostMapping(value={"uploadFile"})
    public ResultBean<Object> uploadFile(@RequestParam(value="file") MultipartFile file, @RequestParam(value="tenantId") String tenantId, @RequestParam(value="userId") String userId, @RequestParam(value="template", required=false) String template, @RequestHeader(value="locale", required=false) String locale, @RequestHeader(value="token", required=false) String token) {
        Long startTime = System.currentTimeMillis();
        boolean isTemplate = true;
        if (StringUtils.hasText((String)template)) {
            isTemplate = Boolean.valueOf(template);
        }
        if (file == null || file.isEmpty()) {
            return ResultBean.fail((String)CommonUtil.getMessageUtils().getMessageByLangName("message.fileparsing.error.file.data.empty", locale));
        }
        String dmcToken = this.dmcService.getDMCUserToken(tenantId, "asada", "asadaM8@15f");
        if (!StringUtils.hasLength((String)dmcToken)) {
            return ResultBean.fail((String)CommonUtil.getMessageUtils().getMessageByLangName("message.fileparsing.get.dmc.token.error", locale));
        }
        Map shareUrl = this.createFileService.getPPTFileShareUrl(file, userId, tenantId, locale, token, dmcToken);
        if (shareUrl.containsKey("errorMessage")) {
            return ResultBean.fail((String)((String)shareUrl.get("errorMessage")));
        }
        if (MapUtils.isEmpty((Map)shareUrl)) {
            return ResultBean.fail((String)CommonUtil.getMessageUtils().getMessageByLangName("message.fileparsing.upload.error", locale));
        }
        boolean error = false;
        ArrayList<AdqPPTModel> pptModels = new ArrayList<AdqPPTModel>(1);
        String filename = file.getOriginalFilename();
        Map fileShareData = (Map)shareUrl.get(filename);
        String previewUrl = this.dmcService.getPreviewUrl(dmcToken, locale, tenantId, (String)fileShareData.get("fileId"), isTemplate);
        log.error("\u4e0a\u4f20\u6587\u4ef6\u5230dmc+\u89e3\u6790PPT\u539f\u59cb\u7ed3\u6784\u8017\u65f6:{} \u6beb\u79d2", (Object)(System.currentTimeMillis() - startTime));
        Long pptTime = System.currentTimeMillis();
        List pageDetails = (List)shareUrl.get("pageDetails");
        ConcurrentSkipListMap pptPageJsonList = new ConcurrentSkipListMap();
        ArrayList errorFlag = new ArrayList(1);
        try {
            System.setProperty("java.util.concurrent.ForkJoinPool.common.parallelism", "4");
            pageDetails.parallelStream().forEach(pageDetail -> {
                Map pptPageJsonMap = this.chatBiService.getPPTPageJson(token, locale, tenantId, pageDetail);
                if (pptPageJsonMap == null) {
                    errorFlag.add(true);
                }
                pptPageJsonList.putAll(pptPageJsonMap);
            });
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6PPT\u9875\u9762json\u5931\u8d25\uff0c\u9519\u8bef\u539f\u56e0{}\uff1a", (Object)e.getMessage());
            return ResultBean.fail((String)CommonUtil.getMessageUtils().getMessageByLangName("message.fileparsing.scrum.bi.analysis.error", locale));
        }
        if (CollectionUtils.isEmpty(pptPageJsonList) || errorFlag.size() > 0 && ((Boolean)errorFlag.get(0)).booleanValue()) {
            return ResultBean.fail((String)CommonUtil.getMessageUtils().getMessageByLangName("message.fileparsing.scrum.bi.analysis.error", locale));
        }
        log.error("\u8bed\u4e49\u7cbe\u7b80PPT\u9875\u9762\u603b\u8017\u65f6:{} \u6beb\u79d2", (Object)(System.currentTimeMillis() - pptTime));
        ArrayList pptPageJson = new ArrayList(pptPageJsonList.size());
        for (Map.Entry entry : pptPageJsonList.entrySet()) {
            pptPageJson.add(entry.getValue());
        }
        String templatePPTJson = JSONUtils.toJsonString(pptPageJson);
        log.error("\u751f\u6210\u7684PPT\u9875\u9762json\u4e3a:{}", (Object)templatePPTJson);
        Long savePptTime = System.currentTimeMillis();
        AdqPPTModel adqPPTModel = this.adqService.savePPT(token, userId, tenantId, locale, fileShareData, Boolean.valueOf(isTemplate), filename, previewUrl, pptPageJson, (String)shareUrl.get("coverPng"));
        if (adqPPTModel == null) {
            error = true;
        } else {
            adqPPTModel.setModifyPPT((Boolean)shareUrl.get("isModifyPPT"));
            pptModels.add(adqPPTModel);
        }
        log.error("adq\u5b58\u50a8PPT\u8017\u65f6:{} \u6beb\u79d2", (Object)(System.currentTimeMillis() - savePptTime));
        if (error) {
            return ResultBean.fail((String)CommonUtil.getMessageUtils().getMessageByLangName("message.fileparsing.upload.error", locale));
        }
        log.error("\u4e0a\u4f20\u6587\u4ef6\u603b\u8017\u65f6:{} \u6beb\u79d2", (Object)(System.currentTimeMillis() - startTime));
        return ResultBean.ok(pptModels);
    }

    @PostMapping(value={"v2/uploadFile"})
    public ResultBean<Object> uploadFile(@RequestParam(value="file") MultipartFile file, @RequestParam(value="tenantId") String tenantId, @RequestParam(value="userId") String userId, @RequestHeader(value="locale", required=false) String locale, @RequestHeader(value="token", required=false) String token) {
        Long startTime = System.currentTimeMillis();
        if (file == null || file.isEmpty()) {
            return ResultBean.fail((String)CommonUtil.getMessageUtils().getMessageByLangName("message.fileparsing.error.file.data.empty", locale));
        }
        String dmcToken = this.dmcService.getDMCUserToken(tenantId, "asada", "asadaM8@15f");
        if (!StringUtils.hasLength((String)dmcToken)) {
            return ResultBean.fail((String)CommonUtil.getMessageUtils().getMessageByLangName("message.fileparsing.get.dmc.token.error", locale));
        }
        Map shareUrl = this.createFileService.getFileShareUrl(file, userId, tenantId, locale, token, dmcToken, 0);
        if (shareUrl.containsKey("errorMessage")) {
            return ResultBean.fail((String)((String)shareUrl.get("errorMessage")));
        }
        if (MapUtils.isEmpty((Map)shareUrl)) {
            return ResultBean.fail((String)CommonUtil.getMessageUtils().getMessageByLangName("message.fileparsing.upload.error", locale));
        }
        String filename = file.getOriginalFilename();
        Map fileShareData = (Map)shareUrl.get(filename);
        String previewUrl = this.dmcService.getPreviewUrl(dmcToken, locale, tenantId, (String)fileShareData.get("fileId"), false);
        fileShareData.put("previewUrl", previewUrl);
        log.error("\u4e0a\u4f20\u6587\u4ef6\u603b\u8017\u65f6:{} \u6beb\u79d2", (Object)(System.currentTimeMillis() - startTime));
        return ResultBean.ok((Object)fileShareData);
    }

    @RequestMapping(value={"uploadByTest"})
    public ResultBean<Object> uploadByTest(@RequestHeader(value="locale", required=false) String locale, @RequestHeader(value="token", required=false) String token, @RequestBody AdqPPTModel request) {
        String dmcToken = this.dmcService.getDMCUserToken(request.getTenantId(), "asada", "asadaM8@15f");
        Map shareData = this.createFileService.getDMCShareUrl("/Users/wuyang/develope/git/athenaweb/fileparsing/\u84dd\u8272\u79d1\u6280.png", request.getTenantId(), locale, dmcToken);
        request.setPptCoverUrl((String)shareData.get("url"));
        String previewUrl = this.dmcService.getPreviewUrl(dmcToken, locale, request.getTenantId(), request.getPptDocId(), true);
        request.setPptPreviewUrl(previewUrl);
        Boolean adqPPTModel = this.adqService.savePPT(token, request.getUserId(), request.getTenantId(), locale, request);
        return ResultBean.ok((Object)adqPPTModel);
    }

    @PostMapping(value={"getDmcUrlByMarkDown"})
    public ResultBean<Object> getDmcUrlByMarkDown(@RequestBody Map<String, String> request, @RequestHeader(value="locale", required=false) String locale, @RequestHeader(value="token", required=false) String token) {
        log.info("FileparsingController#getDmcUrlByMarkDown getDmcUrlByMarkDown: request:{}, token:{}", (Object)JSONUtils.toJsonString(request), (Object)token);
        StopWatch stopWatch = StopWatch.createStarted();
        String userId = request.get("userId");
        String tenantId = request.get("tenantId");
        String data = request.get("markdownData");
        String fileName = request.get("fileName");
        String fileType = request.get("fileType");
        if (!StringUtils.hasText((String)tenantId)) {
            return ResultBean.fail((String)CommonUtil.getMessageUtils().getMessageByLangName("message.fileparsing.error.tenant.empty", locale));
        }
        if (!StringUtils.hasText((String)data)) {
            return ResultBean.fail((String)CommonUtil.getMessageUtils().getMessageByLangName("message.fileparsing.error.data.empty", locale));
        }
        try {
            Map result = this.createFileService.coverMKToFile(data, fileName, userId, token, tenantId, locale, fileType);
            log.info("FileparsingController#getDmcUrlByMarkDown elapsed time: {}ms, shareUrl: {}", (Object)stopWatch.getTime(), (Object)JSONUtils.toJsonString((Object)result));
            if (MapUtils.isNotEmpty((Map)result)) {
                if (result.get("errorMessage") != null) {
                    return ResultBean.fail((String)((String)result.get("errorMessage")));
                }
                return ResultBean.ok((Object)result);
            }
        }
        catch (Exception e) {
            log.info("FileparsingController#getDmcUrlByMarkDown elapsed time: {}ms", (Object)stopWatch.getTime());
            log.error("getDmcUrlByMarkDown\uff1a{}", (Object)e.getMessage());
            return ResultBean.fail((String)("zh_TW".equals(locale) ? ZhConverterUtil.toTraditional((String)e.getMessage()) : ZhConverterUtil.toSimple((String)e.getMessage())));
        }
        return ResultBean.fail((String)CommonUtil.getMessageUtils().getMessageByLangName("message.fileparsing.cover.file.error", locale));
    }
}

