/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.fileparsing.reasoning.executor.prompt;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.fileparsing.client.GPT_CLIENT;
import com.digiwin.fileparsing.common.exception.GptCallAssert;
import com.digiwin.fileparsing.common.util.CommonUtil;
import com.digiwin.fileparsing.common.util.SpringContextUtil;
import com.digiwin.fileparsing.reasoning.executor.Executor;
import com.digiwin.fileparsing.reasoning.pipeline.result.Output;
import com.digiwin.fileparsing.reasoning.prompt.TemplateLocalFileBroker;
import com.digiwin.fileparsing.reasoning.search.config.RhEndpointConfig;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public abstract class PromptLiteExecutor
implements Executor {
    private static final Logger log = LoggerFactory.getLogger(PromptLiteExecutor.class);
    public static final String RESULT_NOT_JSON = "NOT_JSON_";
    private static final Map<String, GPT_CLIENT> GPT_CLIENT_MAP = new HashMap();
    private static final List<String> needAppendQList = Arrays.asList("Filter", "AnalysisPlanning", "Dimension");
    private static final String DEFAULT_GPT_CLIENT = "RH_HK_GPT4";
    private GPT_CLIENT gptClient = (GPT_CLIENT)GPT_CLIENT_MAP.getOrDefault("RH_HK_GPT4", GPT_CLIENT.RH.HK.GPT4);

    public abstract String getType();

    public abstract String getName();

    public abstract GPT_CLIENT getGptClient();

    protected String getPromptName() {
        return this.getType() + this.getName();
    }

    public static PromptLiteExecutor OfExecutor(String type, String name, GPT_CLIENT gpt_client) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public static PromptLiteExecutor OfConditionExecutor(String type, String name, GPT_CLIENT gpt_client) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private String systemMessage(JSONObject context) {
        return ((TemplateLocalFileBroker)SpringContextUtil.getBean(TemplateLocalFileBroker.class)).get(this.getType(), this.getName()).getContent((Map)context);
    }

    public String callGpt(String systemMessage, String userMessage, String appendQuest, Integer maxToken, String temperature, String token) {
        StopWatch stopWatch = StopWatch.createStarted();
        RhEndpointConfig rhEndpointConfig = (RhEndpointConfig)SpringContextUtil.getBean(RhEndpointConfig.class);
        String result = this.getGptClient().call(systemMessage, Objects.isNull(appendQuest) ? userMessage : userMessage.concat(appendQuest), rhEndpointConfig.getHkEndpoint(), maxToken, temperature, token);
        stopWatch.stop();
        log.info("GPT calling time: {}ms, prompt: {}", (Object)stopWatch.getTime(), (Object)this.getPromptName());
        String data = (String)GptCallAssert.JSON_PARSE_FAIL_ASSERT.tryCatch(() -> {
            JSONObject jsonObject = JSONObject.parseObject((String)result);
            if (StringUtils.isNotEmpty((CharSequence)jsonObject.getString("code")) && "0".equals(jsonObject.getString("code"))) {
                return CommonUtil.extractDataBetweenBraces((String)jsonObject.getString("data"));
            }
            return null;
        }, new Object[0]);
        return StringUtils.isNotBlank((CharSequence)data) ? data : result;
    }

    public Output doProcess(JSONObject context) {
        return null;
    }

    public String pipelineName() {
        return this.getPromptName();
    }

    static {
        for (GPT_CLIENT.RH.HK hK : GPT_CLIENT.RH.HK.values()) {
            GPT_CLIENT_MAP.put("RH_HK_" + hK, hK);
            GPT_CLIENT_MAP.put("RH_" + hK, hK);
        }
        for (GPT_CLIENT.RH.HK hK : GPT_CLIENT.STANDARD_OPENAI.AZURE.values()) {
            GPT_CLIENT_MAP.put("AZURE_" + hK.getModel().toString(), hK);
        }
        for (GPT_CLIENT.RH.HK hK : GPT_CLIENT.STANDARD_OPENAI.AI_PROXY.values()) {
            GPT_CLIENT_MAP.put("AI_PROXY_" + hK.toString(), hK);
        }
        for (GPT_CLIENT.RH.HK hK : GPT_CLIENT.STANDARD_OPENAI.AI_PROXY_VIP.values()) {
            GPT_CLIENT_MAP.put("AI_PROXY_VIP_" + hK.toString(), hK);
        }
        for (GPT_CLIENT.RH.HK hK : GPT_CLIENT.RH.PASS.values()) {
            GPT_CLIENT_MAP.put("RH_" + hK, hK);
        }
    }
}

