/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.fileparsing.reasoning.pipeline.result;

import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public class Output {
    private boolean endpoint = false;
    private final JSONObject outputContext = new JSONObject();

    private Output() {
    }

    public static Output finish() {
        Output output = new Output();
        output.endpoint = true;
        return output;
    }

    public static Output finish(JSONObject result) {
        Output output = new Output();
        output.keep(result);
        output.endpoint = true;
        return output;
    }

    public static Output finish(String key, Object result) {
        Output output = new Output();
        output.endpoint = true;
        output.keep(key, result);
        return output;
    }

    public static Output through() {
        return new Output();
    }

    public static Output through(JSONObject result) {
        Output output = new Output();
        output.keep(result);
        return output;
    }

    public static Output through(Map.Entry<String, Object> result) {
        Output output = new Output();
        output.keep(result);
        return output;
    }

    public static Output through(Collection<Map.Entry<String, Object>> result) {
        Output output = new Output();
        output.keep(result);
        return output;
    }

    public static Output through(String key, Object result) {
        Output output = new Output();
        output.keep(key, result);
        return output;
    }

    public Output keep(Map.Entry<String, Object> result) {
        this.outputContext.put(result.getKey(), result.getValue());
        return this;
    }

    public Output keep(JSONObject result) {
        this.outputContext.putAll((Map)result);
        return this;
    }

    public Output keep(Collection<Map.Entry<String, Object>> result) {
        this.outputContext.putAll(result.stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        return this;
    }

    public Output keep(String key, Object result) {
        this.outputContext.put(key, result);
        return this;
    }

    public <T> Output assertOutput(Consumer<T> assertFun, Function<Output, T> outputFunction) {
        assertFun.accept(outputFunction.apply(this));
        return this;
    }

    public List<Output> split(String key) {
        return this.splitContext(key).stream().map(Output::through).collect(Collectors.toList());
    }

    public List<JSONObject> splitContext(String key) {
        return this.outputContext.getJSONArray(key).stream().map(context -> (JSONObject)context).collect(Collectors.toList());
    }

    public boolean isEndpoint() {
        return this.endpoint;
    }

    public JSONObject getOutputContext() {
        return this.outputContext;
    }
}

