/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.fileparsing.reasoning.search.client;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.fileparsing.common.exception.ChatBiException;
import com.digiwin.fileparsing.common.exception.SrhExceptionAssert;
import com.digiwin.fileparsing.reasoning.search.client.EsClient;
import com.digiwin.fileparsing.reasoning.search.config.EsHostConfig;
import com.digiwin.fileparsing.reasoning.search.define.EsRequest;
import java.io.IOException;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseException;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.sniff.Sniffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Component;

@Component
@DependsOn(value={"esHostConfig"})
public class EsRestClient
implements EsClient,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(EsRestClient.class);
    private final Object $lock = new Object[0];
    @Autowired
    private EsHostConfig esHostConfig;
    private boolean useSniffer = false;
    private RestClient client;
    private Sniffer sniffer;

    @PostConstruct
    public void init() {
        this.client = this.buildRestClient();
        log.info("es rest client \u521b\u5efa:" + this);
        if (this.useSniffer) {
            this.sniffer = Sniffer.builder((RestClient)this.client).build();
        }
    }

    public void destroy() {
        if (ObjectUtils.allNotNull((Object[])new Object[]{this.sniffer})) {
            this.sniffer.close();
        }
        this.closeClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RestClient buildRestClient() {
        Object object = this.$lock;
        synchronized (object) {
            this.closeClient();
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.esHostConfig.getEsUserName(), this.esHostConfig.getEsPassWord()));
            return RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(this.esHostConfig.getEsHost(), this.esHostConfig.getEsPort().intValue(), this.esHostConfig.getEsScheme())}).setHttpClientConfigCallback(arg_0 -> EsRestClient.lambda$buildRestClient$1((CredentialsProvider)credentialsProvider, arg_0)).build();
        }
    }

    public String doGet(String url) {
        return this.doRequest(EsRequest.GET, url, Integer.valueOf(5));
    }

    public String doDelete(String url) {
        return this.doRequest(EsRequest.DELETE, url, Integer.valueOf(5));
    }

    public String doPut(String url, String param) {
        return this.doRequest(EsRequest.PUT, url, param, Integer.valueOf(5));
    }

    public String doPost(String url, String param) {
        return this.doRequest(EsRequest.POST, url, param, Integer.valueOf(5));
    }

    private String doRequest(EsRequest esRequest, String url, String param, Integer maxRetire) {
        Request request = esRequest.withUrl(url);
        request.setEntity((HttpEntity)new StringEntity(param, ContentType.APPLICATION_JSON));
        return this.doRequest(request, maxRetire);
    }

    private String doRequest(EsRequest esRequest, String url, Integer maxRetire) {
        return this.doRequest(esRequest.withUrl(url), maxRetire);
    }

    private String doRequest(Request request, Integer maxRetire) {
        if (maxRetire > 0) {
            try {
                return this.doRequest(request);
            }
            catch (IOException e) {
                return this.doRequest(request, Integer.valueOf(maxRetire - 1));
            }
            catch (Exception e) {
                throw e;
            }
        }
        throw SrhExceptionAssert.ES_OPERATION_FALI.newException(new Object[]{"\u8fbe\u5230\u6700\u5927\u5c1d\u8bd5\u6b21\u6570"});
    }

    private String doRequest(Request request) throws IOException {
        try {
            Response response = this.client.performRequest(request);
            return this.GetHttpEntity(response);
        }
        catch (ResponseException e) {
            if (e.getResponse().getStatusLine().getStatusCode() == 404) {
                return this.GetHttpEntity(e.getResponse());
            }
            JSONObject dsl = new JSONObject();
            if (!request.getMethod().equalsIgnoreCase("GET") && null != request.getEntity()) {
                dsl.put("dsl", (Object)JSONObject.parseObject((String)this.GetHttpEntity(request)));
            }
            ChatBiException exception = SrhExceptionAssert.ES_QUERY_FAIL.newException(new Object[]{dsl, e.getResponse()}).addDetail((Object)JSONObject.parseObject((String)this.GetHttpEntity(e.getResponse().getEntity()))).addDetail((Object)dsl);
            throw exception;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw SrhExceptionAssert.ES_OPERATION_FALI.newException(new Object[]{e.getMessage()});
        }
    }

    public void closeClient() {
        if (null != this.client) {
            try {
                this.client.close();
            }
            catch (IOException e) {
                throw SrhExceptionAssert.ES_CONNECTION_CLOSE_FAIL.newException(new Object[]{e.getMessage()});
            }
        }
    }

    private String GetHttpEntity(Request request) {
        return this.GetHttpEntity(request.getEntity());
    }

    private String GetHttpEntity(Response response) {
        return this.GetHttpEntity(response.getEntity());
    }

    private String GetHttpEntity(HttpEntity httpEntity) {
        try {
            return EntityUtils.toString((HttpEntity)httpEntity);
        }
        catch (IOException e) {
            throw SrhExceptionAssert.RESPONSE_READ_FAIL.newException(new Object[]{e.getMessage()});
        }
    }

    public String toString() {
        return "EsRestClient{esHostConfig=" + this.esHostConfig + '}';
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$buildRestClient$1(CredentialsProvider credentialsProvider, HttpAsyncClientBuilder httpClientBuilder) {
        httpClientBuilder.disableAuthCaching();
        httpClientBuilder.setKeepAliveStrategy((response, context) -> 600000L);
        return httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
    }
}

