/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.fileparsing.reasoning.search.facade;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.fileparsing.reasoning.search.define.RequestParam;
import com.digiwin.fileparsing.reasoning.search.define.RequestPath;
import com.digiwin.fileparsing.reasoning.search.dto.RequestDto;
import com.digiwin.fileparsing.reasoning.search.facade.EsFacade;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class EsQueryFacade {
    private static final Logger log = LoggerFactory.getLogger(EsQueryFacade.class);
    @Resource
    private EsFacade esFacade;

    public JSONObject queryById(RequestDto requestDto) {
        return this.esFacade.doGet(RequestPath.OPERATION_BY_ID.create(new String[]{requestDto.getIndexName(), requestDto.getId()}));
    }

    public JSONObject countByParam(RequestDto requestDto) {
        return this.esFacade.doPost(RequestPath.DO_COUNT.create(new String[]{requestDto.getIndexName()}), requestDto.getParam());
    }

    public JSONObject queryByParam(RequestDto requestDto) {
        return this.esFacade.doPost(RequestPath.SEARCH_DSL.create(new String[]{requestDto.getIndexName(), StringUtils.isNotBlank((CharSequence)requestDto.getQueryString()) ? requestDto.getQueryString() : ""}), requestDto.getParam());
    }

    public JSONObject searchByParam(RequestDto requestDto) {
        return this.esFacade.doPost(RequestPath.SEARCH_SQL.create(new String[0]), RequestParam.SEARCH_BY_PARAM.create(new String[]{requestDto.getParam()}));
    }
}

