/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.fileparsing.reasoning.template;

import com.digiwin.fileparsing.reasoning.template.PromptTemplateLoader;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

@Component
public class PromptFormatEngine
implements InitializingBean {
    @Resource
    private PromptTemplateLoader promptTemplateLoader;
    private static final Integer templateCacheTime = 30;
    private final Configuration cfg = new Configuration(Configuration.VERSION_2_3_30);

    public String transform2String(String templateCode, Map<String, Object> input) {
        try {
            StringWriter stringWriter = new StringWriter();
            this.getTemplate(templateCode).process(input, (Writer)stringWriter);
            return stringWriter.toString();
        }
        catch (TemplateException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Template getTemplate(String templateCode) throws IOException {
        return this.cfg.getTemplate(templateCode);
    }

    public void afterPropertiesSet() throws Exception {
        this.initConfiguration();
    }

    private void initConfiguration() {
        this.cfg.setDefaultEncoding("UTF-8");
        this.cfg.setLocale(Locale.CHINESE);
        this.cfg.setNumberFormat("#");
        this.cfg.setTemplateUpdateDelayMilliseconds((long)templateCacheTime.intValue() * 1000L);
        this.extendCfg();
    }

    private void extendCfg() {
        TemplateLoader[] loaders = new TemplateLoader[]{this.promptTemplateLoader};
        MultiTemplateLoader mtl = new MultiTemplateLoader(loaders);
        this.cfg.setTemplateLoader((TemplateLoader)mtl);
    }
}

