/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.fileparsing.service;

import com.digiwin.fileparsing.beans.AdqFileModel;
import com.digiwin.fileparsing.beans.AdqPPTModel;
import com.digiwin.fileparsing.beans.AthenaBasicHttpRequestHead;
import com.digiwin.fileparsing.beans.DmcShareFileRequest;
import com.digiwin.fileparsing.common.util.DateTimeUtil;
import com.digiwin.fileparsing.common.util.JSONUtils;
import com.digiwin.fileparsing.service.AdqService;
import com.digiwin.fileparsing.service.DmcService;
import com.digiwin.fileparsing.service.HttpService;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class AdqService {
    private static final Logger log = LoggerFactory.getLogger(AdqService.class);
    private static final String API_PREFIX = "/restful/service/agiledataquery/";
    @Value(value="${dap.adq.url}")
    private String adqUrl;
    @Autowired
    private HttpService httpService;
    @Autowired
    private DmcService dmcService;

    public AdqPPTModel savePPT(String userToken, String userId, String tenantId, String locale, Map<String, Object> fileShareData, Boolean template, String fileName, String previewUrl, List<Object> templatePPTJson, String coverPng) {
        String url = this.adqUrl + API_PREFIX + "ppt/save";
        HashMap<String, Object> params = new HashMap<String, Object>(9);
        params.put("pptName", fileName);
        params.put("pptDocId", fileShareData.get("fileId"));
        params.put("pptUrl", fileShareData.get("url"));
        params.put("pptPreviewUrl", previewUrl);
        params.put("expireDate", fileShareData.get("expireDate"));
        params.put("createDate", fileShareData.get("createDate"));
        params.put("deleteFile", fileShareData.get("deleteFile"));
        params.put("pptPageSize", fileShareData.get("pptPageSize"));
        if (template.booleanValue()) {
            params.put("pptType", "template");
            params.put("defaultPpt", true);
            params.put("pptContent", templatePPTJson);
            params.put("pptCoverUrl", coverPng);
        } else {
            params.put("pptType", "create");
            params.put("defaultPpt", false);
        }
        params.put("dataType", "user");
        params.put("tenantId", tenantId);
        params.put("userId", userId);
        try {
            Map response = this.httpService.doPostForEntity(url, new AthenaBasicHttpRequestHead(tenantId, locale, userToken).setRouterKey(tenantId), (Object)JSONUtils.toJsonString(params), Map.class);
            if (!CollectionUtils.isEmpty((Map)response) && "200".equals(response.get("status").toString())) {
                if (!ObjectUtils.isEmpty(response.get("response")) && response.get("response") instanceof Map && ((Map)response.get("response")).get("data") instanceof Map && MapUtils.isNotEmpty((Map)((Map)((Map)response.get("response")).get("data")))) {
                    return (AdqPPTModel)JSONUtils.parseObject((String)JSONUtils.toJsonString(((Map)response.get("response")).get("data")), AdqPPTModel.class);
                }
                return null;
            }
        }
        catch (Exception e) {
            log.error("\u5b58\u50a8\u5230ADQ\u5931\u8d25\uff0c\u9519\u8bef\u539f\u56e0{}\uff1a", (Object)e.getMessage());
        }
        return null;
    }

    public Boolean savePPT(String userToken, String userId, String tenantId, String locale, AdqPPTModel pptModel) {
        String url = this.adqUrl + API_PREFIX + "ppt/save";
        try {
            Map response = this.httpService.doPostForEntity(url, new AthenaBasicHttpRequestHead(tenantId, locale, userToken).setRouterKey(tenantId), (Object)JSONUtils.toJsonString((Object)pptModel), Map.class);
            if (!CollectionUtils.isEmpty((Map)response) && "200".equals(response.get("status").toString())) {
                return true;
            }
        }
        catch (Exception e) {
            log.error("\u5b58\u50a8PPT\u5230ADQ\u5931\u8d25\uff0c\u9519\u8bef\u539f\u56e0{}\uff1a", (Object)e.getMessage());
        }
        return false;
    }

    public List<AdqPPTModel> listPPT(String tenantId, String userId, String locale, String userToken, Map<String, Object> params) {
        String url = this.adqUrl + API_PREFIX + "ppt/list";
        HashMap<String, Object> bodyParams = new HashMap<String, Object>(8);
        bodyParams.put("tenantId", tenantId);
        bodyParams.put("userId", userId);
        bodyParams.putAll(params);
        try {
            Map response = this.httpService.doPostForEntity(url, new AthenaBasicHttpRequestHead(tenantId, locale, userToken).setRouterKey(tenantId), (Object)JSONUtils.toJsonString(bodyParams), Map.class);
            if (!CollectionUtils.isEmpty((Map)response) && "200".equals(response.get("status").toString())) {
                return JSONUtils.toList((String)JSONUtils.toJsonString(response.get("response")), AdqPPTModel.class);
            }
        }
        catch (Exception e) {
            log.error("\u8c03\u7528ADQ\u83b7\u53d6PPT\u5217\u8868\u5931\u8d25\uff0c\u9519\u8bef\u539f\u56e0{}\uff1a", (Object)e.getMessage());
        }
        return Collections.emptyList();
    }

    public AdqPPTModel setDefaultSystemPPT(String tenantId, String locale, String token) {
        String url = this.adqUrl + API_PREFIX + "ppt/setDefaultSystemPpt";
        1 responseType = new /* Unavailable Anonymous Inner Class!! */;
        try {
            ResponseEntity responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead(tenantId, locale, token).setRouterKey(tenantId), (ParameterizedTypeReference)responseType);
            if (responseEntity.getStatusCode().is2xxSuccessful() && !CollectionUtils.isEmpty((Map)((Map)responseEntity.getBody())) && ((Map)responseEntity.getBody()).get("response") != null) {
                return (AdqPPTModel)JSONUtils.parseObject((String)JSONUtils.toJsonString(((Map)responseEntity.getBody()).get("response")), AdqPPTModel.class);
            }
        }
        catch (Exception e) {
            log.error("\u8c03\u7528ADQ\u83b7\u53d6\u9ed8\u8ba4PPT\u5931\u8d25\uff0c\u9519\u8bef\u539f\u56e0:{}", (Object)e.getMessage());
        }
        return new AdqPPTModel();
    }

    public AdqPPTModel getPPT(String tenantId, String userId, String locale, String token, String fileId) {
        String url = this.adqUrl + API_PREFIX + "ppt/get?pptId=" + fileId;
        2 responseType = new /* Unavailable Anonymous Inner Class!! */;
        try {
            ResponseEntity responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead(tenantId, locale, token).setRouterKey(tenantId), (ParameterizedTypeReference)responseType);
            if (responseEntity.getStatusCode().is2xxSuccessful() && !CollectionUtils.isEmpty((Map)((Map)responseEntity.getBody())) && ((Map)responseEntity.getBody()).get("response") != null) {
                return (AdqPPTModel)JSONUtils.parseObject((String)JSONUtils.toJsonString(((Map)responseEntity.getBody()).get("response")), AdqPPTModel.class);
            }
        }
        catch (Exception e) {
            log.error("\u8c03\u7528ADQ\u83b7\u53d6PPT\u5931\u8d25\uff0cpptId\u4e3a:{}\uff0c\u9519\u8bef\u539f\u56e0:{}", (Object)fileId, (Object)e.getMessage());
        }
        return null;
    }

    public Boolean deletePPT(String userToken, String tenantId, String locale, String pptId, String pptDocId) {
        block6: {
            String url = this.adqUrl + API_PREFIX + "ppt/delete";
            HashMap<String, String> params = new HashMap<String, String>(2);
            params.put("pptId", pptId);
            params.put("pptDocId", pptDocId);
            3 responseType = new /* Unavailable Anonymous Inner Class!! */;
            try {
                ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(tenantId, locale, userToken).setRouterKey(tenantId), JSONUtils.toJsonString(params), (ParameterizedTypeReference)responseType);
                if (!responseEntity.getStatusCode().is2xxSuccessful()) break block6;
                if (!CollectionUtils.isEmpty((Map)((Map)responseEntity.getBody())) && ((Map)responseEntity.getBody()).get("response") != null && ((Map)((Map)responseEntity.getBody()).get("response")).get("dmcDeleted") != null && !((Boolean)((Map)((Map)responseEntity.getBody()).get("response")).get("dmcDeleted")).booleanValue()) {
                    try {
                        String dmcToken = this.dmcService.getDMCUserToken(tenantId, "asada", "asadaM8@15f");
                        if (!StringUtils.hasLength((String)dmcToken)) {
                            return true;
                        }
                        DmcShareFileRequest fileRequest = new DmcShareFileRequest();
                        fileRequest.setFileId(pptDocId);
                        fileRequest.setDeleteFile(Boolean.valueOf(true));
                        fileRequest.setExpireDate(DateTimeUtil.getNextWeekTimeToString((Integer)1));
                        this.dmcService.getFileShareData(dmcToken, locale, tenantId, fileRequest);
                    }
                    catch (Exception e) {
                        log.error("\u8c03\u7528\u6587\u6863\u4e2d\u5fc3\u5220\u9664\u6587\u4ef6\u62a5\u9519\uff0c\u9519\u8bef\u4fe1\u606f:{}", (Object)e.getMessage());
                    }
                }
                return true;
            }
            catch (Exception e) {
                log.error("\u8c03\u7528ADQ\u5220\u9664PPT\u5931\u8d25\uff0c\u9519\u8bef\u539f\u56e0{}\uff1a", (Object)e.getMessage());
            }
        }
        return false;
    }

    public Boolean deleteFile(String userToken, String tenantId, String locale, String pptId, String pptDocId) {
        block8: {
            String url = this.adqUrl + API_PREFIX + "file/delete";
            HashMap<String, String> params = new HashMap<String, String>(2);
            if (StringUtils.hasText((String)pptId)) {
                params.put("id", pptId);
            }
            if (StringUtils.hasText((String)pptDocId)) {
                params.put("dmcId", pptDocId);
            }
            if (params.isEmpty()) {
                return false;
            }
            4 responseType = new /* Unavailable Anonymous Inner Class!! */;
            try {
                ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(tenantId, locale, userToken).setRouterKey(tenantId), JSONUtils.toJsonString(params), (ParameterizedTypeReference)responseType);
                if (!responseEntity.getStatusCode().is2xxSuccessful()) break block8;
                try {
                    String dmcToken = this.dmcService.getDMCUserToken(tenantId, "asada", "asadaM8@15f");
                    if (!StringUtils.hasLength((String)dmcToken)) {
                        return true;
                    }
                    DmcShareFileRequest fileRequest = new DmcShareFileRequest();
                    fileRequest.setFileId(pptDocId);
                    fileRequest.setDeleteFile(Boolean.valueOf(true));
                    fileRequest.setExpireDate(DateTimeUtil.getNextWeekTimeToString((Integer)1));
                    this.dmcService.getFileShareData(dmcToken, locale, tenantId, fileRequest);
                }
                catch (Exception e) {
                    log.error("\u8c03\u7528\u6587\u6863\u4e2d\u5fc3\u5220\u9664\u6587\u4ef6\u62a5\u9519\uff0c\u9519\u8bef\u4fe1\u606f:{}", (Object)e.getMessage());
                }
                return true;
            }
            catch (Exception e) {
                log.error("\u8c03\u7528ADQ\u5220\u9664\u6587\u4ef6{}\u5931\u8d25\uff0c\u9519\u8bef\u539f\u56e0{}\uff1a", (Object)pptId, (Object)e.getMessage());
            }
        }
        return false;
    }

    public Boolean saveFile(String userToken, String userId, String tenantId, String locale, String fileName, Map<String, Object> shareData, String filePreviewUrl, String fileId) {
        String url = this.adqUrl + API_PREFIX + "file/save";
        HashMap<String, Object> params = new HashMap<String, Object>(9);
        params.put("name", fileName);
        params.put("dmcId", fileId);
        params.put("url", shareData.get("url"));
        if (StringUtils.hasText((String)filePreviewUrl)) {
            params.put("previewUrl", filePreviewUrl);
        }
        params.put("expireDate", shareData.get("expireDate"));
        params.put("createDate", shareData.get("createDate"));
        params.put("deleteFile", shareData.get("deleteFile"));
        params.put("pageSize", shareData.get("pptPageSize"));
        params.put("type", "pdf");
        params.put("tenantId", tenantId);
        params.put("userId", userId);
        try {
            Map response = this.httpService.doPostForEntity(url, new AthenaBasicHttpRequestHead(tenantId, locale, userToken).setRouterKey(tenantId), (Object)JSONUtils.toJsonString(params), Map.class);
            if (!CollectionUtils.isEmpty((Map)response) && "200".equals(response.get("status").toString())) {
                return true;
            }
        }
        catch (Exception e) {
            log.error("\u5b58\u50a8\u6587\u4ef6\u5230ADQ\u5931\u8d25\uff0c\u9519\u8bef\u539f\u56e0{}\uff1a", (Object)e.getMessage());
        }
        return false;
    }

    public AdqFileModel getFile(String tenantId, String userId, String locale, String token, String fileId) {
        String url = this.adqUrl + API_PREFIX + "file/get?dmcId=" + fileId;
        5 responseType = new /* Unavailable Anonymous Inner Class!! */;
        try {
            ResponseEntity responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead(tenantId, locale, token).setRouterKey(tenantId), (ParameterizedTypeReference)responseType);
            if (responseEntity.getStatusCode().is2xxSuccessful() && !CollectionUtils.isEmpty((Map)((Map)responseEntity.getBody())) && ((Map)responseEntity.getBody()).get("response") != null) {
                return (AdqFileModel)JSONUtils.parseObject((String)JSONUtils.toJsonString(((Map)responseEntity.getBody()).get("response")), AdqFileModel.class);
            }
        }
        catch (Exception e) {
            log.error("\u8c03\u7528ADQ\u83b7\u53d6\u6587\u4ef6\u5931\u8d25\uff0cfileId\u4e3a:{}\uff0c\u9519\u8bef\u539f\u56e0:{}", (Object)fileId, (Object)e.getMessage());
        }
        return null;
    }
}

