/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.fileparsing.service;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.digiwin.fileparsing.beans.DmcFileRequest;
import com.digiwin.fileparsing.beans.DmcFileResponse;
import com.digiwin.fileparsing.beans.DmcShareFileRequest;
import com.digiwin.fileparsing.beans.ExcelSheet;
import com.digiwin.fileparsing.beans.TableSchema;
import com.digiwin.fileparsing.beans.entity.UserReportRelationEntity;
import com.digiwin.fileparsing.beans.entity.UserReportsEntity;
import com.digiwin.fileparsing.beans.pojos.ReportV2Dto;
import com.digiwin.fileparsing.common.DmcServiceInvoker;
import com.digiwin.fileparsing.common.enums.ReportTypeEnum;
import com.digiwin.fileparsing.common.exception.BussinessException;
import com.digiwin.fileparsing.common.util.CommonUtil;
import com.digiwin.fileparsing.common.util.DateTimeUtil;
import com.digiwin.fileparsing.common.util.JSONUtils;
import com.digiwin.fileparsing.common.util.SpringContextUtil;
import com.digiwin.fileparsing.common.util.StringUtil;
import com.digiwin.fileparsing.mapper.mysql.onlyRead.ReportReadMapper;
import com.digiwin.fileparsing.mapper.mysql.readAndWrite.ReportWriteMapper;
import com.digiwin.fileparsing.reasoning.executor.ExecutorFactory;
import com.digiwin.fileparsing.reasoning.pipeline.Pipeline;
import com.digiwin.fileparsing.reasoning.prompt.TemplateLocalFileBroker;
import com.digiwin.fileparsing.service.AnalysisReportService;
import com.digiwin.fileparsing.service.DmcService;
import com.digiwin.fileparsing.service.ReportService;
import com.github.houbb.opencc4j.util.ZhConverterUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class AnalysisReportService {
    private static final Logger log = LoggerFactory.getLogger(AnalysisReportService.class);
    @Autowired
    private ReportWriteMapper reportMapper;
    @Autowired
    private ReportReadMapper reportReadMapper;
    @Autowired
    private DmcServiceInvoker dmcServiceInvoker;
    @Autowired
    private DmcService dmcService;
    @Autowired
    private ReportService reportService;
    private static final int maxLockTime = 5;
    private static final int maxRetryTimes = 3;
    @Autowired
    @Qualifier(value="excelThreadPool")
    private ThreadPoolTaskExecutor executor;
    public static final String SENTENCES_CONNECTOR_SYMBOL = "|";

    public String getDmcShareUrl(Map<String, Object> excelRequest, String tenantId, String locale) {
        String fileName;
        if (excelRequest.get("fileName") != null) {
            fileName = String.valueOf(excelRequest.get("fileName"));
        } else {
            Date now = new Date(System.currentTimeMillis());
            fileName = DateTimeUtil.format((Date)now);
        }
        try {
            List excelSheets = JSONUtils.toList((String)JSONUtils.toJsonString((Object)excelRequest.get("fileData")), ExcelSheet.class);
            fileName = this.dmcServiceInvoker.createExcel(fileName, excelSheets, locale);
        }
        catch (Exception e) {
            log.error("\u751f\u6210\u6587\u4ef6\u5931\u8d25\uff0c\u9519\u8bef\u539f\u56e0:{}", (Object)e.getMessage());
        }
        String token = this.dmcService.getDMCUserToken(tenantId, "asada", "asadaM8@15f");
        if (!StringUtils.hasLength((String)token)) {
            return CommonUtil.getMessageUtils().getMessageByLangName("message.fileparsing.download.error", locale);
        }
        DmcFileResponse fileResponse = this.dmcService.uploadFile(token, locale, tenantId, DmcFileRequest.build((String)fileName, (String)fileName, (String)tenantId));
        if (fileResponse != null) {
            DmcShareFileRequest fileRequest = new DmcShareFileRequest();
            fileRequest.setAllowCount(Integer.valueOf(1));
            fileRequest.setDeleteFile(Boolean.valueOf(true));
            fileRequest.setFileId(fileResponse.getId());
            String url = this.dmcService.getShareUrl(token, locale, tenantId, fileRequest);
            if (StringUtils.hasLength((String)url)) {
                return url;
            }
        }
        return CommonUtil.getMessageUtils().getMessageByLangName("message.fileparsing.download.error", locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public JSONObject pushReportV2(ReportV2Dto reportV2Dto, String locale) throws Exception {
        UserReportRelationEntity userReportRelationCheck;
        String prefix;
        List userReportRelationEntities;
        if (Objects.isNull(reportV2Dto)) {
            throw new BussinessException(CommonUtil.getMessageUtils().getMessageByLangName("message.fileparsing.exception.request.empty", locale));
        }
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)reportV2Dto.getUrl())) {
            throw new BussinessException(CommonUtil.getMessageUtils().getMessageByLangName("message.fileparsing.exception.url.empty", locale));
        }
        if (!reportV2Dto.isIfCommonFlag() && (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)reportV2Dto.getTenantId()) || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)reportV2Dto.getUserId()))) {
            throw new BussinessException(CommonUtil.getMessageUtils().getMessageByLangName("message.fileparsing.exception.tenantIdOrUserId.empty", locale));
        }
        byte[] bytes = this.dmcServiceInvoker.getSheet(reportV2Dto.getUrl());
        List sheets = new ArrayList(4);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        ExcelReader build = null;
        try {
            build = EasyExcel.read((InputStream)inputStream).build();
            sheets = build.excelExecutor().sheetList();
        }
        catch (Exception e) {
            log.error("\u8bfb\u53d6\u6587\u4ef6sheet\u5931\u8d25\uff1a{} ", (Throwable)e);
        }
        finally {
            ((InputStream)inputStream).close();
            if (!Objects.isNull(build)) {
                build.finish();
            }
        }
        if (CollectionUtils.isEmpty(sheets)) {
            throw new BussinessException(CommonUtil.getMessageUtils().getMessageByLangName("message.fileparsing.exception.read.sheet.error", locale));
        }
        if (sheets.size() <= 0) {
            throw new BussinessException(CommonUtil.getMessageUtils().getMessageByLangName("message.fileparsing.exception.no.sheet", locale));
        }
        UserReportRelationEntity userReportRelationEntity = new UserReportRelationEntity();
        if (reportV2Dto.isIfCommonFlag()) {
            userReportRelationEntities = this.reportService.selectCommonReport(reportV2Dto.getUrl());
            userReportRelationEntity.setFileUrl(reportV2Dto.getUrl());
            userReportRelationEntity.setReportType(ReportTypeEnum.COMMON.getCode());
            prefix = "scrumbi_common_report_";
        } else {
            try {
                userReportRelationEntities = this.reportService.selectUserReport(reportV2Dto.getUserId(), reportV2Dto.getTenantId());
            }
            catch (Exception e) {
                userReportRelationEntities = null;
            }
            userReportRelationEntity.setUserId(reportV2Dto.getUserId());
            userReportRelationEntity.setTenantId(reportV2Dto.getTenantId());
            userReportRelationEntity.setReportType(ReportTypeEnum.USER.getCode());
            prefix = "scrumbi_user_report_";
        }
        if (CollectionUtils.isEmpty((Collection)userReportRelationEntities)) {
            userReportRelationEntity.setLockTime(new Date());
            this.reportService.insertReportRelation(userReportRelationEntity);
            userReportRelationCheck = userReportRelationEntity;
        } else {
            userReportRelationCheck = (UserReportRelationEntity)userReportRelationEntities.get(0);
        }
        Date lockTime = userReportRelationCheck.getLockTime();
        if ("1".equals(userReportRelationCheck.getLockStatus())) {
            if (DateTimeUtil.minutesDiffer((Date)lockTime, (Date)new Date()) < 5) {
                log.error("\u7528\u6237\u6b63\u5728\u4e0a\u4f20\u62a5\u8868\uff0c\u8bf7\u8010\u5fc3\u7b49\u5f85");
                throw new BussinessException(CommonUtil.getMessageUtils().getMessageByLangName("message.fileparsing.in.pushing.erport", locale));
            }
            log.info("\u9501\u5b9a\u65f6\u95f4\u8d85\u65f6\uff0c\u91ca\u653e\u9501\u5b9a\u72b6\u6001");
            this.reportService.releaseLock(userReportRelationCheck);
        }
        Integer relationId = userReportRelationCheck.getId();
        JSONObject finalResult = new JSONObject();
        try {
            void var19_28;
            this.reportService.lock(userReportRelationCheck);
            List userReportsEntities = this.reportService.selectReportByRelationId(relationId);
            if (CollectionUtils.isNotEmpty((Collection)userReportsEntities)) {
                for (Object userReportsEntity : userReportsEntities) {
                    this.reportMapper.dropDynamicReport("DROP TABLE IF EXISTS " + userReportsEntity.getTableName());
                }
            }
            this.reportService.deleteByRelationId(relationId);
            ArrayList futures = new ArrayList();
            for (ReadSheet sheet : sheets) {
                String tableName = prefix + relationId + "_" + sheet.getSheetNo();
                ThreadPoolExecutor threadPoolExecutor = this.executor.getThreadPoolExecutor();
                Future future = threadPoolExecutor.submit(new SheetReaderTask(this, reportV2Dto, locale, sheet, tableName, bytes));
                futures.add(future);
            }
            log.info("\u62a5\u8868\u89e3\u6790\u5b8c\u6bd5\uff0c\u51c6\u5907\u5f00\u59cb\u5f00\u59cb\u5efa\u8868");
            ArrayList userReportsEntitys = new ArrayList();
            ArrayList<JSONObject> allResults = new ArrayList<JSONObject>();
            for (Future future : futures) {
                try {
                    JSONObject everyResult = (JSONObject)future.get();
                    if (CommonUtil.getMessageUtils().getMessageByLangName("message.fileparsing.read.sheet.empty", locale).equals(everyResult.getString("errorMsg"))) continue;
                    if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)everyResult.getString("errorMsg")) && everyResult.getString("errorMsg").contains(CommonUtil.getMessageUtils().getMessageByLangName("message.fileparsing.high.light.words.content", locale))) {
                        everyResult.put("highLightWords", (Object)CommonUtil.getMessageUtils().getMessageByLangName("message.fileparsing.high.light.words.content", locale));
                    }
                    this.buildInsertUserReports(relationId, userReportsEntitys, everyResult);
                    everyResult.put("ifCheckExcelFormat", (Object)false);
                    if (CommonUtil.getMessageUtils().getMessageByLangName("message.fileparsing.excel.format.error", locale).equals(everyResult.getString("errorMsg"))) {
                        everyResult.put("ifCheckExcelFormat", (Object)true);
                    }
                    everyResult.put("errorMsg", (Object)("zh_TW".equals(locale) ? ZhConverterUtil.toTraditional((String)everyResult.getString("errorMsg")) : ZhConverterUtil.toSimple((String)everyResult.getString("errorMsg"))));
                    allResults.add(everyResult);
                }
                catch (Exception ex) {
                    log.error("\u83b7\u53d6\u5efa\u8868\u7ed3\u679c\u7cfb\u7edf\u5f02\u5e38\uff1a{}", (Throwable)ex);
                    throw new Exception("\u89e3\u6790excel\u7cfb\u7edf\u5f02\u5e38");
                }
            }
            if (CollectionUtils.isNotEmpty(userReportsEntitys)) {
                log.info("\u5efa\u8868ok\uff0c\u51c6\u5907\u6279\u91cf\u6784\u5efa\u6570\u636e,\u6570\u636e\u603b\u6570" + userReportsEntitys.size());
                this.reportService.batchInsertReport(userReportsEntitys);
            }
            int successResultSize = 0;
            boolean bl = false;
            for (JSONObject everyResult : allResults) {
                if (everyResult.getBoolean("result").booleanValue()) {
                    ++successResultSize;
                    continue;
                }
                ++var19_28;
            }
            JSONObject jsonObject = allResults.stream().filter(json -> json.getBoolean("result") != false && CollectionUtils.isNotEmpty((Collection)((List)json.get((Object)"sentences")))).findFirst().orElse(new JSONObject());
            List sentences = (List)jsonObject.getOrDefault((Object)"sentences", new ArrayList());
            String sentenceTitle = jsonObject.getString("sentenceTitle");
            if (CollectionUtils.isEmpty((Collection)sentences)) {
                jsonObject = allResults.stream().filter(json -> json.getBoolean("result")).findFirst().orElse(new JSONObject());
                sentenceTitle = jsonObject.getString("sentenceTitle");
            }
            if (allResults.size() == successResultSize) {
                finalResult.put("code", (Object)0);
                finalResult.put("sentenceTitle", (Object)("zh_TW".equals(locale) ? ZhConverterUtil.toTraditional((String)sentenceTitle) : ZhConverterUtil.toSimple((String)sentenceTitle)));
            } else if (allResults.size() == var19_28) {
                finalResult.put("code", (Object)1);
            } else {
                finalResult.put("code", (Object)2);
                finalResult.put("sentenceTitle", (Object)CommonUtil.getMessageUtils().getMessageByLangName("message.fileparsing.partially.successful.sentence", locale));
            }
            finalResult.put("successResultSize", (Object)successResultSize);
            finalResult.put("failedResultSize", (Object)((int)var19_28));
            finalResult.put("resultDetail", allResults);
            finalResult.put("sentences", (Object)sentences);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new Exception(e.getMessage());
        }
        finally {
            this.reportService.releaseLock(userReportRelationCheck);
        }
        log.info("pushReportV2\u7ed3\u679c{}", (Object)finalResult);
        return finalResult;
    }

    private void buildInsertUserReports(Integer relationId, List<UserReportsEntity> userReportsEntitys, JSONObject jsonObject) {
        String sheetIndex = jsonObject.getString("sheetIndex");
        String sheetName = jsonObject.getString("sheetName");
        String tableName = jsonObject.getString("tableName");
        UserReportsEntity userReportsEntity = new UserReportsEntity();
        userReportsEntity.setRelationId(relationId);
        userReportsEntity.setTableName(tableName);
        userReportsEntity.setSheetIndex(sheetIndex);
        userReportsEntity.setSheetName(sheetName);
        if (!Objects.isNull(jsonObject.getBoolean("result")) && jsonObject.getBoolean("result").booleanValue()) {
            userReportsEntitys.add(userReportsEntity);
        }
    }

    private JSONObject buildFailedResult(ReadSheet sheet, String errorMsg, String tableName) {
        JSONObject res = new JSONObject();
        res.put("sheetIndex", (Object)sheet.getSheetNo());
        res.put("sheetName", (Object)sheet.getSheetName());
        res.put("errorMsg", (Object)errorMsg);
        res.put("result", (Object)false);
        res.put("tableName", (Object)tableName);
        return res;
    }

    public JSONObject doPushReportV2(ReportV2Dto reportV2Dto, String locale, int count, StringBuilder errorMsg, ReadSheet sheet, String tableName, JSONObject reportByUrl) throws Exception {
        List tableSchema;
        List types;
        List realRowIndexNums;
        JSONArray columns;
        JSONArray datas;
        ArrayList sentences;
        block23: {
            String gptResult;
            log.info("{}\u5c1d\u8bd5\u5efa\u8868\u7b2c{}\u6b21", (Object)sheet.getSheetName(), (Object)count);
            if (count > 3) {
                log.error("\u8d85\u51fa\u91cd\u65b0\u5efa\u8868\u6b21\u6570\u4e0a\u9650:{}", (Object)errorMsg);
                return this.buildFailedResult(sheet, CommonUtil.getMessageUtils().getMessageByLangName("message.fileparsing.excel.format.error", locale), tableName);
            }
            sentences = new ArrayList();
            if (Objects.isNull(reportByUrl) || CollectionUtils.isEmpty((Collection)reportByUrl.getJSONArray("datas")) || CollectionUtils.isEmpty((Collection)reportByUrl.getJSONArray("columns"))) {
                log.error("{}\u8bfb\u53d6\u6587\u6863\u4e2d\u5fc3\u6587\u4ef6\u4e3a\u7a7a", (Object)sheet.getSheetName());
                return this.buildFailedResult(sheet, CommonUtil.getMessageUtils().getMessageByLangName("message.fileparsing.read.sheet.empty", locale), tableName);
            }
            datas = null;
            columns = null;
            JSONArray demoDatasArray = null;
            realRowIndexNums = new ArrayList();
            try {
                datas = reportByUrl.getJSONArray("datas");
                columns = reportByUrl.getJSONArray("columns");
                realRowIndexNums = (List)reportByUrl.get((Object)"realRowIndex");
                demoDatasArray = new JSONArray();
                demoDatasArray.add((Object)columns);
                if (datas.size() > 5) {
                    JSONArray balanceddArray = AnalysisReportService.fetchBalancedObjects((JSONArray)datas, (int)5);
                    for (int i = 0; i < 5; ++i) {
                        JSONArray dataArray = (JSONArray)balanceddArray.get(i);
                        JSONObject jsonObject = new JSONObject(new LinkedHashMap());
                        for (int j = 0; j < columns.size(); ++j) {
                            if (Objects.isNull(columns.get(j))) continue;
                            jsonObject.put(String.valueOf(columns.get(j)).replaceAll("\n", ""), dataArray.get(j));
                        }
                        demoDatasArray.add((Object)jsonObject);
                    }
                } else {
                    for (int i = 0; i < datas.size(); ++i) {
                        JSONArray dataArray = (JSONArray)datas.get(i);
                        JSONObject jsonObject = new JSONObject(new LinkedHashMap());
                        for (int j = 0; j < columns.size(); ++j) {
                            if (Objects.isNull(columns.get(j))) continue;
                            jsonObject.put(String.valueOf(columns.get(j)).replaceAll("\n", ""), dataArray.get(j));
                        }
                        demoDatasArray.add((Object)jsonObject);
                    }
                }
            }
            catch (Exception e) {
                return this.buildFailedResult(sheet, CommonUtil.getMessageUtils().getMessageByLangName("message.fileparsing.excel.format.error", locale), tableName);
            }
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)errorMsg.toString())) {
                JSONObject json = new JSONObject();
                json.put("demoDatas", (Object)JSONArray.toJSONString((Object)demoDatasArray, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
                gptResult = ExecutorFactory.CALL_GPT_WITH_CREATE_TABLE.callGpt(this.systemMessage(json, "CreateDDL"), "", null, Integer.valueOf(4000), null, Pipeline.getUserToken());
            } else {
                StringBuilder finalErrorMsg = errorMsg;
                JSONObject json = new JSONObject();
                json.put("errorMsg", (Object)finalErrorMsg.toString());
                gptResult = ExecutorFactory.CALL_GPT_WITH_RE_CREATE_TABLE.callGpt(this.systemMessage(json, "ReCreateDDL"), "", null, Integer.valueOf(4000), null, Pipeline.getUserToken());
            }
            try {
                JSONObject.parseObject((String)gptResult);
            }
            catch (Exception e) {
                return this.buildFailedResult(sheet, CommonUtil.getMessageUtils().getMessageByLangName("message.fileparsing.excel.gpt.error", locale), tableName);
            }
            String ddl = null;
            try {
                JSONObject ddlRes = TableSchema.createDDL((String)gptResult, (String)tableName);
                ddl = ddlRes.getString("ddl");
                types = (List)ddlRes.get((Object)"types");
                for (Object data : datas) {
                    JSONArray dataArray = (JSONArray)data;
                    for (int i = 0; i < types.size(); ++i) {
                        if (!((String)types.get(i)).startsWith("INT") && !((String)types.get(i)).startsWith("DECIMAL") || !CollectionUtils.isNotEmpty((Collection)dataArray) || Objects.isNull(dataArray.get(i))) continue;
                        String s = dataArray.get(i).toString().replaceAll(",", "");
                        dataArray.set(i, (Object)s);
                    }
                }
            }
            catch (Exception e) {
                return this.buildFailedResult(sheet, CommonUtil.getMessageUtils().getMessageByLangName("message.fileparsing.no.metric", locale), tableName);
            }
            this.reportMapper.dropDynamicReport("DROP TABLE IF EXISTS " + tableName);
            log.info("\u5220\u9664\u8868" + tableName);
            this.reportMapper.createDynamicReport(ddl);
            log.info("\u65b0\u5efa\u8868" + ddl);
            tableSchema = this.reportReadMapper.getTableSchema(tableName);
            StringBuilder enColumns = new StringBuilder();
            tableSchema.forEach(t -> {
                if (!"id".equals(t.get("Field").toString())) {
                    enColumns.append(t.get("Field").toString()).append(",");
                }
            });
            String enColumnsStr = enColumns.toString().substring(0, enColumns.toString().length() - 1);
            int batchSize = 10000;
            Map groupedData = IntStream.range(0, datas.size()).boxed().collect(Collectors.groupingBy(index -> index / 10000, Collectors.mapping(arg_0 -> ((JSONArray)datas).get(arg_0), Collectors.toList())));
            String finalTableName = tableName;
            try {
                System.setProperty("java.util.concurrent.ForkJoinPool.common.parallelism", "4");
                groupedData.entrySet().parallelStream().forEach(g -> {
                    List partDatas = (List)g.getValue();
                    StringBuilder dataStr = new StringBuilder();
                    for (Object data : partDatas) {
                        dataStr = dataStr.append("(");
                        String result = IntStream.range(0, ((JSONArray)data).size()).mapToObj(i -> Objects.isNull(((JSONArray)data).getString(i)) ? ((JSONArray)data).getString(i) : "'" + AnalysisReportService.escapeSql((String)((JSONArray)data).getString(i)) + "'").collect(Collectors.joining(","));
                        dataStr = dataStr.append(result).append("),");
                    }
                    String values = dataStr.toString().substring(0, dataStr.toString().length() - 1);
                    this.reportMapper.insertDynamicReport("INSERT INTO " + finalTableName + "(" + enColumnsStr + ")\nVALUES\n" + values + ";");
                });
            }
            catch (Exception e) {
                JSONObject errorRowIndex1;
                String errorMessage = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
                log.error("\u5bfc\u5165\u5931\u8d25\uff1a{}", (Object)errorMessage);
                if (++count > 3 && (errorRowIndex1 = this.volidateDecimalAndNumber(sheet, tableName, datas, columns, realRowIndexNums, types, locale)) != null) {
                    return errorRowIndex1;
                }
                JSONObject res = this.doPushReportV2(reportV2Dto, locale, count, errorMsg = org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)errorMsg) ? new StringBuilder("### Original DDL:\n``` sql\n${error.ddl}\n```\n### Database Error:\n``` plantext\n${error.msg}\n```".replace("${error.ddl}", ddl).replace("${error.msg}", errorMessage)) : errorMsg.append("\n").append("### Original DDL:\n``` sql\n${error.ddl}\n```\n### Database Error:\n``` plantext\n${error.msg}\n```".replace("${error.ddl}", ddl).replace("${error.msg}", errorMessage)), sheet, tableName, reportByUrl);
                if (Objects.isNull(res)) break block23;
                return res;
            }
        }
        JSONObject errorRowIndex1 = this.volidateDecimalAndNumber(sheet, tableName, datas, columns, realRowIndexNums, types, locale);
        if (errorRowIndex1 != null) {
            return errorRowIndex1;
        }
        String sentenceTitle = this.buildSentences(locale, sentences, columns, tableSchema, reportV2Dto.isIfCommonFlag(), tableName);
        JSONObject json = new JSONObject();
        json.put("result", (Object)true);
        ArrayList convertedSentences = new ArrayList();
        if (CollectionUtils.isNotEmpty(sentences)) {
            sentences.forEach(sentence -> convertedSentences.add("zh_TW".equals(locale) ? ZhConverterUtil.toTraditional((String)sentence) : ZhConverterUtil.toSimple((String)sentence)));
        }
        json.put("sentences", convertedSentences);
        json.put("sentenceTitle", (Object)("zh_TW".equals(locale) ? ZhConverterUtil.toTraditional((String)sentenceTitle) : ZhConverterUtil.toSimple((String)sentenceTitle)));
        json.put("sheetIndex", (Object)reportByUrl.getString("sheetIndex"));
        json.put("sheetName", (Object)reportByUrl.getString("sheetName"));
        json.put("tableName", (Object)tableName);
        return json;
    }

    private JSONObject volidateDecimalAndNumber(ReadSheet sheet, String tableName, JSONArray datas, JSONArray columns, List<Integer> realRowIndexNums, List<String> types, String locale) {
        JSONObject res = this.volidateBigdecimalOrNum(datas, columns, realRowIndexNums, types);
        int errorRowIndex = res.getIntValue("errorRowIndex");
        String errorType = res.getString("errorType");
        String errorColumnName = res.getString("errorColumnName");
        if (errorRowIndex > 0) {
            if ("decimalLengthValid".equals(errorType)) {
                return this.buildFailedResult(sheet, CommonUtil.getMessageUtils().getMessageByLangName("message.fileparsing.exceed.bigdecimal.length", locale).replace("length", String.valueOf(TableSchema.DataTypeLength.DECIMAL.getLength() - TableSchema.DataTypeLength.DECIMAL.getPrecision())).replace("precision", TableSchema.DataTypeLength.DECIMAL.getPrecision().toString()).replace("rowIndex", String.valueOf(errorRowIndex)), tableName);
            }
            if ("isNumber".equals(errorType)) {
                return this.buildFailedResult(sheet, CommonUtil.getMessageUtils().getMessageByLangName("message.fileparsing.not.number", locale).replace("errorColumnName", "\"" + errorColumnName + "\"").replace("errorRowIndex", String.valueOf(errorRowIndex)), tableName);
            }
        }
        return null;
    }

    private JSONObject volidateBigdecimalOrNum(JSONArray datas, JSONArray columns, List<Integer> realRowIndexNums, List<String> types) {
        JSONObject res = new JSONObject();
        res.put("errorRowIndex", (Object)0);
        for (int i = 0; i < datas.size(); ++i) {
            JSONArray dataLine = (JSONArray)datas.get(i);
            int realRowIndex = realRowIndexNums.get(i);
            for (int j = 0; j < dataLine.size(); ++j) {
                String type = types.get(j);
                if (Objects.isNull(dataLine.get(j)) || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)dataLine.get(j).toString())) continue;
                String value = dataLine.get(j).toString();
                if (type.startsWith(TableSchema.DataTypeLength.DECIMAL.getSqlType()) && !AnalysisReportService.decimalLengthValid((String)value, (int)TableSchema.DataTypeLength.DECIMAL.getLength(), (int)TableSchema.DataTypeLength.DECIMAL.getPrecision())) {
                    res.put("errorRowIndex", (Object)realRowIndex);
                    res.put("errorType", (Object)"decimalLengthValid");
                    return res;
                }
                if (!type.startsWith(TableSchema.DataTypeLength.INT.getSqlType()) && !type.startsWith(TableSchema.DataTypeLength.DECIMAL.getSqlType()) || AnalysisReportService.isNumber((String)value)) continue;
                res.put("errorRowIndex", (Object)realRowIndex);
                res.put("errorType", (Object)"isNumber");
                res.put("errorColumnName", columns.get(j));
                return res;
            }
        }
        return res;
    }

    public static String escapeSql(String input) {
        if (input == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        block11: for (char c : input.toCharArray()) {
            switch (c) {
                case '\'': {
                    sb.append("''");
                    continue block11;
                }
                case '\"': {
                    sb.append("\"\"");
                    continue block11;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block11;
                }
                case '%': {
                    sb.append("\\%");
                    continue block11;
                }
                case '_': {
                    sb.append("\\_");
                    continue block11;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block11;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block11;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block11;
                }
                case '\u0000': {
                    sb.append("\\0");
                    continue block11;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    private String buildSentences(String locale, List<String> sentences, JSONArray columns, List<Map<String, Object>> tableSchema, boolean ifCommonFlag, String tableName) {
        if (ifCommonFlag) {
            sentences.add(CommonUtil.getMessageUtils().getMessageByLangName("message.fileparsing.sentences.test1", locale));
            sentences.add(CommonUtil.getMessageUtils().getMessageByLangName("message.fileparsing.sentences.test2", locale));
            sentences.add(CommonUtil.getMessageUtils().getMessageByLangName("message.fileparsing.sentences.test3", locale));
            sentences.add(CommonUtil.getMessageUtils().getMessageByLangName("message.fileparsing.sentences.test4", locale));
            sentences.add(CommonUtil.getMessageUtils().getMessageByLangName("message.fileparsing.sentences.test5", locale));
            return CommonUtil.getMessageUtils().getMessageByLangName("message.fileparsing.default.sentence", locale);
        }
        StringBuilder sentencesDatas = new StringBuilder();
        for (int i = 0; i < tableSchema.size(); ++i) {
            Map<String, Object> t = tableSchema.get(i);
            if ("id".equals(t.get("Field").toString())) continue;
            sentencesDatas.append(t.get("Field").toString()).append("|");
        }
        sentencesDatas.append("\n");
        sentencesDatas.append(String.join((CharSequence)"|", columns.toJavaList(String.class)));
        Integer count = this.reportReadMapper.getCount(tableName);
        List sampleIndexs = StringUtil.fetchBalancedSampleIndexs((int)count, (int)5);
        List datas = this.reportReadMapper.getExampleData(tableName, sampleIndexs.stream().map(String::valueOf).collect(Collectors.joining(", ", "(", ")")));
        for (LinkedHashMap data : datas) {
            data.remove("id");
            sentencesDatas.append("\n").append(data.values().stream().map(Object::toString).collect(Collectors.joining("|")));
        }
        String sentenceTitle = CommonUtil.getMessageUtils().getMessageByLangName("message.fileparsing.default.sentence", locale);
        try {
            String excelQueryGenerate = ExecutorFactory.CALL_GPT_WITH_EXCEL_QUERY.callGpt(this.systemMessage(new JSONObject(), "Excel_Query_Generate"), sentencesDatas.toString(), null, Integer.valueOf(4000), null, Pipeline.getUserToken());
            JSONObject jsonObject = JSONObject.parseObject((String)excelQueryGenerate);
            if (Objects.isNull(jsonObject) || CollectionUtils.isEmpty((Collection)jsonObject.getJSONArray("querys"))) {
                sentenceTitle = CommonUtil.getMessageUtils().getMessageByLangName("message.fileparsing.no.dimension.sentence", locale);
            } else {
                jsonObject.getJSONArray("querys").forEach(query -> sentences.add(query.toString()));
            }
        }
        catch (Exception e) {
            sentenceTitle = CommonUtil.getMessageUtils().getMessageByLangName("message.fileparsing.excel.gen.error.sentence", locale);
        }
        return sentenceTitle;
    }

    private String systemMessage(JSONObject context, String name) {
        return ((TemplateLocalFileBroker)SpringContextUtil.getBean(TemplateLocalFileBroker.class)).get("prompts", name).getContent((Map)context);
    }

    public static JSONArray fetchBalancedObjects(JSONArray jsonArray, int sampleSize) {
        int arrayLength = jsonArray.size();
        JSONArray balanceddArray = new JSONArray();
        if (arrayLength <= sampleSize) {
            return jsonArray;
        }
        int interval = arrayLength / sampleSize;
        for (int i = 0; i < sampleSize; ++i) {
            int index = i * interval;
            balanceddArray.add(jsonArray.get(index));
        }
        return balanceddArray;
    }

    public static boolean isInt(String input, int maxLength) {
        if (input.length() > maxLength) {
            return false;
        }
        try {
            int value = Integer.parseInt(input);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean decimalLengthValid(String input, int length, int precision) {
        try {
            BigDecimal value = new BigDecimal(input);
            int totalDigits = value.precision();
            if (totalDigits > length) {
                return false;
            }
            int scale = value.scale();
            if (scale > precision) {
                return false;
            }
            int integerDigits = totalDigits - scale;
            int maxIntegerDigits = length - precision;
            return integerDigits <= maxIntegerDigits;
        }
        catch (NumberFormatException e) {
            return true;
        }
    }

    public static boolean isNumber(String input) {
        try {
            new BigDecimal(input);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isDateValid(String input) {
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        try {
            LocalDate date = LocalDate.parse(input, dateFormatter);
            return true;
        }
        catch (DateTimeParseException e) {
            return false;
        }
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }

    static /* synthetic */ DmcServiceInvoker access$100(AnalysisReportService x0) {
        return x0.dmcServiceInvoker;
    }

    static /* synthetic */ JSONObject access$200(AnalysisReportService x0, ReadSheet x1, String x2, String x3) {
        return x0.buildFailedResult(x1, x2, x3);
    }
}

