/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.fileparsing.service;

import com.digiwin.fileparsing.beans.AdqPPTModel;
import com.digiwin.fileparsing.beans.DmcFileRequest;
import com.digiwin.fileparsing.beans.DmcFileResponse;
import com.digiwin.fileparsing.beans.DmcShareFileRequest;
import com.digiwin.fileparsing.common.util.CommonUtil;
import com.digiwin.fileparsing.common.util.DateTimeUtil;
import com.digiwin.fileparsing.common.util.JSONUtils;
import com.digiwin.fileparsing.service.AdqService;
import com.digiwin.fileparsing.service.CreatePPTService;
import com.digiwin.fileparsing.service.DmcService;
import com.digiwin.fileparsing.util.FileUtils;
import com.digiwin.fileparsing.util.MarkDownUtils;
import com.digiwin.fileparsing.util.PPTUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.jetty.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class CreateFileService {
    private static final Logger log = LoggerFactory.getLogger(CreateFileService.class);
    @Autowired
    private DmcService dmcService;
    @Autowired
    private CreatePPTService createPPTService;
    @Autowired
    private AdqService adqService;
    @Value(value="${file.expireDate}")
    private int amountDay;

    public Map<String, Object> getFileDmcShareUrl(Map<String, Object> pptContentRequest, String userToken, String tenantId, String locale) {
        DmcFileResponse fileResponse;
        Map params;
        String fileName;
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        String localFileName = "";
        if (pptContentRequest.get("name") != null) {
            fileName = String.valueOf(pptContentRequest.get("name"));
        } else {
            Date now = new Date(System.currentTimeMillis());
            fileName = DateTimeUtil.format((Date)now);
        }
        String userId = pptContentRequest.get("userId") != null ? String.valueOf(pptContentRequest.get("userId")) : "";
        String dmcToken = this.dmcService.getDMCUserToken("", "asada", "asadaM8@15f");
        if (!StringUtils.hasLength((String)dmcToken)) {
            result.put("errorMessage", CommonUtil.getMessageUtils().getMessageByLangName("message.fileparsing.get.dmc.token.error", locale));
            return result;
        }
        try {
            params = this.createPPTService.create(pptContentRequest, userId, tenantId, locale, userToken, dmcToken);
        }
        catch (Exception e) {
            log.error("\u751f\u6210\u6587\u4ef6\u5931\u8d25\uff0c\u9519\u8bef\u539f\u56e0:{}", (Object)e.getMessage());
            result.put("errorMessage", CommonUtil.getMessageUtils().getMessageByLangName("message.fileparsing.create.ppt.error", locale));
            return result;
        }
        if (MapUtils.isNotEmpty((Map)params)) {
            fileName = (String)params.get("filename");
            localFileName = (String)params.get("localFileName");
        }
        if ((fileResponse = this.dmcService.uploadFile(dmcToken, locale, tenantId, DmcFileRequest.build((String)localFileName, (String)fileName, (String)tenantId, (String)DateTimeUtil.getNextWeekTimeToString((Integer)this.amountDay)))) != null) {
            FileUtils.deleteTempFile((String)localFileName);
            DmcShareFileRequest fileRequest = new DmcShareFileRequest();
            fileRequest.setFileId(fileResponse.getId());
            fileRequest.setExpireDate(DateTimeUtil.format((Date)fileResponse.getExpireDate()));
            Map fileShareData = this.dmcService.getFileShareData(dmcToken, locale, tenantId, fileRequest);
            String url = (String)fileShareData.get("url");
            fileShareData.put("pptPageSize", params.get("pptPageSize"));
            if (MapUtils.isNotEmpty((Map)fileShareData) && StringUtils.hasLength((String)url)) {
                String previewUrl = this.dmcService.getPreviewUrl(dmcToken, locale, tenantId, (String)fileShareData.get("fileId"), false);
                AdqPPTModel pptModel = this.adqService.savePPT(userToken, userId, tenantId, locale, fileShareData, Boolean.valueOf(false), fileName, previewUrl, Collections.EMPTY_LIST, "");
                if (pptModel != null) {
                    result.putAll(JSONUtils.toMap((String)JSONUtils.toJsonString((Object)pptModel)));
                    result.put("url", url);
                    result.put("pptPageSize", params.get("pptPageSize"));
                    result.putAll(fileShareData);
                    return result;
                }
            }
        }
        result.put("errorMessage", CommonUtil.getMessageUtils().getMessageByLangName("message.fileparsing.create.ppt.error", locale));
        return result;
    }

    public String coverPPTToPDF(String fileId, String fileName, String tenantId, String locale, String userToken, String userId) throws Exception {
        String token = this.dmcService.getDMCUserToken(tenantId, "asada", "asadaM8@15f");
        if (!StringUtils.hasLength((String)token)) {
            return CommonUtil.getMessageUtils().getMessageByLangName("message.fileparsing.get.dmc.token.error", locale);
        }
        if (fileName.contains(" ")) {
            fileName = fileName.replace(" ", "-");
        }
        byte[] fileByte = this.dmcService.getFileDownloadById((Object)fileId, tenantId, locale, token);
        String url = null;
        if (fileByte != null) {
            File pptFile = new File(FilenameUtils.getName((String)("/usr/local/fileparsing/" + UUID.randomUUID() + "_" + fileName)));
            try (FileOutputStream fileOutputStream = new FileOutputStream(pptFile);){
                fileOutputStream.write(fileByte);
                fileOutputStream.flush();
                url = pptFile.getCanonicalPath();
            }
            catch (Exception e) {
                log.error("\u751f\u6210PPT\u6587\u4ef6\u51fa\u5dee\uff0c\u9519\u8bef\u539f\u56e0{}", (Object)e.getMessage());
            }
        }
        if (url == null) {
            return CommonUtil.getMessageUtils().getMessageByLangName("message.fileparsing.cover.ppt.error.data.empty", locale);
        }
        String pdfName = PPTUtils.coverPDFByLibreOffice(url);
        DmcFileResponse fileResponse = this.dmcService.uploadFile(token, locale, tenantId, DmcFileRequest.build((String)pdfName, (String)fileName, (String)tenantId, (String)""));
        if (fileResponse != null) {
            FileUtils.deleteTempFile(url);
            FileUtils.deleteTempFile((String)pdfName);
            DmcShareFileRequest fileRequest = new DmcShareFileRequest();
            fileRequest.setFileId(fileResponse.getId());
            Map shareData = this.dmcService.getFileShareData(token, locale, tenantId, fileRequest);
            if (MapUtils.isNotEmpty((Map)shareData)) {
                Boolean flag = this.adqService.saveFile(userToken, userId, tenantId, locale, fileName, shareData, null, fileId);
                if (!flag.booleanValue()) {
                    log.error("\u5c06\u6587\u4ef6\uff1a{}\uff0c\u5b58\u50a8\u5230adq\u5931\u8d25", (Object)fileName);
                }
                return (String)shareData.get("url");
            }
        }
        return CommonUtil.getMessageUtils().getMessageByLangName("message.fileparsing.download.error", locale);
    }

    public Map<String, Object> getPPTFileShareUrl(MultipartFile file, String userId, String tenantId, String locale, String token, String dmcToken) {
        DmcFileResponse fileResponse;
        Map shareData;
        HashMap<String, Object> shareUrl = new HashMap<String, Object>(1);
        String filename = file.getOriginalFilename();
        File uploadFile = null;
        try {
            uploadFile = CreateFileService.multipartFileToFile((MultipartFile)file);
        }
        catch (Exception e) {
            log.error("\u8f6c\u6362\u6587\u4ef6\u6d41\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0{}", (Object)e.getMessage());
            return Collections.emptyMap();
        }
        if (uploadFile == null) {
            return Collections.emptyMap();
        }
        Long pptTime = System.currentTimeMillis();
        try {
            Map pptAnalysis = PPTUtils.readerTempPPTToObject((String)uploadFile.getPath(), (Boolean)false);
            shareUrl.put("pageDetails", pptAnalysis.get("pageDetails"));
            shareUrl.put("coverPng", pptAnalysis.get("coverPng"));
            shareUrl.put("isModifyPPT", pptAnalysis.get("isModifyPPT"));
        }
        catch (Exception e) {
            log.error("\u89e3\u6790PPT\u5931\u8d25\uff0c\u5f02\u5e38\u539f\u56e0{}", (Object)e.getMessage());
            return Collections.emptyMap();
        }
        log.error("\u89e3\u6790PPT\u6587\u4ef6\u8017\u65f6:{} \u6beb\u79d2", (Object)(System.currentTimeMillis() - pptTime));
        String coverPng = (String)shareUrl.get("coverPng");
        if (!StringUtil.isBlank((String)coverPng) && !MapUtils.isEmpty((Map)(shareData = this.getDMCShareUrl(coverPng, tenantId, locale, dmcToken)))) {
            shareUrl.put("coverPng", shareData.get("url"));
        }
        if ((fileResponse = this.dmcService.uploadFile(dmcToken, locale, tenantId, DmcFileRequest.build((String)filename, (File)uploadFile, (String)filename, (String)tenantId))) != null) {
            FileUtils.deleteTempFile((String)uploadFile.getName());
            DmcShareFileRequest fileRequest = new DmcShareFileRequest();
            fileRequest.setFileId(fileResponse.getId());
            Map fileShareData = this.dmcService.getFileShareData(dmcToken, locale, tenantId, fileRequest);
            if (MapUtils.isNotEmpty((Map)fileShareData)) {
                shareUrl.put(filename, fileShareData);
            }
        }
        return shareUrl;
    }

    public Map<String, Object> getFileShareUrl(MultipartFile file, String userId, String tenantId, String locale, String token, String dmcToken, int currentAmountDay) {
        HashMap<String, Object> shareUrl = new HashMap<String, Object>(1);
        String filename = file.getOriginalFilename();
        File uploadFile = null;
        try {
            uploadFile = CreateFileService.multipartFileToFile((MultipartFile)file);
        }
        catch (Exception e) {
            log.error("\u8f6c\u6362\u6587\u4ef6\u6d41\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0{}", (Object)e.getMessage());
            return Collections.emptyMap();
        }
        if (uploadFile == null) {
            return Collections.emptyMap();
        }
        String amount = currentAmountDay > 0 ? DateTimeUtil.getNextWeekTimeToString((Integer)currentAmountDay) : (currentAmountDay == 0 ? DateTimeUtil.getNextWeekTimeToString((Integer)this.amountDay) : "");
        DmcFileResponse fileResponse = this.dmcService.uploadFile(dmcToken, locale, tenantId, DmcFileRequest.build((String)filename, (File)uploadFile, (String)filename, (String)tenantId, (String)amount));
        if (fileResponse != null) {
            Map fileShareData;
            FileUtils.deleteTempFile((String)uploadFile.getName());
            DmcShareFileRequest fileRequest = new DmcShareFileRequest();
            fileRequest.setFileId(fileResponse.getId());
            if (fileResponse.getExpireDate() != null) {
                fileRequest.setExpireDate(DateTimeUtil.format((Date)fileResponse.getExpireDate()));
            }
            if (MapUtils.isNotEmpty((Map)(fileShareData = this.dmcService.getFileShareData(dmcToken, locale, tenantId, fileRequest)))) {
                shareUrl.put(filename, fileShareData);
            }
        }
        return shareUrl;
    }

    public Map<String, Object> getDMCShareUrl(String filename, String tenantId, String locale, String dmcToken) {
        File file = new File(filename);
        if (!file.exists()) {
            return Collections.emptyMap();
        }
        DmcFileResponse fileResponse = this.dmcService.uploadFile(dmcToken, locale, tenantId, DmcFileRequest.build((String)filename, (File)file, (String)filename, (String)tenantId));
        if (fileResponse != null) {
            FileUtils.deleteTempFile((String)filename);
            DmcShareFileRequest fileRequest = new DmcShareFileRequest();
            fileRequest.setFileId(fileResponse.getId());
            Map fileShareData = this.dmcService.getFileShareData(dmcToken, locale, tenantId, fileRequest);
            if (MapUtils.isNotEmpty((Map)fileShareData)) {
                return fileShareData;
            }
        }
        return Collections.emptyMap();
    }

    public static File multipartFileToFile(MultipartFile file) throws Exception {
        File toFile = null;
        if ("".equals(file) || file.getSize() <= 0L) {
            file = null;
        } else {
            InputStream ins = null;
            ins = file.getInputStream();
            toFile = new File(FilenameUtils.getName((String)(UUID.randomUUID() + file.getOriginalFilename())));
            CreateFileService.inputStreamToFile((InputStream)ins, (File)toFile);
            ins.close();
        }
        return toFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void inputStreamToFile(InputStream ins, File file) {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(file);
            int bytesRead = 0;
            byte[] buffer = new byte[8192];
            while ((bytesRead = ins.read(buffer, 0, 8192)) != -1) {
                ((OutputStream)os).write(buffer, 0, bytesRead);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (IOException e) {
                    log.error("\u6587\u4ef6\u6d41\u5173\u95ed\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0{}", (Object)e.getMessage());
                }
            }
            if (os != null) {
                try {
                    ((OutputStream)os).close();
                }
                catch (IOException e) {
                    log.error("\u6587\u4ef6\u6d41\u5173\u95ed\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0{}", (Object)e.getMessage());
                }
            }
        }
    }

    public Boolean modifyFile(String dmcFileId, AdqPPTModel pptModel, String fileName, String userId, String tenantId, String locale, String userToken) {
        if (StringUtils.hasText((String)fileName)) {
            String dmcToken = this.dmcService.getDMCUserToken(tenantId, "asada", "asadaM8@15f");
            if (!StringUtils.hasLength((String)dmcToken)) {
                return false;
            }
            Map dmcFile = this.dmcService.rename(dmcFileId, "asada", fileName, userToken, dmcToken, tenantId, locale);
            if (MapUtils.isEmpty((Map)dmcFile)) {
                return false;
            }
            pptModel.setPptDocId((String)dmcFile.get("id"));
            pptModel.setPptName(fileName);
        }
        return this.adqService.savePPT(userToken, userId, tenantId, locale, pptModel);
    }

    public Map<String, Object> coverMKToFile(String data, String fileName, String userId, String token, String tenantId, String locale, String fileType) {
        Map<String, Object> shareUrl = new HashMap<String, Object>(2);
        String dmcToken = this.dmcService.getDMCUserToken(tenantId, "asada", "asadaM8@15f");
        if (!StringUtils.hasLength((String)dmcToken)) {
            shareUrl.put("errorMessage", CommonUtil.getMessageUtils().getMessageByLangName("message.fileparsing.get.dmc.token.error", locale));
            return shareUrl;
        }
        String localFileName = UUID.randomUUID() + "_" + fileName;
        if (StringUtils.hasText((String)fileType)) {
            if ("pdf".equals(fileType)) {
                String localPdfFileName = localFileName + ".pdf";
                String pdfFileName = fileName + ".pdf";
                MarkDownUtils.getFile((String)data, (String)localPdfFileName);
                shareUrl = this.addFile(localPdfFileName, pdfFileName, dmcToken, locale, tenantId, shareUrl, "pdf");
                FileUtils.deleteTempFile((String)localPdfFileName);
            } else if ("docx".equals(fileType)) {
                String localDocxFile = localFileName + ".docx";
                MarkDownUtils.getFile((String)data, (String)localDocxFile);
                MarkDownUtils.dealWord((String)localDocxFile);
                String docFile = fileName + ".doc";
                shareUrl = this.addFile(localDocxFile.replace(".docx", ".doc"), docFile, dmcToken, locale, tenantId, shareUrl, "docx");
                FileUtils.deleteTempFile((String)localDocxFile);
                FileUtils.deleteTempFile((String)localDocxFile.replace(".docx", ".doc"));
            }
        } else {
            String localPdfFileName = localFileName + ".pdf";
            MarkDownUtils.getFile((String)data, (String)localPdfFileName);
            String pdfFileName = fileName + ".pdf";
            shareUrl = this.addFile(localPdfFileName, pdfFileName, dmcToken, locale, tenantId, shareUrl, "pdf");
            FileUtils.deleteTempFile((String)localPdfFileName);
            String localDocxFile = localFileName + ".docx";
            MarkDownUtils.getFile((String)data, (String)localDocxFile);
            MarkDownUtils.dealWord((String)localDocxFile);
            String docFile = fileName + ".doc";
            shareUrl = this.addFile(localDocxFile.replace(".docx", ".doc"), docFile, dmcToken, locale, tenantId, shareUrl, "docx");
            FileUtils.deleteTempFile((String)localDocxFile);
            FileUtils.deleteTempFile((String)localDocxFile.replace(".docx", ".doc"));
        }
        shareUrl.put("limitDay", this.amountDay);
        return shareUrl;
    }

    private Map<String, Object> addFile(String localFileName, String fileName, String dmcToken, String locale, String tenantId, Map<String, Object> shareUrl, String fileKey) {
        DmcFileResponse fileResponse;
        File pdfFile = new File(FilenameUtils.getName((String)localFileName));
        if (pdfFile.exists() && (fileResponse = this.dmcService.uploadFile(dmcToken, locale, tenantId, DmcFileRequest.build((String)localFileName, (String)fileName, (String)tenantId, (String)DateTimeUtil.getNextWeekTimeToString((Integer)this.amountDay)))) != null) {
            DmcShareFileRequest fileRequest = new DmcShareFileRequest();
            fileRequest.setFileId(fileResponse.getId());
            fileRequest.setExpireDate(DateTimeUtil.format((Date)fileResponse.getExpireDate()));
            Map fileShareData = this.dmcService.getFileShareData(dmcToken, locale, tenantId, fileRequest);
            if (MapUtils.isNotEmpty((Map)fileShareData)) {
                HashMap file = new HashMap(3);
                file.put("url", fileShareData.get("url"));
                file.put("createDate", fileShareData.get("createDate"));
                file.put("expireDate", fileShareData.get("expireDate"));
                shareUrl.put(fileKey, file);
            } else {
                log.error("\u83b7\u53d6{}\u5206\u4eab\u94fe\u63a5\u5931\u8d25, \u6587\u4ef6\u540d\u79f0: {}, \u79df\u6237ID: {}", new Object[]{fileKey, fileName, tenantId});
            }
        }
        return shareUrl;
    }
}

