/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.fileparsing.service;

import com.digiwin.fileparsing.beans.AdqPPTModel;
import com.digiwin.fileparsing.beans.PPTPageDetail;
import com.digiwin.fileparsing.beans.PowerPointSlide;
import com.digiwin.fileparsing.beans.TemplatePPTModel;
import com.digiwin.fileparsing.common.util.JSONUtils;
import com.digiwin.fileparsing.service.AdqService;
import com.digiwin.fileparsing.service.DmcService;
import com.digiwin.fileparsing.util.FileUtils;
import com.digiwin.fileparsing.util.PPTUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class CreatePPTService {
    private static final Logger log = LoggerFactory.getLogger(CreatePPTService.class);
    @Autowired
    private AdqService adqService;
    @Autowired
    private DmcService dmcService;

    public Map<String, Object> create(Map<String, Object> pptContentRequest, String userId, String tenantId, String locale, String userToken, String dmcToken) throws Exception {
        int pageSize;
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        String templatePPTFileId = "";
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("template", "template");
        params.put("defaultPpt", true);
        List templatePpt = this.adqService.listPPT(tenantId, userId, locale, userToken, params);
        templatePPTFileId = !CollectionUtils.isEmpty((Collection)templatePpt) ? ((AdqPPTModel)templatePpt.get(0)).getPptDocId() : this.adqService.setDefaultSystemPPT(tenantId, locale, userToken).getPptDocId();
        String filename = (String)pptContentRequest.get("name");
        String localFileName = UUID.randomUUID() + "_" + filename;
        String userName = (String)pptContentRequest.get("userName");
        List datas = JSONUtils.toList((String)JSONUtils.toJsonString((Object)pptContentRequest.get("pptData")), PowerPointSlide.class);
        List pageDetails = JSONUtils.toList((String)JSONUtils.toJsonString((Object)pptContentRequest.get("pptPage")), PPTPageDetail.class);
        String filePath = null;
        TemplatePPTModel templatePPTModel = new TemplatePPTModel();
        templatePPTModel.setPptData(datas);
        templatePPTModel.setPptPage(pageDetails);
        if (StringUtils.hasText((String)templatePPTFileId)) {
            byte[] templateFile = this.dmcService.getFileDownloadById((Object)templatePPTFileId, tenantId, locale, dmcToken);
            if (templateFile != null) {
                File pptFile = new File(FilenameUtils.getName((String)("/usr/local/fileparsing/" + UUID.randomUUID() + "_" + filename)));
                try (FileOutputStream fileOutputStream = new FileOutputStream(pptFile);){
                    fileOutputStream.write(templateFile);
                    fileOutputStream.flush();
                    filePath = pptFile.getCanonicalPath();
                }
                catch (Exception e) {
                    log.error("\u751f\u6210PPT\u6587\u4ef6\u51fa\u9519\uff0c\u9519\u8bef\u539f\u56e0{}", (Object)e.getMessage());
                }
            }
            pageSize = PPTUtils.createPPTByTemp(filePath, (String)localFileName, (TemplatePPTModel)templatePPTModel, (boolean)true);
        } else {
            pageSize = PPTUtils.readerFile(null, (String)localFileName, (String)userName, (List)datas);
        }
        FileUtils.deleteTempFile(filePath);
        result.put("filename", filename);
        result.put("localFileName", localFileName);
        if (!CollectionUtils.isEmpty((Collection)datas)) {
            if (datas.size() != pageSize) {
                log.error("\u751f\u6210PPT\u6587\u4ef6\u5f02\u5e38\uff0c{}\uff0c\u5165\u53c2\uff1a{}", (Object)"\u6570\u636e\u6761\u6570\u548c\u9875\u9762\u6761\u6570\u4e0d\u4e00\u81f4", (Object)JSONUtils.toJsonString(pptContentRequest));
            }
            result.put("pptPageSize", pageSize);
        } else {
            result.put("pptPageSize", 0);
        }
        return result;
    }
}

