/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.fileparsing.service;

import com.digiwin.dap.middleware.lmc.util.JsonUtils;
import com.digiwin.fileparsing.beans.AthenaBasicHttpRequestHead;
import com.digiwin.fileparsing.beans.DmcFileRequest;
import com.digiwin.fileparsing.beans.DmcFileResponse;
import com.digiwin.fileparsing.beans.DmcShareFileRequest;
import com.digiwin.fileparsing.common.util.DateTimeUtil;
import com.digiwin.fileparsing.common.util.JSONUtils;
import com.digiwin.fileparsing.service.DmcService;
import com.digiwin.fileparsing.service.HttpService;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.MultipartBodyBuilder;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DmcService {
    private static final Logger log = LoggerFactory.getLogger(DmcService.class);
    private static final String API_PREFIX = "/api/dmc/v2/";
    private static final String API_PREFIX_V1 = "/api/dmc/v1/";
    @Value(value="${dap.dmc.url}")
    private String dmcUrl;
    @Autowired
    private HttpService httpService;
    @Value(value="${file.expireDate}")
    private int amountDay;

    public DmcFileResponse uploadFile(String userToken, String locale, String tenantId, DmcFileRequest file) {
        String url = this.dmcUrl + API_PREFIX + "file/" + "asada" + "/upload";
        MultipartBodyBuilder builder = new MultipartBodyBuilder();
        builder.part("file", (Object)new FileSystemResource(file.getFile()));
        builder.part("fileInfo", (Object)JsonUtils.writeValueAsString((Object)file.getFileInfo())).header("Content-Type", new String[]{"application/json;charset=UTF-8"});
        try {
            Map response = this.httpService.doPostForEntity(url, new AthenaBasicHttpRequestHead(tenantId, locale, userToken).setContentType("multipart/form-data"), (Object)builder.build(), Map.class);
            if (!CollectionUtils.isEmpty((Map)response)) {
                DmcFileResponse fileResponse = (DmcFileResponse)JSONUtils.parseObject((String)JSONUtils.toJsonString(response.get("data")), DmcFileResponse.class);
                return fileResponse;
            }
        }
        catch (Exception e) {
            log.error("\u4e0a\u4f20\u6587\u4ef6\u4e2d\u5fc3\u5931\u8d25\uff0c\u9519\u8bef\u539f\u56e0{}\uff1a", (Object)e.getMessage());
        }
        return null;
    }

    public String getShareUrl(String userToken, String locale, String tenantId, DmcShareFileRequest file) {
        String url = this.dmcUrl + API_PREFIX + "file/" + "asada" + "/share";
        1 responseType = new /* Unavailable Anonymous Inner Class!! */;
        try {
            ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(tenantId, locale, userToken), JSONUtils.toJsonString((Object)file), (ParameterizedTypeReference)responseType);
            if (responseEntity.getStatusCode().is2xxSuccessful() && !CollectionUtils.isEmpty((Map)((Map)responseEntity.getBody()))) {
                Map data = (Map)((Map)responseEntity.getBody()).get("data");
                return (String)data.get("url");
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u6587\u4ef6\u5206\u4eab\u94fe\u63a5\u5931\u8d25\uff0c\u9519\u8bef\u539f\u56e0{}\uff1a", (Object)e.getMessage());
        }
        return null;
    }

    public Map<String, Object> getFileShareData(String userToken, String locale, String tenantId, DmcShareFileRequest file) {
        String url = this.dmcUrl + API_PREFIX + "file/" + "asada" + "/share";
        2 responseType = new /* Unavailable Anonymous Inner Class!! */;
        try {
            ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(tenantId, locale, userToken), JSONUtils.toJsonString((Object)file), (ParameterizedTypeReference)responseType);
            if (responseEntity.getStatusCode().is2xxSuccessful() && !CollectionUtils.isEmpty((Map)((Map)responseEntity.getBody())) && ((Map)responseEntity.getBody()).get("data") != null) {
                return (Map)((Map)responseEntity.getBody()).get("data");
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u6587\u4ef6\u5206\u4eab\u94fe\u63a5\u5931\u8d25\uff0c\u9519\u8bef\u539f\u56e0{}\uff1a", (Object)e.getMessage());
        }
        return null;
    }

    public String getDMCUserToken(String tenantId, String agileDataUsername, String agileDataPassword) {
        String url = this.dmcUrl + API_PREFIX_V1 + "auth/login";
        3 responseType = new /* Unavailable Anonymous Inner Class!! */;
        HashMap<String, String> pars = new HashMap<String, String>(3);
        pars.put("tenantId", tenantId);
        pars.put("username", agileDataUsername);
        pars.put("pwdhash", this.buildPassword(agileDataPassword));
        try {
            ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead().setTenantId(tenantId), JSONUtils.toJsonString(pars), (ParameterizedTypeReference)responseType);
            if (responseEntity.getStatusCode().is2xxSuccessful() && !CollectionUtils.isEmpty((Map)((Map)responseEntity.getBody()))) {
                Map data = (Map)responseEntity.getBody();
                return (String)data.get("userToken");
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u7528\u6237token\u5931\u8d25\uff0c\u9519\u8bef\u539f\u56e0{}\uff1a", (Object)e.getMessage());
        }
        return null;
    }

    private String buildPassword(String agileDataPassword) {
        try {
            MessageDigest sha256MessageDigest = MessageDigest.getInstance("SHA-256");
            sha256MessageDigest.update(agileDataPassword.getBytes(StandardCharsets.UTF_8));
            byte[] tempByte = sha256MessageDigest.digest();
            sha256MessageDigest.update(tempByte);
            return new String(Base64.getEncoder().encode(sha256MessageDigest.digest()));
        }
        catch (Exception e) {
            log.error("dmc\u5bc6\u7801\u52a0\u5bc6\u9519\u8bef\uff0c\u9519\u8bef\u539f\u56e0{}\uff1a", (Object)e.getMessage());
            return agileDataPassword;
        }
    }

    public Byte[] downloadById(Object fileId, String tenantId, String locale, String token) {
        String url = this.dmcUrl + API_PREFIX + "file/" + "asada" + "/preview/" + fileId;
        4 responseType = new /* Unavailable Anonymous Inner Class!! */;
        try {
            ResponseEntity responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead(tenantId, locale, token), Collections.EMPTY_MAP, (ParameterizedTypeReference)responseType);
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                return (Byte[])responseEntity.getBody();
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u6587\u4ef6\u5931\u8d25\uff0c\u9519\u8bef\u539f\u56e0{}\uff1a", (Object)e.getMessage());
        }
        return null;
    }

    public byte[] getFileDownloadById(Object fileId, String tenantId, String locale, String token) {
        String url = this.dmcUrl + API_PREFIX + "file/" + "asada" + "/download/" + fileId;
        try {
            ResponseEntity responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead(tenantId, locale, token), Collections.EMPTY_MAP, byte[].class);
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                return (byte[])responseEntity.getBody();
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u6587\u4ef6\u5931\u8d25\uff0c\u9519\u8bef\u539f\u56e0{}\uff1a", (Object)e.getMessage());
        }
        return null;
    }

    public Map<String, Object> rename(String dmcFileId, String agileDataBucket, String fileName, String userToken, String dmcToken, String tenantId, String locale) {
        String url = this.dmcUrl + API_PREFIX + "fileinfo/" + "asada" + "/rename";
        5 responseType = new /* Unavailable Anonymous Inner Class!! */;
        HashMap<String, String> pars = new HashMap<String, String>(2);
        pars.put("id", dmcFileId);
        pars.put("fileName", fileName);
        try {
            ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(tenantId, locale, dmcToken), JSONUtils.toJsonString(pars), (ParameterizedTypeReference)responseType);
            if (responseEntity.getStatusCode().is2xxSuccessful() && !CollectionUtils.isEmpty((Map)((Map)responseEntity.getBody())) && ((Boolean)((Map)responseEntity.getBody()).get("success")).booleanValue()) {
                return (Map)((Map)responseEntity.getBody()).get("data");
            }
        }
        catch (Exception e) {
            log.error("\u4fee\u6539\u6587\u4ef6\u540d\u79f0\u5931\u8d25\uff0c\u9519\u8bef\u539f\u56e0{}\uff1a", (Object)e.getMessage());
        }
        return Collections.emptyMap();
    }

    public String getPreviewUrl(String dmcToken, String locale, String tenantId, String fileId, boolean isTemplate) {
        String time = "";
        time = isTemplate ? time + "0" : time + DateTimeUtil.getNextWeekTimeToInt((Integer)this.amountDay);
        String url = this.dmcUrl + API_PREFIX + "file/" + "asada" + "/online/preview/url/" + fileId + "?Time=" + time;
        6 responseType = new /* Unavailable Anonymous Inner Class!! */;
        try {
            ResponseEntity responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead(tenantId, locale, dmcToken), Collections.EMPTY_MAP, (ParameterizedTypeReference)responseType);
            if (responseEntity.getStatusCode().is2xxSuccessful() && ((Map)responseEntity.getBody()).get("data") != null && ((Map)responseEntity.getBody()).get("data") instanceof Map) {
                return (String)((Map)((Map)responseEntity.getBody()).get("data")).get("previewUrl");
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u6587\u4ef6\u5931\u8d25\uff0c\u9519\u8bef\u539f\u56e0{}\uff1a", (Object)e.getMessage());
        }
        return null;
    }
}

