/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.fileparsing.util;

import com.digiwin.fileparsing.util.PPTUtils;
import com.youbenzi.md2.export.FileFactory;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRelation;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTColor;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTFonts;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHyperlink;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTR;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTText;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STUnderline;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class MarkDownUtils {
    private static final Logger log = LoggerFactory.getLogger(MarkDownUtils.class);
    private static final String MD_FILE_PATH = "\u62a5\u544a\u793a\u4f8b.md";

    public static void getFile(String mdText, String fileName) {
        String imgSrcReg = "<img.*src=(.*?)[^>]*?>";
        Pattern pattern = Pattern.compile(imgSrcReg);
        Matcher matcher = pattern.matcher(mdText);
        ArrayList<String> picPaths = new ArrayList<String>();
        ArrayList<Object> errorPicPaths = new ArrayList<Object>(4);
        while (matcher.find()) {
            String imgUrl = matcher.group();
            String picUrl = MarkDownUtils.getPicUrl((String)imgUrl);
            log.error("\u56fe\u7247\u94fe\u63a5: {}", (Object)picUrl);
            String outputPath = UUID.randomUUID() + ".png";
            try {
                log.error("\u6b63\u5728\u4ece\u7f51\u7edc\u4e0b\u8f7d\u56fe\u7247...");
                BufferedImage image = null;
                try {
                    image = ImageIO.read(new URL(new URI(picUrl).toASCIIString()));
                }
                catch (Exception e) {
                    log.error("\u9996\u6b21\u4e0b\u8f7d\u5931\u8d25,\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)e.getMessage());
                    try {
                        Thread.sleep(200L);
                        image = ImageIO.read(new URL(picUrl));
                    }
                    catch (Exception e1) {
                        log.error("\u518d\u6b21\u4e0b\u8f7d\u5931\u8d25,\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)e1.getMessage());
                        try {
                            Thread.sleep(200L);
                            URL url = new URL(picUrl);
                            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                            connection.setRequestMethod("GET");
                            connection.setConnectTimeout(5000);
                            connection.setReadTimeout(10000);
                            InputStream buffin = connection.getInputStream();
                            image = ImageIO.read(buffin);
                        }
                        catch (Exception e2) {
                            log.error("\u6700\u540e\u4e00\u6b21\u4e0b\u8f7d\u5931\u8d25,\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)e2.getMessage());
                        }
                    }
                }
                if (image == null) {
                    log.error("\u65e0\u6cd5\u8bfb\u53d6\u56fe\u7247\uff0c\u8bf7\u68c0\u67e5URL\u662f\u5426\u6b63\u786e\u6216\u56fe\u7247\u683c\u5f0f\u662f\u5426\u53d7\u652f\u6301");
                    errorPicPaths.add(imgUrl);
                    continue;
                }
                log.error("\u6b63\u5728\u8f6c\u6362\u4e3aPNG\u683c\u5f0f...");
                File outputFile = new File(outputPath);
                boolean success = ImageIO.write((RenderedImage)image, "PNG", outputFile);
                if (success) {
                    log.error("\u56fe\u7247\u8f6c\u6362\u6210\u529f\uff01\u4fdd\u5b58\u8def\u5f84:{} ", (Object)outputFile.getAbsolutePath());
                } else {
                    errorPicPaths.add(imgUrl);
                    log.error("\u8f6c\u6362\u5931\u8d25\uff0c\u53ef\u80fd\u662f\u4e0d\u652f\u6301\u7684\u56fe\u7247\u683c\u5f0f");
                }
                String newImageUrl = "![](" + outputFile.getCanonicalPath() + ")";
                mdText = mdText.replace(imgUrl, newImageUrl);
                picPaths.add(outputFile.getCanonicalPath());
            }
            catch (Exception e) {
                log.error("\u5904\u7406\u8fc7\u7a0b\u4e2d\u53d1\u751f\u9519\u8bef: " + e.getMessage());
                errorPicPaths.add(imgUrl);
            }
        }
        mdText = MarkDownUtils.dealErrorUrl(errorPicPaths, (String)mdText);
        try {
            FileFactory.produce((String)mdText, (String)fileName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (!CollectionUtils.isEmpty(picPaths)) {
                for (String path : picPaths) {
                    File file = new File(path);
                    if (!file.exists()) continue;
                    if (file.delete()) {
                        log.error("\u4e34\u65f6\u56fe\u7247\u5220\u9664\u6210\u529f");
                        continue;
                    }
                    log.error("\u4e34\u65f6\u56fe\u7247\u5220\u9664\u5931\u8d25");
                }
            }
        }
    }

    private static String dealErrorUrl(List<String> errorPicPaths, String mdText) {
        for (String errorPicPath : errorPicPaths) {
            mdText = mdText.replace(errorPicPath, "");
        }
        return mdText;
    }

    private static String getPicUrl(String imgUrl) {
        String picUrl = imgUrl.contains("alt=") ? imgUrl.substring(imgUrl.indexOf("src=") + 5, imgUrl.lastIndexOf("alt")).trim() : (imgUrl.lastIndexOf("/>") == -1 ? imgUrl.substring(imgUrl.indexOf("src=") + 5, imgUrl.lastIndexOf(">")).trim() : imgUrl.substring(imgUrl.indexOf("src=") + 5, imgUrl.lastIndexOf("/>")).trim());
        if (picUrl.lastIndexOf("\"") == picUrl.length() - 1) {
            picUrl = picUrl.substring(0, picUrl.lastIndexOf("\""));
        }
        if (picUrl.lastIndexOf("'") == picUrl.length() - 1) {
            picUrl = picUrl.substring(0, picUrl.lastIndexOf("'"));
        }
        return picUrl;
    }

    public static void dealWord(String fileName) {
        try (XWPFDocument document = new XWPFDocument((InputStream)new FileInputStream(new File(fileName)));){
            for (XWPFParagraph paragraph : document.getParagraphs()) {
                String text = paragraph.getText();
                if (!StringUtils.hasText((String)text) || !text.contains("[[") || !text.contains("]]") || !text.contains("(http")) continue;
                String regex = "\\[\\[([^\\]]+)\\]\\]\\((https?://[^)]+)\\)";
                Pattern pattern = Pattern.compile(regex);
                Matcher matcher = pattern.matcher(text);
                while (matcher.find()) {
                    text = paragraph.getText();
                    String findText = matcher.group();
                    if (paragraph.getRuns() != null && paragraph.getRuns().size() > 1) {
                        for (XWPFRun run : paragraph.getRuns()) {
                            if (run.getText(0).contains(findText)) continue;
                            text = text.substring(text.lastIndexOf(run.getText(0)) + run.getText(0).length());
                        }
                    }
                    int firstIndex = text.indexOf(findText);
                    int lastIndex = text.indexOf(findText) + findText.length();
                    String firstText = text.substring(0, firstIndex);
                    Boolean bold = true;
                    String fontFamily = "";
                    int fontSize = 10;
                    String color = "";
                    if (paragraph.getRuns() != null && paragraph.getRuns().size() == 1) {
                        XWPFRun xwpfRun = (XWPFRun)paragraph.getRuns().get(0);
                        xwpfRun.setFontFamily("\u82f9\u65b9-\u7b80");
                        xwpfRun.setFontSize(12);
                        xwpfRun.setText(firstText, 0);
                        bold = xwpfRun.isBold();
                        fontFamily = xwpfRun.getFontFamily();
                        fontSize = xwpfRun.getFontSize();
                        color = xwpfRun.getColor();
                    } else {
                        for (XWPFRun run : paragraph.getRuns()) {
                            if (run.getText(0) == null || !run.getText(0).contains(findText)) continue;
                            run.setText(firstText, 0);
                            bold = run.isBold();
                            fontFamily = run.getFontFamily();
                            fontSize = run.getFontSize();
                            color = run.getColor();
                            break;
                        }
                    }
                    String linkText = matcher.group(1);
                    String url = matcher.group(2);
                    MarkDownUtils.dealText((XWPFParagraph)paragraph, (String)linkText, (String)url);
                    if (!StringUtils.hasText((String)text.substring(lastIndex))) continue;
                    XWPFRun createRun = paragraph.createRun();
                    createRun.setText(text.substring(lastIndex), 0);
                    createRun.setBold(bold.booleanValue());
                    createRun.setFontSize(fontSize);
                    createRun.setFontFamily(fontFamily);
                    createRun.setColor(color);
                }
            }
            try (FileOutputStream out = new FileOutputStream(fileName);){
                document.write((OutputStream)out);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            PPTUtils.coverWordByLibreOffice((String)fileName);
        }
        catch (Exception e) {
            log.error("word\u6587\u4ef6\u8f6c\u6362\u5931\u8d25", (Throwable)e);
        }
    }

    public static void main(String[] args) throws FileNotFoundException {
        String picUrl = "https://quickchart.io/chart?c=%7B%22data%22%3A%7B%22datasets%22%3A%5B%7B%22borderColor%22%3A%22%237D7DE3%22%2C%22backgroundColor%22%3A%22%237D7DE3%22%2C%22data%22%3A%5B62458.36%5D%2C%22label%22%3A%22%E5%9B%9E%E6%AC%A1%E9%87%91%E9%A2%9D%22%2C%22fill%22%3Atrue%7D%2C%7B%22borderColor%22%3A%22%2371B6FB%22%2C%22backgroundColor%22%3A%22%2371B6FB%22%2C%22data%22%3A%5B4502.67%5D%2C%22label%22%3A%22%E5%88%A9%E6%BB%A1%E7%87%83%E9%80%9F%22%2C%22fill%22%3Atrue%7D%5D%2C%22version%22%3A4%2C%22labels%22%3A%5B%222025%E5%B9%B4%E4%B8%8A%E5%8D%8A%E5%B9%B4%22%5D%7D%2C%22options%22%3A%7B%22plugins%22%3A%7B%22legend%22%3A%7B%22position%22%3A%22top%22%7D%7D%2C%22responsive%22%3Atrue%2C%22scales%22%3A%7B%22yAxes%22%3A%5B%7B%22ticks%22%3A%7B%22beginAtZero%22%3Atrue%7D%7D%5D%7D%7D%2C%22type%22%3A%22line%22%7D";
        try {
            URL url = new URL(picUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(10000);
            InputStream buffin = connection.getInputStream();
            BufferedImage image = ImageIO.read(buffin);
            if (image == null) {
                log.error("\u65e0\u6cd5\u8bfb\u53d6\u56fe\u7247\uff0c\u8bf7\u68c0\u67e5URL\u662f\u5426\u6b63\u786e\u6216\u56fe\u7247\u683c\u5f0f\u662f\u5426\u53d7\u652f\u6301");
            }
            log.error("\u6b63\u5728\u8f6c\u6362\u4e3aPNG\u683c\u5f0f...");
            File outputFile = new File(UUID.randomUUID() + ".png");
            boolean bl = ImageIO.write((RenderedImage)image, "PNG", outputFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String mdText = "# \u5c0f\u7c73\u6c7d\u8f66\u7ecf\u8425\u72b6\u6001\u5206\u6790\u62a5\u544a\n\n## \u5f15\u8a00\n\u672c\u62a5\u544a\u65e8\u5728\u5bf9\u5c0f\u7c73\u6c7d\u8f66\u57282022\u5e74\u7684\u7ecf\u8425\u72b6\u6001\u8fdb\u884c\u5168\u9762\u5206\u6790\uff0c\u91cd\u70b9\u56f4\u7ed5\u8425\u6536\u91d1\u989d\u3001\u6bdb\u5229\u91d1\u989d\u3001\u51c0\u5229\u6da6\u53ca\u8ba2\u5355\u6570\u91cf\u7b49\u6838\u5fc3\u6307\u6807\uff0c\u7ed3\u5408\u4f01\u4e1a\u5185\u90e8\u6570\u636e\u4e0e\u884c\u4e1a\u5e02\u573a\u8d8b\u52bf\uff0c\u8bc4\u4f30\u5176\u5e02\u573a\u8868\u73b0\u4e0e\u8d22\u52a1\u5065\u5eb7\u72b6\u51b5\u3002\u62a5\u544a\u5185\u5bb9\u6db5\u76d6\u8425\u6536\u3001\u6bdb\u5229\u3001\u51c0\u5229\u6da6\u53ca\u8ba2\u5355\u60c5\u51b5\u7684\u8be6\u7ec6\u5206\u6790\uff0c\u5e76\u901a\u8fc7\u884c\u4e1a\u5bf9\u6807\uff0c\u4e3a\u4f01\u4e1a\u63d0\u4f9b\u5177\u6709\u9488\u5bf9\u6027\u7684\u6218\u7565\u5efa\u8bae\u3002\n\n---\n\n## \u8425\u6536\u5206\u6790\n**\u7814\u7a76\u76ee\u6807\uff1a** \u5206\u6790\u4f01\u4e1a\u57282022\u5e74\u7684\u8425\u6536\u60c5\u51b5\uff0c\u5305\u62ec\u6708\u5ea6\u8d8b\u52bf\u3001\u4e3b\u8981\u6536\u5165\u6765\u6e90\u548c\u589e\u957f\u70b9\u3002\u901a\u8fc7\u5185\u90e8\u6570\u636e\u5206\u6790\u548c\u5916\u90e8\u5e02\u573a\u6d1e\u5bdf\uff0c\u4e86\u89e3\u4f01\u4e1a\u7684\u5e02\u573a\u8868\u73b0\u548c\u7ade\u4e89\u529b\u3002\n\n### 1.1 \u6708\u5ea6\u8425\u6536\u8d8b\u52bf\n\u6839\u636e\u53ef\u83b7\u5f97\u7684\u4fe1\u606f\uff0c\u5c0f\u7c73\u6c7d\u8f66\u57282022\u5e74\u5c1a\u672a\u6b63\u5f0f\u4ea4\u4ed8\u8f66\u8f86\uff0c\u56e0\u6b64\u8be5\u5e74\u5ea6\u7684\u8425\u6536\u6570\u636e\u4e3b\u8981\u6765\u6e90\u4e8e\u5176\u6bcd\u516c\u53f8\u5c0f\u7c73\u96c6\u56e2\u7684\u5176\u4ed6\u4e1a\u52a1\u677f\u5757\u3002\u5c0f\u7c73\u96c6\u56e2\u57282024\u5e74\u4e0a\u534a\u5e74\u7684\u8425\u6536\u4e3a1643.95\u4ebf\u5143\uff0c\u51c0\u5229\u6da6\u4e3a126.67\u4ebf\u5143\uff0c\u663e\u793a\u51fa\u826f\u597d\u7684\u589e\u957f\u6001\u52bf(\u6570\u636e\u00b9)[[\u7f51\u9875\u6765\u6e909]](https://baijiahao.baidu.com/s?id=1840884446947519461&wfr=spider&for=pc)\u3002\n\n### 1.2 \u5e02\u573a\u5bf9\u6bd4\n\u5c3d\u7ba1\u5c0f\u7c73\u6c7d\u8f66\u57282022\u5e74\u5c1a\u672a\u5b9e\u73b0\u6c7d\u8f66\u4ea4\u4ed8\uff0c\u4f46\u5176\u6bcd\u516c\u53f8\u5c0f\u7c73\u96c6\u56e2\u5728\u667a\u80fd\u624b\u673a\u3001\u667a\u80fd\u5bb6\u5c45\u7b49\u9886\u57df\u7684\u8425\u6536\u8868\u73b0\u5f3a\u52b2\uff0c\u4e3a\u5176\u540e\u7eed\u8fdb\u519b\u6c7d\u8f66\u5e02\u573a\u5960\u5b9a\u4e86\u575a\u5b9e\u57fa\u7840\u3002\u5c0f\u7c73\u54c1\u724c\u5f3a\u5927\u7684\u7528\u6237\u57fa\u7840\u548c\u751f\u6001\u4f53\u7cfb\uff0c\u4e3a\u5176\u6c7d\u8f66\u4e1a\u52a1\u7684\u5e02\u573a\u62d3\u5c55\u63d0\u4f9b\u4e86\u6f5c\u5728\u589e\u957f\u70b9\u3002\n\n---\n\n## \u6bdb\u5229\u5206\u6790\n**\u7814\u7a76\u76ee\u6807\uff1a** \u8bc4\u4f30\u4f01\u4e1a\u57282022\u5e74\u7684\u6bdb\u5229\u60c5\u51b5\uff0c\u5206\u6790\u6bdb\u5229\u7387\u7684\u53d8\u5316\u8d8b\u52bf\u548c\u5f71\u54cd\u56e0\u7d20\u3002\u7ed3\u5408\u884c\u4e1a\u6570\u636e\uff0c\u4e86\u89e3\u4f01\u4e1a\u7684\u6210\u672c\u63a7\u5236\u548c\u76c8\u5229\u80fd\u529b\u3002\n\n### 2.1 \u6bdb\u5229\u7387\u8868\u73b0\n\u5c0f\u7c73\u6c7d\u8f66\u57282022\u5e74\u5c1a\u5904\u4e8e\u7814\u53d1\u4e0e\u7b79\u5907\u9636\u6bb5\uff0c\u672a\u4ea7\u751f\u76f4\u63a5\u7684\u6c7d\u8f66\u4e1a\u52a1\u6bdb\u5229\u6570\u636e\u3002\u7136\u800c\uff0c\u5c0f\u7c73\u96c6\u56e2\u57282024\u5e74\u7b2c\u4e00\u5b63\u5ea6\u7684\u667a\u80fd\u7535\u52a8\u6c7d\u8f66\u7b49\u521b\u65b0\u4e1a\u52a1\u6bdb\u5229\u7387\u4e3a18.5%\uff0c\u5e76\u5728\u968f\u540e\u5b63\u5ea6\u9010\u6b65\u63d0\u5347\u81f326.4%(\u6570\u636e\u00b2)[[\u7f51\u9875\u6765\u6e905]](https://baijiahao.baidu.com/s?id=1840969474506038466&wfr=spider&for=pc)\uff0c\u663e\u793a\u51fa\u5176\u5728\u6210\u672c\u63a7\u5236\u548c\u76c8\u5229\u80fd\u529b\u65b9\u9762\u7684\u6f5c\u529b\u3002\n\n### 2.2 \u6210\u672c\u63a7\u5236\u5206\u6790\n\u5c0f\u7c73\u5728\u8fdb\u5165\u6c7d\u8f66\u9886\u57df\u65f6\uff0c\u91c7\u53d6\u4e86\u9ad8\u5ea6\u5782\u76f4\u6574\u5408\u7684\u7b56\u7565\uff0c\u901a\u8fc7\u81ea\u5efa\u5de5\u5382\u3001\u6df1\u5ea6\u53c2\u4e0e\u4f9b\u5e94\u94fe\u7ba1\u7406\uff0c\u6709\u6548\u63a7\u5236\u4e86\u6210\u672c\u3002\u6b64\u5916\uff0c\u5c0f\u7c73\u54c1\u724c\u5728\u6d88\u8d39\u7535\u5b50\u9886\u57df\u79ef\u7d2f\u7684\u4f9b\u5e94\u94fe\u7ba1\u7406\u7ecf\u9a8c\uff0c\u4e5f\u6709\u52a9\u4e8e\u5176\u5728\u6c7d\u8f66\u5236\u9020\u4e2d\u5b9e\u73b0\u6210\u672c\u4f18\u5316\u3002\n\n---\n\n## \u51c0\u5229\u6da6\u5206\u6790\n**\u7814\u7a76\u76ee\u6807\uff1a** \u5206\u6790\u4f01\u4e1a\u57282022\u5e74\u7684\u51c0\u5229\u6da6\u60c5\u51b5\uff0c\u8bc4\u4f30\u51c0\u5229\u6da6\u7387\u548c\u76c8\u5229\u80fd\u529b\u3002\u901a\u8fc7\u5bf9\u6bd4\u884c\u4e1a\u5e73\u5747\u6c34\u5e73\uff0c\u4e86\u89e3\u4f01\u4e1a\u7684\u8d22\u52a1\u5065\u5eb7\u72b6\u51b5\u3002\n\n### 3.1 \u51c0\u5229\u6da6\u8868\u73b0\n\u5c0f\u7c73\u6c7d\u8f66\u57282022\u5e74\u5c1a\u672a\u4ea7\u751f\u51c0\u5229\u6da6\uff0c\u5176\u6bcd\u516c\u53f8\u5c0f\u7c73\u96c6\u56e2\u5219\u57282024\u5e74\u4e0a\u534a\u5e74\u5b9e\u73b0\u4e86126.67\u4ebf\u5143\u7684\u51c0\u5229\u6da6(\u6570\u636e\u00b3)[[\u7f51\u9875\u6765\u6e909]](https://baijiahao.baidu.com/s?id=1840884446947519461&wfr=spider&for=pc)\uff0c\u663e\u793a\u51fa\u6574\u4f53\u8d22\u52a1\u72b6\u51b5\u7a33\u5065\u3002\u5c0f\u7c73\u6c7d\u8f66\u4f5c\u4e3a\u521b\u65b0\u4e1a\u52a1\u677f\u5757\uff0c\u57282024\u5e74\u5168\u5e74\u7ecf\u8c03\u6574\u51c0\u4e8f\u635f\u4e3a62\u4ebf\u5143\uff0c\u4f46\u4e8f\u635f\u9010\u5b63\u6536\u7a84\uff0c2025\u5e74\u7b2c\u4e8c\u5b63\u5ea6\u7ecf\u8425\u4e8f\u635f\u5df2\u964d\u81f33\u4ebf\u5143(\u6570\u636e\u00b3)[[\u7f51\u9875\u6765\u6e907]](https://baijiahao.baidu.com/s?id=1841063669282659272&wfr=spider&for=pc)\uff0c\u663e\u793a\u51fa\u826f\u597d\u7684\u76c8\u5229\u80fd\u529b\u63d0\u5347\u8d8b\u52bf\u3002\u5434\u9633\u6d4b\u8bd5\u6765\u770b\u770b\u591a\u4e2a\u94fe\u63a5\u548b\u6574[[\u7f51\u9875\u6765\u6e909]](https://baijiahao.baidu.com/s?id=1840884446947519461&wfr=spider&for=pc)\uff0c\u5982\u679c\u662f4\u4e2a\u548b\u6574\u5462[[\u7f51\u9875\u6765\u6e905]](https://baijiahao.baidu.com/s?id=1840969474506038466&wfr=spider&for=pc)\u3002\u54c8\u54c8\u54c8\u6210\u4e86\n\n### 3.2 \u884c\u4e1a\u5bf9\u6bd4\n\u4e0e\u540c\u671f\u65b0\u52bf\u529b\u8f66\u4f01\u76f8\u6bd4\uff0c\u5c0f\u7c73\u6c7d\u8f66\u7684\u4e8f\u635f\u6536\u7a84\u901f\u5ea6\u8f83\u5feb\uff0c\u8868\u660e\u5176\u5728\u6210\u672c\u63a7\u5236\u4e0e\u8fd0\u8425\u6548\u7387\u65b9\u9762\u5177\u5907\u4e00\u5b9a\u4f18\u52bf\u3002\u867d\u7136\u5c1a\u672a\u5b9e\u73b0\u76c8\u5229\uff0c\u4f46\u5176\u6bdb\u5229\u7387\u7684\u6301\u7eed\u4e0a\u5347\uff08\u4ece18.5%\u63d0\u5347\u81f326.4%\uff09\u9884\u793a\u7740\u76c8\u5229\u62d0\u70b9\u5373\u5c06\u5230\u6765(\u6570\u636e\u00b2)[[\u7f51\u9875\u6765\u6e905]](https://baijiahao.baidu.com/s?id=1840969474506038466&wfr=spider&for=pc)\u3002\n\n---\n\n## \u8ba2\u5355\u5206\u6790\n**\u7814\u7a76\u76ee\u6807\uff1a** \u5206\u6790\u4f01\u4e1a\u57282022\u5e74\u7684\u8ba2\u5355\u60c5\u51b5\uff0c\u5305\u62ec\u8ba2\u5355\u6570\u91cf\u3001\u8ba2\u5355\u91d1\u989d\u548c\u8ba2\u5355\u4ea4\u4ed8\u5468\u671f\u3002\u901a\u8fc7\u5185\u90e8\u6570\u636e\u548c\u5e02\u573a\u8d8b\u52bf\uff0c\u8bc4\u4f30\u4f01\u4e1a\u7684\u5e02\u573a\u9700\u6c42\u548c\u5ba2\u6237\u6ee1\u610f\u5ea6\u3002\n\n### 4.1 \u8ba2\u5355\u6570\u91cf\u4e0e\u91d1\u989d\n\u5c0f\u7c73\u6c7d\u8f66\u57282022\u5e74\u5c1a\u672a\u5f00\u59cb\u63a5\u53d7\u8ba2\u5355\uff0c\u56e0\u6b64\u8be5\u5e74\u5ea6\u8ba2\u5355\u6570\u636e\u4e3a\u96f6\u3002\u7136\u800c\uff0c\u5c0f\u7c73SU7\u57282024\u5e743\u6708\u4e0a\u5e02\u540e\uff0c\u8fc5\u901f\u79ef\u7d2f\u4e86\u5927\u91cf\u8ba2\u5355\uff0c\u622a\u81f32025\u5e747\u6708\uff0c\u7d2f\u8ba1\u8ba2\u5355\u903c\u8fd160\u4e07\u8f86(\u6570\u636e\u2074)[[\u7f51\u9875\u6765\u6e901]](https://xueqiu.com/9551863118/349113764)\uff0c\u663e\u793a\u51fa\u5f3a\u52b2\u7684\u5e02\u573a\u9700\u6c42\u3002\n\n### 4.2 \u8ba2\u5355\u4ea4\u4ed8\u5468\u671f\n\u5c3d\u7ba1\u5c0f\u7c73\u6c7d\u8f66\u57282022\u5e74\u65e0\u8ba2\u5355\u4ea4\u4ed8\uff0c\u4f46\u5176\u540e\u7eed\u8f66\u578bSU7\u548cYU7\u7684\u4ea4\u4ed8\u5468\u671f\u8f83\u957f\uff0c\u5176\u4e2dYU7\u6807\u51c6\u7248\u4ea4\u4ed8\u5468\u671f\u957f\u8fbe55-58\u5468(\u6570\u636e\u2074)[[\u7f51\u9875\u6765\u6e903]](https://news.yiche.com/hao/wenzhang/102972119/)\uff0c\u53cd\u6620\u51fa\u5f53\u524d\u4ea7\u80fd\u722c\u5761\u4ecd\u9762\u4e34\u6311\u6218\u3002\n\n---\n\n## \u5e02\u573a\u5bf9\u6807\u5206\u6790\n**\u7814\u7a76\u76ee\u6807\uff1a** \u901a\u8fc7\u5bf9\u6bd4\u884c\u4e1a\u5e73\u5747\u548c\u7ade\u4e89\u5bf9\u624b\u6570\u636e\uff0c\u8bc4\u4f30\u4f01\u4e1a\u5728\u5e02\u573a\u4e2d\u7684\u8868\u73b0\u548c\u7ade\u4e89\u529b\u3002\u5206\u6790\u5e02\u573a\u8d8b\u52bf\u548c\u53d8\u5316\uff0c\u63d0\u4f9b\u6218\u7565\u5efa\u8bae\u3002\n\n### 5.1 \u884c\u4e1a\u8868\u73b0\u5bf9\u6bd4\n\u5c0f\u7c73\u6c7d\u8f66\u4f5c\u4e3a\u65b0\u664b\u9020\u8f66\u52bf\u529b\uff0c\u5176\u4ea4\u4ed8\u901f\u5ea6\u8fdc\u8d85\u884c\u4e1a\u5e73\u5747\u6c34\u5e73\u3002SU7\u5728\u4e0a\u5e0215\u4e2a\u6708\u5185\u4ea4\u4ed8\u91cf\u7a81\u783430\u4e07\u8f86\uff0c\u8d85\u8d8a\u7279\u65af\u62c9Model Y\u768418\u4e2a\u6708\u8bb0\u5f55(\u6570\u636e\u2075)[[\u7f51\u9875\u6765\u6e901]](https://xueqiu.com/9551863118/349113764)\u3002\u6b64\u5916\uff0c\u5176\u6bdb\u5229\u738726.4%\u4e5f\u663e\u8457\u9ad8\u4e8e\u7279\u65af\u62c9\u540c\u671f\u768417.2%(\u6570\u636e\u2075)[[\u7f51\u9875\u6765\u6e905]](https://baijiahao.baidu.com/s?id=1840969474506038466&wfr=spider&for=pc)\uff0c\u663e\u793a\u51fa\u66f4\u5f3a\u7684\u76c8\u5229\u80fd\u529b\u3002\n\n### 5.2 \u7ade\u4e89\u5bf9\u624b\u5206\u6790\n\u76f8\u8f83\u4e8e\u851a\u6765\u3001\u5c0f\u9e4f\u3001\u7406\u60f3\u7b49\u65b0\u52bf\u529b\u54c1\u724c\uff0c\u5c0f\u7c73\u51ed\u501f\u5176\u5f3a\u5927\u7684\u54c1\u724c\u5f71\u54cd\u529b\u3001\u7528\u6237\u751f\u6001\u4f53\u7cfb\u53ca\u4f9b\u5e94\u94fe\u6574\u5408\u80fd\u529b\uff0c\u5728\u6210\u672c\u63a7\u5236\u4e0e\u5e02\u573a\u62d3\u5c55\u65b9\u9762\u5177\u5907\u72ec\u7279\u4f18\u52bf\u3002\u7136\u800c\uff0c\u5176\u4ea4\u4ed8\u5468\u671f\u957f\u3001\u4ea7\u80fd\u722c\u5761\u7f13\u6162\u4ecd\u662f\u5f53\u524d\u7684\u4e3b\u8981\u6311\u6218\u3002\n\n---\n\n## RPE (\u52aa\u529b\u7a0b\u5ea6\u7b49\u7ea7) \u8868\u683c\u4e0e\u76ee\u6807\u8bbe\u7f6e\n\n| RPE \u7b49\u7ea7 | \u63cf\u8ff0 (\u4f60\u80fd\u518d\u505a\u51e0\u6b21\uff1f) | \u611f\u53d7\uff08\u4e3b\u89c2\u4f53\u4f1a\uff09 | \u9002\u5408\u8bbe\u4e3a\u76ee\u6807\u7684\u60c5\u51b5 |\n| --- | --- | --- | --- |\n| **10** | **\u5b8c\u5168\u529b\u7aed\uff0c\u518d\u4e5f\u505a\u4e0d\u4e86 1 \u6b21\u3002** | \u52a8\u4f5c\u5df2\u975e\u5e38\u5403\u529b\uff0c\u65e0\u6cd5\u5b8c\u6210\u4e0b\u4e00\u6b21\u91cd\u590d\u3002 | **\u6781\u5c11\u4f7f\u7528\uff0c\u65b0\u624b\u5c24\u5176\u907f\u514d\u3002**\u2013 \u4ec5\u9650\u4e8e\u7ecf\u9a8c\u4e30\u5bcc\u7684\u8fd0\u52a8\u5458\u5728\u7279\u5b9a\u8bad\u7ec3\u5468\u671f\uff08\u5982\u529b\u91cf\u5cf0\u503c\u671f\uff09\u5076\u5c14\u51b2\u51fb\u4e2a\u4eba\u6781\u9650\u3002\u2013 \u5bf9\u4e8e\u65b0\u624b\u6216\u51cf\u8102\u671f\uff0c**\u5e94\u5b8c\u5168\u907f\u514d**\uff0c\u56e0\u4e3a\u98ce\u9669\u9ad8\u3001\u6062\u590d\u6162\u3001\u4e0d\u9002\u5408\u957f\u671f\u4f7f\u7528\u3002 |\n| **9** | **\u8fd8\u80fd\u518d\u505a 1 \u6b21\u3002** | \u975e\u5e38\u975e\u5e38\u5403\u529b\uff0c\u4e0b\u4e00\u79d2\u5c31\u4f1a\u529b\u7aed\u3002 | **\u7528\u4e8e\u8fdb\u9636\u671f\u6216\u589e\u808c\u671f\u540e\u671f\u3002**\u2013 \u9002\u5408\u6709\u4e00\u5b9a\u8bad\u7ec3\u7ecf\u9a8c\u7684\u4e2a\u4f53\uff0c\u5728\u4e3b\u8981\u590d\u5408\u52a8\u4f5c\uff08\u5982\u6df1\u8e72\u3001\u5367\u63a8\u3001\u786c\u62c9\uff09\u4e2d\u5076\u5c14\u7528\u6765\u6311\u6218\u81ea\u6211\u3002\u2013 \u65e8\u5728\u7ed9\u4e88\u808c\u8089\u6700\u5927\u523a\u6fc0\uff0c\u4f46\u6062\u590d\u65f6\u95f4\u76f8\u5bf9\u957f\u3002\u2013 \u65b0\u624b\u5e94\u8c28\u614e\u4f7f\u7528\uff0c\u4e14\u4ec5\u5728\u6700\u540e\u4e00\u7ec4\u5c1d\u8bd5\u3002 |\n| **8** | **\u8fd8\u80fd\u518d\u505a 2 \u6b21\u3002** | \u5f88\u5403\u529b\uff0c\u4f46\u52a8\u4f5c\u4f9d\u7136\u80fd\u4fdd\u6301\u6807\u51c6\uff0c\u611f\u5230\u660e\u663e\u7684\u6cf5\u611f\u548c\u76ee\u6807\u808c\u8089\u75b2\u52b3\u3002 | **\u6700\u5e38\u7528\u7684\u8bad\u7ec3\u5f3a\u5ea6\uff0c\u9002\u5408\u5927\u591a\u6570\u5065\u8eab\u8005\u3002**\u2013 **\u65b0\u624b\u4e3b\u8981\u529b\u91cf\u8bad\u7ec3\u76ee\u6807\uff1a** \u786e\u4fdd\u6709\u6548\u523a\u6fc0\u808c\u8089\uff0c\u540c\u65f6\u6709\u5b89\u5168\u4f59\u5730\uff0c\u964d\u4f4e\u53d7\u4f24\u98ce\u9669\u3002\u2013 **\u51cf\u8102\u671f\uff1a** \u5728\u70ed\u91cf\u8d64\u5b57\u4e0b\u6709\u6548\u523a\u6fc0\u808c\u8089\uff0c\u7ef4\u6301\u6216\u589e\u957f\u808c\u8089\u3002\u2013 **\u589e\u808c\u671f\uff1a** \u63d0\u4f9b\u8db3\u591f\u7684\u523a\u6fc0\uff0c\u4fc3\u8fdb\u808c\u8089\u80a5\u5927\u3002\u2013 \u4e5f\u662f\u8bc4\u4f30\u529b\u91cf\u8fdb\u6b65\u7684\u5e38\u89c1\u7b49\u7ea7\u3002 |\n| **7** | **\u8fd8\u80fd\u518d\u505a 3 \u6b21\u3002** | \u6bd4\u8f83\u5403\u529b\uff0c\u76ee\u6807\u808c\u8089\u6709\u9178\u80c0\u611f\uff0c\u4f46\u52a8\u4f5c\u6d41\u7545\uff0c\u63a7\u5236\u826f\u597d\u3002 | **\u65b0\u624b\u521d\u671f\u8bad\u7ec3\u6838\u5fc3\u76ee\u6807\uff0c\u6216\u4f5c\u4e3a\u6b63\u5f0f\u8bad\u7ec3\u524d\u7684\u201c\u70ed\u8eab\u7ec4\u201d\u5f3a\u5ea6\u3002**\u2013 **\u65b0\u624b\u5f00\u59cb\u6062\u590d\u8bad\u7ec3\u65f6\uff1a** \u63d0\u4f9b\u9002\u5ea6\u523a\u6fc0\uff0c\u5524\u9192\u808c\u8089\uff0c\u5b66\u4e60\u52a8\u4f5c\u6a21\u5f0f\uff0c\u5efa\u7acb\u4fe1\u5fc3\u3002\u2013 **\u4efb\u4f55\u8bad\u7ec3\u8ba1\u5212\u4e2d\u7684\u201c\u8f85\u52a9\u52a8\u4f5c\u201d\uff1a** \u786e\u4fdd\u8d28\u91cf\u548c\u6062\u590d\uff0c\u4e0d\u8ffd\u6c42\u6781\u9650\u3002\u2013 \u5c24\u5176\u9002\u5408\u4f60\u76ee\u524d**\u53d7\u4f24\u6062\u590d\u671f\u540e\u7684\u521d\u671f\u8bad\u7ec3**\uff0c\u4fdd\u8bc1\u5b89\u5168\u548c\u6280\u672f\u4f18\u5148\u3002 |\n| **6** | **\u8fd8\u80fd\u518d\u505a 4-5 \u6b21\u3002** | \u76f8\u5bf9\u8f7b\u677e\uff0c\u76ee\u6807\u808c\u8089\u6709\u611f\u89c9\uff0c\u4f46\u6ca1\u6709\u660e\u663e\u75b2\u52b3\u6216\u70e7\u707c\u611f\u3002 | **\u65b0\u624b\u9002\u5e94\u671f\u3001\u6280\u672f\u7ec3\u4e60\u3001\u70ed\u8eab\u7ec4\u6216\u52a8\u6001\u6062\u590d\u3002**\u2013 **\u521d\u671f\u529b\u91cf\u8bad\u7ec3\uff1a** \u5e2e\u52a9\u8eab\u4f53\u9002\u5e94\u52a8\u4f5c\uff0c\u5efa\u7acb\u57fa\u7840\u8010\u529b\u3002\u2013 **\u5b66\u4e60\u65b0\u52a8\u4f5c\u65f6\uff1a** \u4e13\u6ce8\u4e8e\u6280\u672f\uff0c\u4e0d\u8ffd\u6c42\u91cd\u91cf\u3002\u2013 **\u4e3b\u52a8\u6062\u590d\u65e5\uff1a** \u8fdb\u884c\u8f7b\u91cf\u7ea7\u6d3b\u52a8\uff0c\u4fc3\u8fdb\u8840\u6db2\u5faa\u73af\u3002 |\n| **5 \u53ca\u4ee5\u4e0b** | **\u8fd8\u80fd\u505a 6 \u6b21\u4ee5\u4e0a\u6216\u66f4\u591a\uff0c\u975e\u5e38\u8f7b\u677e\u3002** | \u51e0\u4e4e\u4e0d\u8d39\u529b\uff0c\u5c31\u50cf\u65e5\u5e38\u6d3b\u52a8\uff0c\u6ca1\u6709\u8bad\u7ec3\u7684\u611f\u89c9\u3002 | **\u8d85\u7ea7\u70ed\u8eab\u3001\u6280\u672f\u4fee\u6b63\u3001\u52a8\u6001\u62c9\u4f38\u3002**\u2013 \u4ec5\u7528\u4e8e\u975e\u5e38\u521d\u7ea7\u7684\u70ed\u8eab\uff0c\u6216\u5728\u5b66\u4e60\u975e\u5e38\u590d\u6742\u7684\u6280\u672f\u52a8\u4f5c\u65f6\u3002 |\n\n---\n\n## \u603b\u7ed3\u4e0e\u5efa\u8bae\n\u5c0f\u7c73\u6c7d\u8f66\u57282022\u5e74\u867d\u5c1a\u672a\u4ea7\u751f\u5b9e\u9645\u8425\u6536\u4e0e\u8ba2\u5355\u6570\u636e\uff0c\u4f46\u5176\u6bcd\u516c\u53f8\u5c0f\u7c73\u96c6\u56e2\u7684\u6574\u4f53\u8d22\u52a1\u72b6\u51b5\u7a33\u5065\uff0c\u4e3a\u5176\u540e\u7eed\u6c7d\u8f66\u4e1a\u52a1\u7684\u53d1\u5c55\u63d0\u4f9b\u4e86\u575a\u5b9e\u57fa\u7840\u3002\u8fdb\u51652024\u5e74\u540e\uff0c\u5c0f\u7c73\u6c7d\u8f66\u8fc5\u901f\u5d1b\u8d77\uff0cSU7\u4e0eYU7\u7cfb\u5217\u8ba2\u5355\u706b\u7206\uff0c\u6bdb\u5229\u7387\u6301\u7eed\u4e0a\u5347\uff0c\u4e8f\u635f\u9010\u6b65\u6536\u7a84\uff0c\u5c55\u73b0\u51fa\u5f3a\u52b2\u7684\u76c8\u5229\u80fd\u529b\u63d0\u5347\u8d8b\u52bf\u3002\n\n**\u5efa\u8bae\u5982\u4e0b\uff1a**\n1. **\u52a0\u5feb\u4ea7\u80fd\u5efa\u8bbe**\uff1a\u5c3d\u5feb\u5b8c\u6210\u4e8c\u671f\u5de5\u5382\u4ea7\u80fd\u722c\u5761\uff0c\u7f29\u77ed\u4ea4\u4ed8\u5468\u671f\uff0c\u63d0\u5347\u7528\u6237\u6ee1\u610f\u5ea6\u3002\n2. **\u52a0\u5f3a\u8d28\u91cf\u63a7\u5236**\uff1a\u9488\u5bf9SU7\u201c\u5f00\u5b54\u4e8b\u4ef6\u201d\u7b49\u8d28\u91cf\u4e89\u8bae\uff0c\u5f3a\u5316\u54c1\u63a7\u4f53\u7cfb\uff0c\u7ef4\u62a4\u54c1\u724c\u4fe1\u8a89\u3002\n3. **\u6df1\u5316\u751f\u6001\u6574\u5408**\uff1a\u5229\u7528\u5c0f\u7c73\u751f\u6001\u7528\u6237\u8d44\u6e90\uff0c\u63d0\u5347\u8f66\u4e3b\u7c98\u6027\u4e0e\u590d\u8d2d\u7387\u3002\n4. **\u62d3\u5c55\u6d77\u5916\u5e02\u573a**\uff1a\u6309\u8ba1\u5212\u4e8e2027\u5e74\u8fdb\u5165\u6b27\u6d32\u5e02\u573a\uff0c\u6269\u5927\u5168\u7403\u5f71\u54cd\u529b\u3002\n\n\u5c0f\u7c73\u6c7d\u8f66\u6b63\u9010\u6b65\u6210\u957f\u4e3a\u65b0\u52bf\u529b\u54c1\u724c\u4e2d\u7684\u4f7c\u4f7c\u8005\uff0c\u672a\u6765\u6709\u671b\u5728\u667a\u80fd\u7535\u52a8\u6c7d\u8f66\u9886\u57df\u5b9e\u73b0\u5feb\u901f\u76c8\u5229\u4e0e\u89c4\u6a21\u5316\u53d1\u5c55\u3002\n\n---\n\n## \u6570\u636e\u6765\u6e90\n1. \u8425\u6536\u4e0e\u56de\u6b3e\u60c5\u51b5\n2. \u6bdb\u5229\u4e0e\u6bdb\u5229\u7387\n3. \u51c0\u5229\u6da6\u4e0e\u4e8f\u635f\u6536\u7a84\n4. \u8ba2\u5355\u60c5\u51b5\n5. \u884c\u4e1a\u5bf9\u6807\u6570\u636e\n\n## \u7f51\u9875\u6765\u6e90\n1. [\u5c0f\u7c73\u6c7d\u8f66\u5e02\u573a\u8868\u73b0\u4e0e\u4ea7\u80fd\u5206\u6790](https://xueqiu.com/9551863118/349113764)\n2. [\u3010\u5c0f\u7c73\u6c7d\u8f66\u30112024\u5e74\u548c2025\u5e74\u7684\u3010\u6bcf\u6708\u4ea4\u4ed8\u3011\u6570\u636e\u5206\u6790](https://caifuhao.eastmoney.com/news/20250802185707450430310)\n3. [\u5c0f\u7c73\u6c7d\u8f66\u5355\u5b63\u76c8\u5229\u5728\u5373!\u4ea4\u4ed8\u56f0\u5c40\u4ecd\u7136\u5f85\u89e3?](https://news.yiche.com/hao/wenzhang/102972119/)\n4. [\u5c0f\u7c73\u6c7d\u8f66\u5355\u5b63\u76c8\u5229\u5728\u5373!Q2\u51c0\u5229\u66b4\u6da875.4%,\u4ea4\u4ed8\u56f0\u5c40\u4ecd\u7136\u5f85\u89e3?](https://chejiahao.autohome.com.cn/info/21668047)\n5. [\u5c0f\u7c73\u6c7d\u8f66\u52a9\u8425\u6536\u589e\u4e09\u6210!\u4e0b\u534a\u5e74\u6216\u6b62\u4e8f](https://baijiahao.baidu.com/s?id=1840969474506038466&wfr=spider&for=pc)\n6. [\u5c0f\u7c73\u96c6\u56e2\u8d22\u62a5\u4f1a:\u6c7d\u8f66\u4e1a\u52a1\u4e0b\u534a\u5e74\u76c8\u5229](https://chejiahao.autohome.com.cn/info/21651286)\n7. [\u5c0f\u7c73\u6c7d\u8f66\u5355\u5b63\u76c8\u5229\u5728\u5373!Q2\u51c0\u5229\u66b4\u6da875.4%,\u4ea4\u4ed8\u56f0\u5c40\u4ecd\u7136\u5f85\u89e3?](https://baijiahao.baidu.com/s?id=1841063669282659272&wfr=spider&for=pc)\n8. [\u51b2\u523a\u6700\u5feb\u76c8\u5229\u65b0\u52bf\u529b:\u5c0f\u7c73\u6c7d\u8f66\u7b49\u521b\u65b0\u4e1a\u52a1\u4e8f\u635f\u7f29\u81f38\u4ebf\u5143 YU7\u70ed\u9500\u4ecd\u9762\u4e34\u201c\u4ea4\u4ed8\u5927\u8003\u201d](https://baijiahao.baidu.com/s?id=1841017134333375879&wfr=spider&for=pc)\n9. [\u51b2\u523a\u6700\u5feb\u76c8\u5229\u65b0\u52bf\u529b:\u5c0f\u7c73\u6c7d\u8f66\u7b49\u521b\u65b0\u4e1a\u52a1\u4e8f\u635f\u7f29\u81f38\u4ebf\u5143 YU7\u70ed\u9500\u4ecd\u9762\u4e34\u201c\u4ea4\u4ed8\u5927\u8003\u201d](https://baijiahao.baidu.com/s?id=1840884446947519461&wfr=spider&for=pc)\n10. [\ud83d\ude97\u5c0f\u7c73\u6c7d\u8f66\u5206\u671f\u8d2d\u8f66\u653b\u7565\ud83d\udcb3-\u6709\u9a7e](https://m.yoojia.com/pages/dongtai/index?id=1816025002&from_src=biji_tab)";
        String mdText2 = "# 2025 \u5e74\u5168\u7403\u53ca\u4e2d\u56fd\u80a1\u5e02\u6df1\u5ea6\u5206\u6790\u62a5\u544a  \n\n## 1. 2025 \u5e74\u5168\u7403\u53ca\u4e2d\u56fd\u80a1\u5e02\u6574\u4f53\u8d70\u52bf  \n\n### 1.1 \u5168\u7403\u5e02\u573a\u6982\u51b5  \n2025 \u5e74\u5168\u7403\u80a1\u5e02\u5448\u73b0 **\"\u5206\u5316\u590d\u82cf\"** \u7279\u5f81\uff1a  \n- **\u53d1\u8fbe\u5e02\u573a**\uff1a\u7f8e\u8054\u50a8\u653f\u7b56\u8f6c\u5411\u540e\uff0c\u7f8e\u80a1\u4f30\u503c\u4fee\u590d\u4f46\u53d7\u5236\u4e8e\u4f01\u4e1a\u76c8\u5229\u589e\u901f\u653e\u7f13\uff08\u6807\u666e 500 EPS \u589e\u901f\u9884\u671f 4%-6% vs 2024 \u5e74 8%\uff09\uff1b\u6b27\u6d32\u80a1\u5e02\u53d7\u76ca\u4e8e\u80fd\u6e90\u8f6c\u578b\u6295\u8d44\u52a0\u901f\uff08\u6b27\u76df\u7eff\u8272\u65b0\u653f 2.0 \u843d\u5730\uff09\u3002  \n- **\u65b0\u5174\u5e02\u573a**\uff1a\u4e1c\u5357\u4e9a\uff08\u8d8a\u5357\u3001\u5370\u5ea6\uff09\u627f\u63a5\u4ea7\u4e1a\u94fe\u8f6c\u79fb\uff0c\u80a1\u5e02\u6d41\u52a8\u6027\u6ea2\u4ef7\u663e\u8457\uff1b\u62c9\u7f8e\u5e02\u573a\u53d7\u5927\u5b97\u5546\u54c1\u4ef7\u683c\u6ce2\u52a8\u5f71\u54cd\u8f83\u5927\u3002  \n\n### 1.2 A \u80a1\u5e02\u573a\u5173\u952e\u6570\u636e  \n| \u6307\u6807            | 2024 \u5e74    | 2025 \u5e74\uff08\u9884\u6d4b\uff09 | \u53d8\u52a8\u56e0\u7d20\u5206\u6790               |  \n|-----------------|------------|----------------|---------------------------|  \n| \u4e0a\u8bc1\u6307\u6570\u70b9\u4f4d    | 3200-3400  | 3400-3700      | \u8d44\u91d1\u9762\u5bbd\u677e + \u653f\u7b56\u6258\u5e95\u6548\u5e94 |  \n| \u65e5\u5747\u6210\u4ea4\u989d      | 1.2 \u4e07\u4ebf   | 1.5-2 \u4e07\u4ebf     | \u91cf\u5316\u4ea4\u6613\u5360\u6bd4\u5347\u81f3 35%      |  \n| \u5916\u8d44\u51c0\u6d41\u5165      | 1800 \u4ebf    | 2200 \u4ebf        | MSCI \u7eb3\u5165\u56e0\u5b50\u63d0\u9ad8\u81f3 25%   |  \n\n**\u6280\u672f\u9762\u7a81\u7834**\uff1a2025 \u5e74 4-8 \u6708\u671f\u95f4 A \u80a1\u8fde\u7eed\u7a81\u7834 3674 \u70b9\u548c 3700 \u70b9\u5173\u952e\u963b\u529b\u4f4d\uff0c\u9a8c\u8bc1\u4e86 **\"\u6d41\u52a8\u6027\u9a71\u52a8\u884c\u60c5\"** \u7684\u903b\u8f91\u3002  \n\n---\n\n## 2. \u6838\u5fc3\u5f71\u54cd\u56e0\u7d20\u6df1\u5ea6\u89e3\u6790  \n\n### 2.1 \u5b8f\u89c2\u7ecf\u6d4e\u653f\u7b56  \n- **\u4e2d\u56fd\u8d22\u653f\u653f\u7b56**\uff1a  \n  - \u8d64\u5b57\u7387\u63a7\u5236\u5728 **3%-4%** \u533a\u95f4\uff0c\u4e13\u9879\u503a\u53d1\u884c\u4fa7\u91cd **\"\u65b0\u57fa\u5efa 2.0\"**\uff08\u542b 6G \u8bd5\u9a8c\u7f51\u7edc\u3001\u91cf\u5b50\u8ba1\u7b97\u4e2d\u5fc3\uff09\u3002  \n  - \u4e0e\u7f8e\u56fd\u8d38\u6613\u6469\u64e6\u9884\u6848\uff1a\u901a\u8fc7 **\"\u96f6\u5173\u7a0e + \u5e02\u573a\u51c6\u5165\"** \u7ec4\u5408\u62f3\u5bf9\u51b2\u5173\u7a0e\u51b2\u51fb\uff08\u4eba\u6c11\u5e01\u4e3b\u52a8\u8d2c\u503c 5%-7%\uff09\u3002  \n\n- **\u8d27\u5e01\u653f\u7b56**\uff1a  \n  - \u4e2d\u7f8e\u5229\u5dee\u5012\u6302\u6536\u7a84\u81f3 50-80BP\uff0c\u4e3a\u56fd\u5185\u964d\u606f\u63d0\u4f9b\u7a7a\u95f4\uff08\u9884\u8ba1 LPR \u4e0b\u8c03 15-25BP\uff09\u3002  \n\n### 2.2 \u4ea7\u4e1a\u53d8\u9769\u9a71\u52a8  \n```mermaid  \ngraph LR  \nA[AI \u6280\u672f\u7a81\u7834] --> B(\u4eba\u5f62\u673a\u5668\u4eba\u91cf\u4ea7)  \nB --> C[\u8c10\u6ce2\u51cf\u901f\u5668\u9700\u6c42\u7206\u53d1]  \nC --> D[\u7eff\u7684\u8c10\u6ce2 688017.SH \u51c0\u5229 4.56 \u4ebf]  \nD --> E[\u677f\u5757\u4f30\u503c PE 93 \u500d]  \n```\n\n<img src='https://quickchart.io/chart?c=%7B%22type%22%3A%22pie%22%2C%22data%22%3A%7B%22labels%22%3A%5B%22%E5%BA%94%E6%94%B6%E8%B4%A6%E6%AC%BE%E6%80%BB%E9%A2%9D%22%2C%22%E9%A2%84%E6%94%B6%E6%AC%BE%E6%80%BB%E9%A2%9D%22%5D%2C%22datasets%22%3A%5B%7B%22label%22%3A%22%E9%87%91%E9%A2%9D(%E5%85%83)%22%2C%22data%22%3A%5B90538.7%2C110693.4%5D%2C%22backgroundColor%22%3A%5B%22rgba(75%2C%20192%2C%20192%2C%200.6)%22%2C%22rgba(255%2C%2099%2C%20132%2C%200.6)%22%5D%7D%5D%7D%2C%22options%22%3A%7B%22responsive%22%3Atrue%2C%22plugins%22%3A%7B%22title%22%3A%7B%22display%22%3Atrue%2C%22text%22%3A%222016%E5%B9%B412%E6%9C%88%E5%BA%94%E6%94%B6%E8%B4%A6%E6%AC%BE%E4%B8%8E%E9%A2%84%E6%94%B6%E6%AC%BE%E6%AF%94%E4%BE%8B(%E5%8D%95%E4%BD%8D%3A%E5%85%83)%22%7D%7D%7D%7D'/>\n<img src='https://quickchart.io/chart?c=%7B%22type%22%3A%22bar%22%2C%22data%22%3A%7B%22labels%22%3A%5B%22%E7%BA%B3%E5%8F%AF%E4%BF%A1%22%2C%22%E6%B1%9F%E8%8B%8F%E5%AE%9D%E5%BA%94%22%2C%22%E5%8D%8E%E6%99%AF%22%2C%22%E6%B8%B8%E5%BB%BA%E5%8D%8E%22%2C%22%E5%B8%82%E4%B8%89%E4%BC%8F%22%2C%22%E6%99%8B%E6%B1%9F%E9%87%91%E4%BA%9A%22%2C%22%E5%85%83%E5%BE%81%E7%A7%91%E6%8A%80%22%2C%22%E6%B3%89%E5%B7%9E%E4%B8%9C%E4%BA%9A%22%2C%22%E5%B9%BF%E5%B7%9E%E8%B5%AB%E5%8A%9B%22%2C%22%E8%90%A5%E5%8F%A3%E9%80%9A%E5%B9%BF%22%2C%22%E7%A6%8F%E5%AE%89%E6%97%BA%E5%92%8C%22%2C%22%E8%90%A5%E5%8F%A3%E7%AB%8B%E5%BE%B7%22%2C%22%E4%B8%8A%E6%B5%B7%E7%9B%88%E8%BF%AA%22%2C%22%E8%90%A5%E5%8F%A3%E4%BA%A4%E9%80%9A%22%2C%22%E5%86%AF%E5%BE%BD%E5%BE%BD%22%2C%22%E8%90%A5%E5%8F%A3%E5%A5%94%E6%9D%B0%22%2C%22%E8%90%A5%E5%8F%A3%E9%BB%8E%E6%98%8E%22%2C%22%E5%93%88%E5%B0%94%E6%BB%A8%E7%9B%8A%E4%BB%81%22%2C%22BARE%20MACHMERY%22%2C%22%E7%A7%91%E6%98%9F%22%2C%22%E4%B8%AD%E5%B1%B1%E7%A7%91%E6%98%9F%22%5D%2C%22datasets%22%3A%5B%7B%22label%22%3A%22%E5%BA%94%E6%94%B6%E8%B4%A6%E6%AC%BE%E4%BD%99%E9%A2%9D(%E5%85%83)%22%2C%22data%22%3A%5B36205%2C11571%2C11200%2C10020%2C9962%2C8406.5%2C2364%2C1411.2%2C0%2C0%2C0%2C-6%2C-400%2C-453%2C-468%2C-815%2C-906%2C-2200%2C-2803.2%2C-9416%2C-76532%5D%2C%22backgroundColor%22%3A%5B%22rgba(75%2C%20192%2C%20192%2C%200.6)%22%2C%22rgba(75%2C%20192%2C%20192%2C%200.6)%22%2C%22rgba(75%2C%20192%2C%20192%2C%200.6)%22%2C%22rgba(75%2C%20192%2C%20192%2C%200.6)%22%2C%22rgba(75%2C%20192%2C%20192%2C%200.6)%22%2C%22rgba(75%2C%20192%2C%20192%2C%200.6)%22%2C%22rgba(75%2C%20192%2C%20192%2C%200.6)%22%2C%22rgba(75%2C%20192%2C%20192%2C%200.6)%22%2C%22rgba(75%2C%20192%2C%20192%2C%200.6)%22%2C%22rgba(75%2C%20192%2C%20192%2C%200.6)%22%2C%22rgba(75%2C%20192%2C%20192%2C%200.6)%22%2C%22rgba(255%2C%2099%2C%20132%2C%200.6)%22%2C%22rgba(255%2C%2099%2C%20132%2C%200.6)%22%2C%22rgba(255%2C%2099%2C%20132%2C%200.6)%22%2C%22rgba(255%2C%2099%2C%20132%2C%200.6)%22%2C%22rgba(255%2C%2099%2C%20132%2C%200.6)%22%2C%22rgba(255%2C%2099%2C%20132%2C%200.6)%22%2C%22rgba(255%2C%2099%2C%20132%2C%200.6)%22%2C%22rgba(255%2C%2099%2C%20132%2C%200.6)%22%2C%22rgba(255%2C%2099%2C%20132%2C%200.6)%22%2C%22rgba(255%2C%2099%2C%20132%2C%200.6)%22%5D%7D%5D%7D%2C%22options%22%3A%7B%22responsive%22%3Atrue%2C%22plugins%22%3A%7B%22title%22%3A%7B%22display%22%3Atrue%2C%22text%22%3A%222016%E5%B9%B412%E6%9C%88%E5%90%84%E5%AE%A2%E6%88%B7%E5%BA%94%E6%94%B6%E8%B4%A6%E6%AC%BE%E4%BD%99%E9%A2%9D%E5%88%86%E5%B8%83%22%7D%7D%2C%22scales%22%3A%7B%22x%22%3A%7B%22ticks%22%3A%7B%22autoSkip%22%3Afalse%2C%22maxRotation%22%3A90%2C%22minRotation%22%3A90%7D%7D%7D%7D%7D'/>\n\n### 2.3 \u98ce\u9669\u8b66\u793a  \n- **\u9ed1\u5929\u9e45\u6e05\u5355**\uff1a  \n  1. \u7f8e\u56fd\u5bf9\u534e\u534a\u5bfc\u4f53\u8bbe\u5907\u7981\u8fd0\u5347\u7ea7  \n  2. \u5168\u7403\u7cae\u98df\u5371\u673a\u89e6\u53d1\u901a\u80c0\u53cd\u5f39  \n  3. \u65e5\u672c\u592e\u884c\u610f\u5916\u7ed3\u675f YCC \u653f\u7b56  \n\n---\n\n## 3. \u884c\u4e1a\u914d\u7f6e\u7b56\u7565  \n\n### 3.1 \u9ad8\u666f\u6c14\u8d5b\u9053  \n| \u884c\u4e1a           | \u6838\u5fc3\u903b\u8f91                          | \u91cd\u70b9\u6807\u7684                  | \u98ce\u9669\u63d0\u793a                |  \n|----------------|-----------------------------------|--------------------------|------------------------|  \n| \u533b\u7597\u673a\u5668\u4eba     | \u767e\u4ebf\u5e02\u573a + \u7eb3\u7c73\u6280\u672f\u7a81\u7834           | \u5929\u667a\u822a\uff08688277.SH\uff09      | \u7814\u53d1\u5468\u671f\u957f             |  \n| \u5de5\u4e1a\u6bcd\u673a       | \u8fdb\u53e3\u66ff\u4ee3\u7387\u7a81\u7834 60%                | \u7ebd\u5a01\u6570\u63a7\uff08688697.SH\uff09    | \u94a2\u6750\u6210\u672c\u6ce2\u52a8           |  \n| \u50a8\u80fd           | \u5168\u7403\u5149\u4f0f\u88c5\u673a\u91cf\u8d85 400GW            | \u9633\u5149\u7535\u6e90\uff08300274.SZ\uff09    | \u6d77\u5916\u8d38\u6613\u58c1\u5792           |  \n\n### 3.2 \u4ef7\u503c\u91cd\u4f30\u673a\u4f1a  \n- **\u6d88\u8d39\u7535\u5b50**\uff1a2025 \u5e74\u82f9\u679c AR \u773c\u955c\u51fa\u8d27\u91cf\u9884\u671f\u4e0a\u8c03\u81f3 1200 \u4e07\u53f0\uff08\u4f9b\u5e94\u94fe\u4f01\u4e1a\u4e1a\u7ee9\u5f39\u6027\u5927\uff09\u3002  \n- **\u822a\u8fd0**\uff1a\u7ea2\u6d77\u5371\u673a\u5e38\u6001\u5316\u63a8\u5347 SCFI \u6307\u6570\u5168\u5e74\u5747\u503c\u81f3 1800 \u70b9\uff08\u4e2d\u8fdc\u6d77\u63a7\u80a1\u606f\u7387\u6216\u8fbe 8%\uff09\u3002  \n\n---\n\n## 4. 2025 \u5e74 vs 2024 \u5e74\u5173\u952e\u53d8\u5316  \n\n### 4.1 \u5e02\u573a\u7279\u5f81\u8f6c\u53d8  \n- \u4ece **\"\u9884\u671f\u535a\u5f08\"** \u8f6c\u5411 **\"\u4e1a\u7ee9\u9a8c\u8bc1\"**\uff1a2024 \u5e74\u7092\u4f5c AI \u6982\u5ff5\uff0c2025 \u5e74\u9700\u5173\u6ce8\u4eba\u5f62\u673a\u5668\u4eba\u5b9e\u9645\u9500\u91cf\u6570\u636e\u3002  \n- \u6ce2\u52a8\u7387\u4e0b\u964d\uff1a\u6caa\u6df1 300 \u5e74\u5316\u6ce2\u52a8\u7387\u4ece 22% \u964d\u81f3 18%\uff0c\u673a\u6784\u6301\u4ed3\u96c6\u4e2d\u5ea6\u63d0\u5347\u3002  \n\n### 4.2 \u65b0\u53d8\u91cf\u5f15\u5165  \n- **\u78b3\u5173\u7a0e\u5b9e\u65bd**\uff1a\u6b27\u76df CBAM \u8986\u76d6\u8303\u56f4\u6269\u5927\u81f3\u5851\u6599\u3001\u6c22\u80fd\uff0c\u5229\u597d\u56fd\u5185\u5149\u4f0f\u4ea7\u4e1a\u94fe\uff08\u51fa\u53e3\u6ea2\u4ef7 15%-20%\uff09\u3002  \n- **\u5730\u7f18\u653f\u6cbb\u5b9a\u4ef7**\uff1a\u53f0\u6d77\u98ce\u9669\u6ea2\u4ef7\u5df2\u53cd\u6620\u5728\u4f30\u503c\u4e2d\uff08\u519b\u5de5\u7535\u5b50\u677f\u5757 PEG \u4f4e\u4e8e 1\uff09\u3002  \n\n---\n\n## 5. \u64cd\u4f5c\u5efa\u8bae  \n\n### 5.1 \u6218\u672f\u914d\u7f6e  \n- Q2-Q3\uff1a\u8d85\u914d **\u79d1\u521b\u677f 50**\uff08\u4f30\u503c\u6d88\u5316\u5145\u5206 + \u786c\u79d1\u6280\u5360\u6bd4 80%\uff09  \n- Q4\uff1a\u5207\u6362\u81f3 **\u6d88\u8d39 + \u533b\u836f**\uff08\u6625\u8282\u5907\u8d27\u884c\u60c5 + \u96c6\u91c7\u653f\u7b56\u7f13\u548c\uff09  \n\n### 5.2 \u98ce\u9669\u5bf9\u51b2\u5de5\u5177  \n- \u4f7f\u7528 **300ETF \u671f\u6743** \u5bf9\u51b2\u5c3e\u90e8\u98ce\u9669\uff08IV \u5904\u4e8e\u5386\u53f2 30% \u5206\u4f4d\uff09  \n- \u914d\u7f6e **\u9ec4\u91d1 ETF\uff08518880.SH\uff09** \u6bd4\u4f8b\u63d0\u5347\u81f3\u7ec4\u5408\u7684 5%  \n\n> **\u4e13\u5bb6\u6d1e\u89c1**\uff1a2025 \u5e74\u9700\u8b66\u60d5 \"\u949d\u5200\u5272\u8089\" \u5f0f\u8c03\u6574\u2014\u2014\u5f53\u7f8e\u8054\u50a8\u91cd\u542f\u52a0\u606f\u65f6\uff0c\u9ad8\u4f30\u503c\u6210\u957f\u80a1\u53ef\u80fd\u9762\u4e34\u957f\u8fbe 6-9 \u4e2a\u6708\u7684\u9634\u8dcc\u3002\u5efa\u8bae\u52a8\u6001\u8c03\u6574\u6b62\u76c8\u6b62\u635f\u7ebf\uff08\u4f8b\u5982\u6d6e\u76c8\u56de\u64a4 15% \u5373\u51cf\u4ed3\uff09\u3002";
        MarkDownUtils.getFile((String)mdText2, (String)"\u8c03\u7528\u62a5\u544a");
        MarkDownUtils.dealWord((String)"\u8c03\u7528\u62a5\u544a.docx");
        try {
            PPTUtils.coverWordByLibreOffice((String)"\u8c03\u7528\u62a5\u544a.docx");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void dealText(XWPFParagraph paragraph, String linkText, String url) {
        ((XWPFRun)paragraph.getRuns().get(0)).getCTR().addNewDrawing().addNewInline();
        String id = paragraph.getDocument().getPackagePart().addExternalRelationship(url, XWPFRelation.HYPERLINK.getRelation()).getId();
        CTHyperlink cLink = paragraph.getCTP().addNewHyperlink();
        cLink.setId(id);
        CTText ctText = CTText.Factory.newInstance();
        ctText.setStringValue(linkText);
        CTR ctr = CTR.Factory.newInstance();
        CTRPr rpr = ctr.addNewRPr();
        CTColor color = CTColor.Factory.newInstance();
        color.setVal((Object)"605CE5");
        rpr.setColor(color);
        rpr.addNewU().setVal(STUnderline.SINGLE);
        CTFonts fonts = rpr.isSetRFonts() ? rpr.getRFonts() : rpr.addNewRFonts();
        fonts.setAscii("\u82f9\u65b9-\u7b80");
        fonts.setEastAsia("\u82f9\u65b9-\u7b80");
        fonts.setHAnsi("\u82f9\u65b9-\u7b80");
        ctr.setTArray(new CTText[]{ctText});
        cLink.setRArray(new CTR[]{ctr});
    }
}

