/*
 * Decompiled with CFR 0.152.
 */
package com.youbenzi.md2.export;

import com.youbenzi.md2.export.Decorator;
import com.youbenzi.md2.export.DocxDecorator;
import com.youbenzi.md2.markdown.Block;
import com.youbenzi.md2.markdown.BlockType;
import com.youbenzi.md2.markdown.ValuePart;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.util.Units;
import org.apache.poi.xwpf.usermodel.Borders;
import org.apache.poi.xwpf.usermodel.ParagraphAlignment;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRelation;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFStyle;
import org.apache.poi.xwpf.usermodel.XWPFStyles;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTColor;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDecimalNumber;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTFonts;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHeight;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHyperlink;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTOnOff;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTR;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTShd;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTString;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTStyle;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTcPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTText;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTrPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTVerticalJc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STShd;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STStyleType;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STUnderline;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STVerticalJc;

/*
 * Exception performing whole class analysis ignored.
 */
public class DocxDecorator
implements Decorator {
    private XWPFDocument doc;
    private int maxWidth = 400;

    public DocxDecorator(XWPFDocument doc) {
        this.doc = doc;
    }

    public void beginWork(String outputFilePath) {
    }

    public void decorate(List<Block> list) {
        block8: for (Block block : list) {
            XWPFParagraph paragraph = null;
            if (block.getType() != BlockType.TABLE) {
                paragraph = this.doc.createParagraph();
                paragraph.setAlignment(ParagraphAlignment.LEFT);
            }
            switch (2.$SwitchMap$com$youbenzi$md2$markdown$BlockType[block.getType().ordinal()]) {
                case 1: {
                    this.codeParagraph(paragraph, block.getValueParts());
                    continue block8;
                }
                case 2: {
                    this.headerParagraph(paragraph, block.getValueParts(), block.getLevel());
                    continue block8;
                }
                case 3: {
                    this.quoteParagraph(block.getListData());
                    continue block8;
                }
                case 4: {
                    this.tableParagraph(block.getTableData());
                    continue block8;
                }
                case 5: {
                    this.listParagraph(block.getListData(), true);
                    continue block8;
                }
                case 6: {
                    this.listParagraph(block.getListData(), false);
                    continue block8;
                }
            }
            this.commonTextParagraph(paragraph, block.getValueParts());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterWork(String outputFilePath) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(outputFilePath);
            this.doc.write((OutputStream)out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void listParagraph(List<Block> listData, boolean isOrder) {
        int j = 1;
        for (Block block : listData) {
            if (DocxDecorator.isInteger((String)block.getOriginalListNo())) {
                j = Integer.parseInt(block.getOriginalListNo());
            }
            XWPFParagraph paragraph = this.doc.createParagraph();
            paragraph.setAlignment(ParagraphAlignment.LEFT);
            ValuePart[] vps = block.getValueParts();
            ValuePart[] newVps = new ValuePart[vps.length + 1];
            newVps[0] = isOrder ? new ValuePart(j + ". ") : new ValuePart("\u2022 ");
            for (int i = 1; i < newVps.length; ++i) {
                newVps[i] = vps[i - 1];
            }
            this.commonTextParagraph(paragraph, newVps);
            ++j;
        }
    }

    private void tableParagraph(List<List<String>> tableData) {
        int nRows = tableData.size();
        int nCols = tableData.get(0).size();
        long tdW = 9000 / nCols < 1000 ? 1000L : (long)(9000 / nCols);
        XWPFTable table = this.doc.createTable(nRows, nCols);
        List rows = table.getRows();
        int rowCt = 0;
        int colCt = 0;
        for (XWPFTableRow row : rows) {
            CTTrPr trPr = row.getCtRow().addNewTrPr();
            CTHeight ht = trPr.addNewTrHeight();
            ht.setVal(BigInteger.valueOf(360L));
            List cells = row.getTableCells();
            for (XWPFTableCell cell : cells) {
                CTTcPr tcpr = cell.getCTTc().addNewTcPr();
                tcpr.addNewTcW().setW(BigInteger.valueOf(tdW));
                CTVerticalJc va = tcpr.addNewVAlign();
                va.setVal(STVerticalJc.CENTER);
                CTShd ctshd = tcpr.addNewShd();
                ctshd.setColor((Object)"auto");
                ctshd.setVal(STShd.CLEAR);
                XWPFParagraph para = (XWPFParagraph)cell.getParagraphs().get(0);
                para.setAlignment(ParagraphAlignment.LEFT);
                XWPFRun rh = para.createRun();
                try {
                    String regex;
                    Pattern pattern;
                    Matcher matcher;
                    String text = tableData.get(rowCt).get(colCt);
                    if (text.contains("**") && (matcher = (pattern = Pattern.compile(regex = "\\*\\*(?!(\\*\\*)$).+?\\*\\*")).matcher(text)).find()) {
                        text = text.replace("**", "");
                        rh.setBold(true);
                    }
                    rh.setText(text);
                }
                catch (Exception e) {
                    rh.setText("");
                }
                if (rowCt == 0) {
                    rh.setBold(true);
                    rh.setFontFamily("\u9ed1\u4f53");
                } else {
                    rh.setFontFamily("\u82f9\u65b9-\u7b80");
                }
                rh.setFontSize(12);
                ++colCt;
            }
            colCt = 0;
            ++rowCt;
        }
    }

    private void codeParagraph(XWPFParagraph p, ValuePart[] valueParts) {
        if (p == null) {
            return;
        }
        p.setBorderTop(Borders.BASIC_THIN_LINES);
        p.setBorderBottom(Borders.BASIC_THIN_LINES);
        p.setBorderLeft(Borders.BASIC_THIN_LINES);
        p.setBorderRight(Borders.BASIC_THIN_LINES);
        String value = valueParts[0].getValue();
        String[] vals = value.split("\n");
        int l = vals.length;
        for (int i = 0; i < l; ++i) {
            String val = vals[i];
            XWPFRun r = p.createRun();
            r.setBold(false);
            r.setText(val);
            r.setFontFamily("Courier");
            if (i + 1 >= l) continue;
            r.addBreak();
        }
    }

    private void headerParagraph(XWPFParagraph p, ValuePart[] valueParts, int levle) {
        if (p == null) {
            return;
        }
        for (ValuePart valuePart : valueParts) {
            XWPFRun r = p.createRun();
            BlockType[] types = valuePart.getTypes();
            if (types != null) {
                for (BlockType type : types) {
                    this.formatByType(r, type, valuePart.getLevel());
                }
            }
            r.setText(valuePart.getValue());
            DocxDecorator.addCustomHeadingStyle((XWPFDocument)p.getDocument(), (String)"\u6807\u9898 1", (int)1);
            if (levle == 0) {
                DocxDecorator.addCustomHeadingStyle((XWPFDocument)p.getDocument(), (String)"\u6807\u9898 2", (int)2);
                p.setStyle("\u6807\u9898 2");
                r.setBold(true);
                r.setColor("1D1C33");
                r.setFontFamily("\u9ed1\u4f53");
                r.setFontSize(18);
                continue;
            }
            if (levle == 1) {
                DocxDecorator.addCustomHeadingStyle((XWPFDocument)p.getDocument(), (String)"\u6807\u9898 3", (int)3);
                p.setStyle("\u6807\u9898 3");
                r.setBold(true);
                r.setColor("1D1C33");
                r.setFontFamily("\u9ed1\u4f53");
                r.setFontSize(16);
                continue;
            }
            if (levle == 2) {
                DocxDecorator.addCustomHeadingStyle((XWPFDocument)p.getDocument(), (String)"\u6807\u9898 4", (int)4);
                p.setStyle("\u6807\u9898 4");
                r.setBold(true);
                r.setColor("1D1C33");
                r.setFontFamily("\u9ed1\u4f53");
                r.setFontSize(14);
                continue;
            }
            r.setFontSize(12);
            r.setColor("1D1C33");
            r.setFontFamily("\u82f9\u65b9-\u7b80");
            r.setStyle("\u6b63\u6587");
            r.setFontSize(30 - 4 * levle);
        }
    }

    private static void addCustomHeadingStyle(XWPFDocument docxDocument, String strStyleId, int headingLevel) {
        CTStyle ctStyle = CTStyle.Factory.newInstance();
        ctStyle.setStyleId(strStyleId);
        CTString styleName = CTString.Factory.newInstance();
        styleName.setVal(strStyleId);
        ctStyle.setName(styleName);
        CTDecimalNumber indentNumber = CTDecimalNumber.Factory.newInstance();
        indentNumber.setVal(BigInteger.valueOf(headingLevel));
        ctStyle.setUiPriority(indentNumber);
        CTOnOff onoffnull = CTOnOff.Factory.newInstance();
        ctStyle.setUnhideWhenUsed(onoffnull);
        ctStyle.setQFormat(onoffnull);
        CTPPr ppr = CTPPr.Factory.newInstance();
        ppr.setOutlineLvl(indentNumber);
        ctStyle.setPPr(ppr);
        XWPFStyle style = new XWPFStyle(ctStyle);
        XWPFStyles styles = docxDocument.createStyles();
        style.setType(STStyleType.PARAGRAPH);
        styles.addStyle(style);
    }

    private void quoteParagraph(List<Block> listData) {
        boolean isFirst = true;
        for (int i = 0; i < listData.size(); ++i) {
            Block block = listData.get(i);
            if (i > 0) {
                isFirst = false;
            }
            XWPFParagraph paragraph = this.doc.createParagraph();
            paragraph.setAlignment(ParagraphAlignment.LEFT);
            this.quoteParagraph(paragraph, block.getValueParts(), isFirst);
        }
    }

    private void quoteParagraph(XWPFParagraph p, ValuePart[] valueParts, boolean isFirst) {
        if (isFirst) {
            XWPFRun r1 = p.createRun();
            try {
                r1.addPicture(DocxDecorator.class.getResourceAsStream("/quote_char.jpg"), 5, "", Units.toEMU((double)20.0), Units.toEMU((double)14.0));
            }
            catch (InvalidFormatException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        for (ValuePart valuePart : valueParts) {
            if (!isFirst) {
                XWPFRun rh1 = p.createRun();
                rh1.setText("    ");
                rh1.setFontSize(22);
            }
            XWPFRun rh2 = p.createRun();
            BlockType[] types = valuePart.getTypes();
            if (types != null) {
                for (BlockType type : types) {
                    this.formatByType(rh2, type, valuePart.getLevel());
                }
            }
            if (rh2.getFontSize() == -1) {
                rh2.setFontSize(10);
            }
            rh2.setText(valuePart.getValue());
        }
    }

    private void imgParagraph(XWPFParagraph p, ValuePart valuePart) {
        String imgFile = valuePart.getValue();
        1 helper = new /* Unavailable Anonymous Inner Class!! */;
        helper.setImgByUrl(imgFile);
    }

    private void commonTextParagraph(XWPFParagraph p, ValuePart[] valueParts) {
        if (p == null) {
            return;
        }
        for (ValuePart valuePart : valueParts) {
            XWPFRun r = p.createRun();
            BlockType[] types = valuePart.getTypes();
            boolean hasImg = false;
            boolean hasLink = false;
            if (types != null) {
                for (BlockType type : types) {
                    if (type == BlockType.IMG) {
                        hasImg = true;
                        break;
                    }
                    if (type == BlockType.LINK) {
                        hasLink = true;
                        break;
                    }
                    this.formatByType(r, type, valuePart.getLevel());
                }
            }
            if (hasImg) {
                this.imgParagraph(p, valuePart);
                continue;
            }
            if (hasLink) {
                this.linkParagraph(p, valuePart);
                continue;
            }
            r.setFontSize(12);
            r.setColor("1D1C33");
            r.setFontFamily("\u82f9\u65b9-\u7b80");
            r.setStyle("\u6b63\u6587");
            r.setText(valuePart.getValue());
        }
    }

    private void linkParagraph(XWPFParagraph p, ValuePart valuePart) {
        DocxDecorator.dealText((XWPFParagraph)p, (String)valuePart.getTitle(), (String)valuePart.getUrl());
    }

    public static void dealText(XWPFParagraph paragraph, String linkText, String url) {
        ((XWPFRun)paragraph.getRuns().get(0)).getCTR().addNewDrawing().addNewInline();
        String id = paragraph.getDocument().getPackagePart().addExternalRelationship(url, XWPFRelation.HYPERLINK.getRelation()).getId();
        CTHyperlink cLink = paragraph.getCTP().addNewHyperlink();
        cLink.setId(id);
        CTText ctText = CTText.Factory.newInstance();
        ctText.setStringValue(linkText);
        CTR ctr = CTR.Factory.newInstance();
        CTRPr rpr = ctr.addNewRPr();
        CTColor color = CTColor.Factory.newInstance();
        color.setVal((Object)"605CE5");
        rpr.setColor(color);
        rpr.addNewU().setVal(STUnderline.SINGLE);
        CTFonts fonts = rpr.isSetRFonts() ? rpr.getRFonts() : rpr.addNewRFonts();
        fonts.setAscii("\u82f9\u65b9-\u7b80");
        fonts.setEastAsia("\u82f9\u65b9-\u7b80");
        fonts.setHAnsi("\u82f9\u65b9-\u7b80");
        ctr.setTArray(new CTText[]{ctText});
        cLink.setRArray(new CTR[]{ctr});
    }

    private int typeOfImg(String imgFile) {
        int format = 5;
        if (imgFile.endsWith(".emf")) {
            format = 2;
        } else if (imgFile.endsWith(".wmf")) {
            format = 3;
        } else if (imgFile.endsWith(".pict")) {
            format = 4;
        } else if (imgFile.endsWith(".jpeg") || imgFile.endsWith(".jpg")) {
            format = 5;
        } else if (imgFile.endsWith(".png")) {
            format = 6;
        } else if (imgFile.endsWith(".dib")) {
            format = 7;
        } else if (imgFile.endsWith(".gif")) {
            format = 8;
        } else if (imgFile.endsWith(".tiff")) {
            format = 9;
        } else if (imgFile.endsWith(".eps")) {
            format = 10;
        } else if (imgFile.endsWith(".bmp")) {
            format = 11;
        } else if (imgFile.endsWith(".wpg")) {
            format = 12;
        } else {
            System.out.println("Unsupported picture: " + imgFile + ". Expected emf|wmf|pict|jpeg|png|dib|gif|tiff|eps|bmp|wpg");
        }
        return format;
    }

    private int[] computeWidthHeight2Show(int[] ia) {
        if (ia == null || ia.length < 2) {
            return new int[]{100, 100};
        }
        int w = ia[0];
        int h = ia[1];
        if (w > this.maxWidth) {
            double d = (double)w / (double)this.maxWidth;
            h = (int)((double)h / d);
            w = this.maxWidth;
        }
        return new int[]{w, h};
    }

    private void closeStream(ByteArrayOutputStream baos, InputStream imgIs) {
        if (baos != null) {
            try {
                baos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (imgIs != null) {
            try {
                imgIs.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void formatByType(XWPFRun r, BlockType type, int level) {
        switch (2.$SwitchMap$com$youbenzi$md2$markdown$BlockType[type.ordinal()]) {
            case 7: {
                r.setBold(true);
                break;
            }
            case 8: {
                r.setItalic(true);
                break;
            }
            case 9: {
                r.setStrike(true);
                break;
            }
            case 10: {
                r.setColor("dd1144");
                break;
            }
            case 2: {
                r.setFontSize(30 - level * 4);
                break;
            }
        }
    }

    public static boolean isInteger(String str) {
        if (str == null || str.trim().isEmpty()) {
            return false;
        }
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    static /* synthetic */ int[] access$000(DocxDecorator x0, int[] x1) {
        return x0.computeWidthHeight2Show(x1);
    }

    static /* synthetic */ int access$100(DocxDecorator x0, String x1) {
        return x0.typeOfImg(x1);
    }

    static /* synthetic */ void access$200(DocxDecorator x0, ByteArrayOutputStream x1, InputStream x2) {
        x0.closeStream(x1, x2);
    }
}

