/*
 * Decompiled with CFR 0.152.
 */
package com.youbenzi.md2.export;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Image;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfAction;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import com.youbenzi.md2.export.Decorator;
import com.youbenzi.md2.export.PDFDecorator5x;
import com.youbenzi.md2.markdown.Block;
import com.youbenzi.md2.markdown.BlockType;
import com.youbenzi.md2.markdown.ValuePart;
import com.youbenzi.md2.util.MD2FileUtil;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class PDFDecorator5x
implements Decorator {
    private static final Logger log = LoggerFactory.getLogger(PDFDecorator5x.class);
    private Document doc;
    private static BaseFont bfChinese;
    Font fontYHNormal = new Font(bfChinese, 12.0f, 0);

    public PDFDecorator5x(Document doc) {
        this.doc = doc;
    }

    public void beginWork(String outputFilePath) {
        try {
            PdfWriter.getInstance((Document)this.doc, (OutputStream)new FileOutputStream(outputFilePath));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        this.doc.open();
    }

    public void decorate(List<Block> list) {
        block10: for (Block block : list) {
            try {
                switch (2.$SwitchMap$com$youbenzi$md2$markdown$BlockType[block.getType().ordinal()]) {
                    case 1: {
                        this.doc.add(this.codeParagraph(block.getValueParts()));
                        break;
                    }
                    case 2: {
                        this.doc.add(this.headerParagraph(block.getValueParts(), block.getLevel()));
                        break;
                    }
                    case 3: {
                        List quotes = this.quoteParagraph(block.getListData());
                        for (Element element : quotes) {
                            this.doc.add(element);
                        }
                        continue block10;
                    }
                    case 4: {
                        this.doc.add(this.tableParagraph(block.getTableData()));
                        break;
                    }
                    case 5: {
                        List els = this.listParagraph(block.getListData(), true);
                        for (Element element : els) {
                            this.doc.add(element);
                        }
                        continue block10;
                    }
                    case 6: {
                        List els = this.listParagraph(block.getListData(), false);
                        for (Element element : els) {
                            this.doc.add(element);
                        }
                        continue block10;
                    }
                    default: {
                        this.doc.add((Element)this.commonTextParagraph(block.getValueParts()));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void afterWork(String outputFilePath) {
        this.doc.close();
    }

    private List<Element> listParagraph(List<Block> listData, boolean isOrder) {
        ArrayList<Element> list = new ArrayList<Element>();
        int j = 1;
        for (Block block : listData) {
            if (PDFDecorator5x.isInteger((String)block.getOriginalListNo())) {
                j = Integer.parseInt(block.getOriginalListNo());
            }
            ValuePart[] vps = block.getValueParts();
            ValuePart[] newVps = new ValuePart[vps.length + 1];
            newVps[0] = isOrder ? new ValuePart(j + ". ") : new ValuePart("\u2022 ");
            for (int i = 1; i < newVps.length; ++i) {
                newVps[i] = vps[i - 1];
            }
            list.add((Element)this.commonTextParagraph(newVps));
            ++j;
        }
        return list;
    }

    public static boolean isInteger(String str) {
        if (str == null || str.trim().isEmpty()) {
            return false;
        }
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private Element headerParagraph(ValuePart[] valueParts, int level) {
        Paragraph paragraph = new Paragraph();
        for (ValuePart valuePart : valueParts) {
            BlockType[] types = valuePart.getTypes();
            float fontSize = level == 0 ? 18.0f : (level == 1 ? 16.0f : (level == 2 ? 14.0f : 30.0f - (float)(4 * level)));
            Font font = new Font(bfChinese, fontSize);
            font.setFamily("Helvetica");
            font.setStyle(1);
            if (types != null) {
                for (BlockType type : types) {
                    this.formatByType(font, type, valuePart.getLevel());
                }
            }
            Chunk chunk = new Chunk(valuePart.getValue(), font);
            chunk.setLineHeight(30.0f);
            paragraph.add((Element)chunk);
        }
        paragraph.setSpacingBefore(20.0f);
        paragraph.setSpacingAfter(10.0f);
        return paragraph;
    }

    private Element tableParagraph(List<List<String>> tableData) {
        int nRows = tableData.size();
        int nCols = 0;
        for (List<String> list : tableData) {
            int s = list.size();
            if (nCols >= s) continue;
            nCols = s;
        }
        PdfPTable pdfPTable = new PdfPTable(nCols);
        pdfPTable.setWidthPercentage(100.0f);
        Font font = new Font(bfChinese, 12.0f);
        font.setFamily("Helvetica");
        for (int i = 0; i < nRows; ++i) {
            List<String> colDatas = tableData.get(i);
            for (int j = 0; j < nCols; ++j) {
                PdfPCell cell = new PdfPCell();
                if (i == 0) {
                    cell.setBackgroundColor(BaseColor.LIGHT_GRAY);
                    font.setStyle(1);
                }
                cell.setPaddingBottom(12.0f);
                cell.setPaddingLeft(12.0f);
                cell.setPaddingRight(12.0f);
                try {
                    String text = colDatas.get(j);
                    if (text.contains("**")) {
                        String regex = "\\*\\*(?!(\\*\\*)$).+?\\*\\*";
                        Pattern pattern = Pattern.compile(regex);
                        Matcher matcher = pattern.matcher(text);
                        if (matcher.find()) {
                            text = text.replace("**", "");
                            font.setStyle(1);
                        }
                    } else {
                        font.setStyle(-1);
                    }
                    cell.addElement((Element)new Chunk(text, font));
                }
                catch (Exception e) {
                    cell.addElement((Element)new Chunk("", font));
                }
                pdfPTable.addCell(cell);
            }
        }
        pdfPTable.setSpacingAfter(5.0f);
        return pdfPTable;
    }

    private Element imgParagraph(ValuePart valuePart) {
        PdfPTable pdfPTable = new PdfPTable(1);
        PdfPCell cell = new PdfPCell();
        String imgFile = valuePart.getValue();
        1 helper = new /* Unavailable Anonymous Inner Class!! */;
        InputStream result = helper.setImgByUrl(imgFile);
        if (result == null) {
            ValuePart part = new ValuePart("\u56fe\u7247\u5730\u5740\uff1a" + imgFile);
            return this.commonTextParagraph(new ValuePart[]{part});
        }
        pdfPTable.setHorizontalAlignment(0);
        pdfPTable.addCell(cell);
        pdfPTable.setSpacingAfter(5.0f);
        return pdfPTable;
    }

    private Element codeParagraph(ValuePart[] valueParts) throws DocumentException {
        String value = valueParts[0].getValue();
        Paragraph p = new Paragraph(value, new Font(bfChinese, 12.0f));
        PdfPTable pdfPTable = new PdfPTable(1);
        pdfPTable.setWidthPercentage(100.0f);
        PdfPCell cell = new PdfPCell();
        cell.addElement((Element)p);
        cell.setBorder(15);
        cell.setPaddingBottom(12.0f);
        cell.setPaddingLeft(12.0f);
        cell.setPaddingRight(12.0f);
        cell.setBackgroundColor(BaseColor.LIGHT_GRAY);
        pdfPTable.addCell(cell);
        pdfPTable.setSpacingAfter(5.0f);
        return pdfPTable;
    }

    private List<Element> quoteParagraph(List<Block> listData) {
        boolean isFirst = true;
        ArrayList<Element> results = new ArrayList<Element>();
        for (int i = 0; i < listData.size(); ++i) {
            Block block = listData.get(i);
            if (i > 0) {
                isFirst = false;
            }
            Element element = this.quoteParagraph(block.getValueParts(), isFirst);
            results.add(element);
        }
        return results;
    }

    private Element quoteParagraph(ValuePart[] valueParts, boolean isFirst) {
        Paragraph p = new Paragraph();
        for (ValuePart valuePart : valueParts) {
            BlockType[] types = valuePart.getTypes();
            Font font = new Font(bfChinese);
            if (types != null) {
                for (BlockType type : types) {
                    this.formatByType(font, type, valuePart.getLevel());
                }
            }
            Chunk chunk = new Chunk(valuePart.getValue(), font);
            p.add((Element)chunk);
        }
        PdfPTable pdfPTable = new PdfPTable(2);
        try {
            PdfPCell cell;
            pdfPTable.setWidthPercentage(100.0f);
            pdfPTable.setWidths(new int[]{1, 20});
            try {
                cell = new PdfPCell();
                if (isFirst) {
                    InputStream is = PDFDecorator5x.class.getResourceAsStream("/quote_char.jpg");
                    Image image = Image.getInstance((byte[])MD2FileUtil.inputStream2ByteArrayOutputStream((InputStream)is).toByteArray());
                    cell.addElement((Element)image);
                } else {
                    cell.addElement((Element)new Chunk());
                }
                cell.setBorder(0);
                pdfPTable.addCell(cell);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            cell = new PdfPCell();
            cell.addElement((Element)p);
            cell.setBorder(0);
            if (isFirst) {
                cell.setPaddingTop(10.0f);
            }
            cell.setPaddingBottom(5.0f);
            pdfPTable.addCell(cell);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pdfPTable;
    }

    private Paragraph commonTextParagraph(ValuePart[] valueParts) {
        Paragraph p = new Paragraph();
        if (valueParts == null) {
            return p;
        }
        for (ValuePart valuePart : valueParts) {
            BlockType[] types = valuePart.getTypes();
            Font font = null;
            if (font == null) {
                font = new Font(bfChinese, 12.0f);
                font.setFamily("Helvetica");
            }
            boolean hasImg = false;
            boolean hasLink = false;
            if (types != null) {
                for (BlockType type : types) {
                    if (type == BlockType.IMG) {
                        hasImg = true;
                        break;
                    }
                    if (type == BlockType.LINK) {
                        hasLink = true;
                        break;
                    }
                    this.formatByType(font, type, valuePart.getLevel());
                }
            }
            if (hasImg) {
                p.add(this.imgParagraph(valuePart));
                continue;
            }
            if (hasLink) {
                p.add(this.linkParagraph(valuePart, font));
                continue;
            }
            Chunk chunk = new Chunk(valuePart.getValue(), font);
            p.add((Element)chunk);
        }
        p.setSpacingAfter(5.0f);
        return p;
    }

    private Element linkParagraph(ValuePart valuePart, Font font) {
        font.setColor(96, 92, 229);
        Chunk linkChunk = new Chunk(valuePart.getTitle(), font);
        linkChunk.setAction(new PdfAction(valuePart.getUrl()));
        return linkChunk;
    }

    private void formatByType(Font font, BlockType type, int level) {
        switch (2.$SwitchMap$com$youbenzi$md2$markdown$BlockType[type.ordinal()]) {
            case 7: {
                font.setStyle(1);
                break;
            }
            case 8: {
                font.setStyle(2);
                break;
            }
            case 9: {
                font.setStyle(8);
                break;
            }
            case 10: {
                font.setColor(BaseColor.RED);
                break;
            }
            case 2: {
                font.setSize(16.0f);
                font.setStyle(1);
                break;
            }
        }
    }

    static {
        try {
            String ttfPath = "/usr/local/fileparsing/Fonts/PingFang-SC.ttf";
            bfChinese = BaseFont.createFont((String)ttfPath, (String)"Identity-H", (boolean)true);
        }
        catch (Exception e) {
            System.out.println("\u6ca1\u6709\u627e\u5230PingFang-SC.ttf\u5b57\u4f53\u6587\u4ef6\uff0c\u4f7f\u7528\u5fae\u8f6f\u96c5\u9ed1\u663e\u793a");
            try {
                bfChinese = BaseFont.createFont((String)"MSYH.TTF", (String)"Identity-H", (boolean)false);
            }
            catch (Exception e1) {
                try {
                    bfChinese = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                System.out.println("\u6ca1\u6709\u627e\u5230MSYH.TTF\u5b57\u4f53\u6587\u4ef6\uff0c\u4f7f\u7528itext\u81ea\u5e26\u4e2d\u6587\u5b57\u4f53\u3002\u5982\u679c\u9700\u8981\u66f4\u597d\u7684\u663e\u793a\u6548\u679c\uff0c\u53ef\u4ee5\u6dfb\u52a0MSYH.TTF\u5230src\u76ee\u5f55\u4e0b");
            }
        }
    }
}

