/*
 * Decompiled with CFR 0.152.
 */
package com.youbenzi.md2.markdown;

import com.youbenzi.md2.markdown.BlockType;
import java.util.Map;

public class MDToken {
    public static String QUOTE = ">";
    public static String CODE = "```";
    public static String CODE_BLANK = "    ";
    public static String HEADLINE = "#";
    public static String IMG = "![";
    public static String LINK = "[";
    public static String LINK_2 = "[[";
    public static String UNORDERED_LIST1 = "* ";
    public static String UNORDERED_LIST2 = "- ";
    public static String BOLD_WORD = "**";
    public static String ITALIC_WORD = "_";
    public static String ITALIC_WORD_2 = "*";
    public static String STRIKE_WORD = "~~";
    public static String CODE_WORD = "`";
    public static Map<String, String> PLACEHOLDER_MAP = new /* Unavailable Anonymous Inner Class!! */;

    public static BlockType convert(String mdToken) {
        if (mdToken.equals(QUOTE)) {
            return BlockType.QUOTE;
        }
        if (mdToken.equals(CODE)) {
            return BlockType.CODE;
        }
        if (mdToken.equals(HEADLINE)) {
            return BlockType.HEADLINE;
        }
        if (mdToken.equals(IMG)) {
            return BlockType.IMG;
        }
        if (mdToken.equals(BOLD_WORD)) {
            return BlockType.BOLD_WORD;
        }
        if (mdToken.equals(ITALIC_WORD) || mdToken.equals(ITALIC_WORD_2)) {
            return BlockType.ITALIC_WORD;
        }
        if (mdToken.equals(STRIKE_WORD)) {
            return BlockType.STRIKE_WORD;
        }
        if (mdToken.equals(CODE_WORD)) {
            return BlockType.CODE_WORD;
        }
        if (mdToken.equals(LINK) || mdToken.equals(LINK_2)) {
            return BlockType.LINK;
        }
        return BlockType.NONE;
    }
}

