/*
 * Decompiled with CFR 0.152.
 */
package com.youbenzi.md2.markdown.builder;

import com.youbenzi.md2.markdown.Block;
import com.youbenzi.md2.markdown.BlockType;
import com.youbenzi.md2.markdown.MDAnalyzer;
import com.youbenzi.md2.markdown.MDToken;
import com.youbenzi.md2.markdown.ValuePart;
import com.youbenzi.md2.markdown.builder.BlockBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

public abstract class ListBuilder
implements BlockBuilder {
    private String content;
    private BlockType blockType;

    public ListBuilder(String content, BlockType blockType) {
        this.content = content;
        this.blockType = blockType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Block bulid() {
        Block result = new Block();
        BufferedReader br = new BufferedReader(new StringReader(this.content));
        try {
            String value = br.readLine();
            ArrayList<Block> listData = new ArrayList<Block>();
            while (value != null) {
                int index = this.computeCharIndex(value = value.trim());
                if (index < 0) {
                    value = br.readLine();
                    continue;
                }
                String originalValue = index > 1 ? value.substring(0, index - 1) : value.substring(index);
                if ((value = value.substring(index + 1).trim()).equals("")) {
                    value = br.readLine();
                    continue;
                }
                int i = 0;
                if (value.startsWith(MDToken.HEADLINE)) {
                    i = value.lastIndexOf(MDToken.HEADLINE);
                }
                if (i > 0) {
                    value = value.substring(i + 1).trim();
                }
                List list = MDAnalyzer.analyzeTextLine((String)value);
                if (i > 0) {
                    for (ValuePart valuePart : list) {
                        valuePart.addType(BlockType.HEADLINE);
                        valuePart.setLevel(i);
                    }
                }
                Block block = new Block();
                block.setType(this.blockType);
                block.setValueParts(list);
                block.setOriginalListNo(originalValue);
                listData.add(block);
                value = br.readLine();
            }
            result.setType(this.blockType);
            result.setListData(listData);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                br.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public boolean isRightType() {
        return false;
    }

    public abstract int computeCharIndex(String var1);
}

