package com.digiwin.athena.base.sdk.aam.infrastructure.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.digiwin.athena.base.sdk.aam.infrastructure.meta.po.AttachmentEntity;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public interface QueryAttachmentMapper extends BaseMapper<AttachmentEntity> {
    /**
     * 根据活动id、租户id和行数据标识列表查询
     *
     * @param tenantId       租户id
     * @param taskId         tmActivityId
     * @param projectId      projectId
     * @param categories     附件目录列表
     * @param rowDataKeyList 行数据标识列表
     * @return 附件信息
     */
    List<AttachmentEntity> queryByTaskIdAndRowDataKeyList(@Param("tenantId") String tenantId,
                                                          @Param("taskId") String taskId,
                                                          @Param("projectId") String projectId,
                                                          @Param("categories") List<String> categories,
                                                          @Param("rowDataKeyList") List<String> rowDataKeyList);

}
