package com.digiwin.athena.base.sdk.audc.application.service.watermark;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.base.sdk.audc.application.meta.response.watermark.WaterMarkConfigVO;
import com.digiwin.athena.base.sdk.audc.application.meta.converter.AudcSdkConverter;
import com.digiwin.athena.iam.sdk.manager.IamManager;
import com.digiwin.athena.iam.sdk.meta.dto.response.UserTypeRespDTO;
import com.digiwin.athena.tdd.sdk.manager.TddManager;
import com.digiwin.athena.tdd.sdk.meta.dto.request.WaterMarkConfigReqDTO;
import com.digiwin.athena.tdd.sdk.meta.dto.response.WaterMarkConfigRespDTO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * @author mk
 * @date 2024/10/31 18:04
 * @description:
 */
@Slf4j
@Service
public class QueryWatermarkConfigServiceImpl implements QueryWatermarkConfigService {
    @Override
    public WaterMarkConfigVO getWaterMarkConfig(WaterMarkConfigReqDTO waterMarkConfigReqDTO) {
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        AuthoredUser proxyAuthoredUser = AppAuthContextHolder.getContext().getProxyAuthoredUser();
        String token = Objects.nonNull(proxyAuthoredUser) ? proxyAuthoredUser.getToken() : authoredUser.getToken();

        //获取水印配置
        WaterMarkConfigRespDTO waterMarkConfigResp = TddManager.getWaterMarkConfig(waterMarkConfigReqDTO, token).getResponse();
        if (Objects.isNull(waterMarkConfigResp)) {
            return null;
        }

        WaterMarkConfigVO waterMarkConfigVO = AudcSdkConverter.INTENSIVE.toWaterMarkConfigVO(waterMarkConfigResp);
        //获取用户类型
        UserTypeRespDTO userTypeRespDTO = IamManager.queryPersonalizedInfo(authoredUser.getUserId(), token);
        if (null != userTypeRespDTO) {
            waterMarkConfigVO.setUserType(userTypeRespDTO.getUserType());
        }
        return waterMarkConfigVO;
    }
}
