package com.digiwin.athena.base.sdk.audc.application.meta.response.watermark;

import lombok.Data;

/**
 * @author mk
 * @date 2024/10/19 15:48
 * @description:水印出参类
 */
@Data
public class WaterMarkConfigVO {

    /**
     * 应用 code
     */
    private String appCode;

    /**
     * 分类 code
     */
    private String pattern;

    /**
     * 基础资料/报表/项目/任务 code
     */
    private String activityCode;

    /**
     * 生效范围
     */
    private Scope scope;

    /**
     * 水印规则
     */
    private Rule rule;


    /**
     * 使用场景
     */
    private Scene scene;

    /**
     * 启停用状态, 0: 停用，1: 启用
     */
    private Integer status;

    /**
     * 用户类型：0-用户，1-外部用户
     */
    private Integer userType;

    @Data
    public static class Scope{
        /**
         * 内部员工
         */
        private Boolean internalEmployee;

        /**
         * 外部员工
         */
        private Boolean externalEmployee;
    }

    @Data
    public static class Rule{
        /**
         * 用户名
         */
        private Boolean username;

        /**
         * 租户名
         */
        private Boolean tenantName;

        /**
         * 文本
         */
        private Boolean text;

        /**
         * 文本内容
         */
        private String textContext;

        /**
         * 时间
         */
        private Boolean time;

        /**
         * 时间内容
         * 0：年-月-日
         * 1：年-月-日 时:分:秒
         */
        private Integer timeContext;
    }

    @Data
    public static class Scene{
        /**
         * 页面
         */
        private Boolean page;

        /**
         * 附件
         */
        private Boolean attachment;
    }

}
