package com.digiwin.athena.base.sdk.audc.application.service.principal;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.base.sdk.audc.infrastructure.mapper.QueryPrincipalTaskTypeMapper;
import com.digiwin.athena.base.sdk.audc.infrastructure.meta.po.ThePrincipalTaskType;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service
public class QueryPrincipalTaskTypeServiceImpl implements QueryPrincipalTaskTypeService {
    @Autowired(required = false)
    private QueryPrincipalTaskTypeMapper queryPrincipalTaskTypeMapper;

    protected QueryPrincipalTaskTypeMapper getPrincipalTaskTypeMapper() {
        if (null != queryPrincipalTaskTypeMapper) {
            return queryPrincipalTaskTypeMapper;
        }
        throw BusinessException.create("请检查base数据源配置是否正确~");
    }

    @Override
    public List<ThePrincipalTaskType> queryPrincipalTaskType(String tenantId, List<String> thePrincipalIds, String agentId, String taskDefCode) {
        LambdaQueryWrapper<ThePrincipalTaskType> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.in(ThePrincipalTaskType::getThePrincipalId, thePrincipalIds)
                .eq(StringUtils.isNotEmpty(agentId), ThePrincipalTaskType::getAgentId, agentId)
                .eq(ThePrincipalTaskType::getTenantId, tenantId)
                .eq(StringUtils.isNotEmpty(taskDefCode), ThePrincipalTaskType::getTaskDefCode, taskDefCode)
                .eq(ThePrincipalTaskType::getDeleted, 0);
        List<ThePrincipalTaskType> queryList = getPrincipalTaskTypeMapper().selectList(queryWrapper);

        return CollectionUtils.isNotEmpty(queryList) ? queryList : new ArrayList<>();
    }
}
