/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.sdk.audc.application.config;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.internal.MongoClientImpl;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.DefaultMongoTypeMapper;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.convert.MongoTypeMapper;

@Configuration
public class AudcSDKMongoTemplateConfig {
    @Value(value="${spring.data.mongodb-userdefined.uri:}")
    private String uriUserdefined;
    @Value(value="${spring.data.mongodb-userdefined.database:}")
    private String databaseUserdefined;

    @ConditionalOnProperty(name={"spring.data.mongodb-userdefined.enable"}, havingValue="true")
    @ConditionalOnMissingBean(name={"userdefinedMongoTemplate"})
    @Bean(value={"userdefinedMongoTemplate"})
    public MongoTemplate userdefinedMongoTemplate() {
        MongoClientImpl client = new MongoClientImpl(MongoClientSettings.builder().retryWrites(false).applyConnectionString(new ConnectionString(this.uriUserdefined)).build(), null);
        MongoTemplate msgMongoTemplate = new MongoTemplate((MongoClient)client, this.databaseUserdefined);
        MongoConverter converter = msgMongoTemplate.getConverter();
        if (converter.getTypeMapper().isTypeKey("_class")) {
            ((MappingMongoConverter)converter).setTypeMapper((MongoTypeMapper)new DefaultMongoTypeMapper(null));
        }
        return msgMongoTemplate;
    }
}

