/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.sdk.audc.infrastructure.mongo;

import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.base.sdk.audc.infrastructure.meta.bo.userdefined.mongo.UserDefinedFieldsBO;
import com.digiwin.athena.base.sdk.audc.infrastructure.meta.po.userdefined.mongo.UserDefinedMetadataPO;
import com.digiwin.athena.base.sdk.audc.infrastructure.meta.po.userdefined.mongo.UserDefinedPO;
import com.digiwin.athena.base.sdk.audc.infrastructure.meta.po.userdefined.mongo.UserDefinedTagResponsePO;
import com.digiwin.athena.base.sdk.audc.infrastructure.meta.po.userdefined.mongo.UserGridPO;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class QueryUserDefinedMapper {
    @Autowired(required=false)
    @Qualifier(value="userdefinedMongoTemplate")
    private MongoTemplate userdefinedMongoTemplate;
    protected static String PURPOSE_FIELDSEQBYUSER = "FieldSeqByUser";
    protected static String PURPOSE_SEARCH_CONDITIONS = "SearchConditions";
    protected static String COLLECTION_NAME = "user_defined_center";
    protected static String GRID_COLLECTION_NAME = "user_grid_items";

    public MongoTemplate getUserdefinedMongoTemplate() {
        if (null != this.userdefinedMongoTemplate) {
            return this.userdefinedMongoTemplate;
        }
        throw BusinessException.create((String)"\u8bf7\u68c0\u67e5userDefined\u6570\u636e\u6e90\u914d\u7f6e\u662f\u5426\u6b63\u786e.");
    }

    public UserDefinedPO getFieldSeqList(UserDefinedPO userDefined) {
        List list;
        Query query = this.getQuery(userDefined);
        if (StringUtils.isNotEmpty((String)userDefined.getTableSchema())) {
            query = this.getQueryInTable(userDefined);
        }
        if (CollectionUtils.isNotEmpty((Collection)(list = this.getUserdefinedMongoTemplate().find(query, UserDefinedPO.class, COLLECTION_NAME))) && list.size() > 0) {
            UserDefinedPO userDefinedNew = (UserDefinedPO)list.get(0);
            if (CollectionUtils.isNotEmpty(userDefinedNew.getMetadataTags())) {
                userDefinedNew.getMetadataTags().stream().forEach(tag -> tag.setTableSchema(userDefinedNew.getTableSchema()));
            }
            if (PURPOSE_FIELDSEQBYUSER.equals(userDefined.getPurpose())) {
                if (list.size() > 1) {
                    for (int i = 1; i < list.size(); ++i) {
                        if (CollectionUtils.isNotEmpty(((UserDefinedPO)list.get(i)).getMetadataTags())) {
                            int finalI = i;
                            ((UserDefinedPO)list.get(i)).getMetadataTags().stream().forEach(tag -> tag.setTableSchema(((UserDefinedPO)list.get(finalI)).getTableSchema()));
                        }
                        userDefinedNew.getMetadataTags().addAll(((UserDefinedPO)list.get(i)).getMetadataTags());
                    }
                }
            } else if (StringUtils.isNotEmpty((String)userDefinedNew.getTableSchema())) {
                JSONObject settingWithTable = new JSONObject();
                settingWithTable.put((Object)userDefinedNew.getTableSchema(), (Object)userDefinedNew.getSettings());
                userDefinedNew.setSettings(settingWithTable);
                if (list.size() > 1) {
                    for (int i = 1; i < list.size(); ++i) {
                        UserDefinedPO oneUserDefined = (UserDefinedPO)list.get(i);
                        if (!StringUtils.isNotEmpty((String)oneUserDefined.getTableSchema())) continue;
                        settingWithTable.put((Object)oneUserDefined.getTableSchema(), (Object)oneUserDefined.getSettings());
                    }
                }
            } else if (list.size() > 1) {
                JSONArray options = userDefinedNew.getSettings().getJSONObject("order").getJSONArray("options");
                for (int i = 1; i < list.size(); ++i) {
                    options.addAll((Collection)((UserDefinedPO)list.get(i)).getSettings().getJSONObject("order").getJSONArray("options"));
                }
            }
            return userDefinedNew;
        }
        return new UserDefinedPO();
    }

    protected Query getQuery(UserDefinedPO userDefined) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"purpose").is((Object)userDefined.getPurpose()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"userId").is((Object)userDefined.getUserId()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)userDefined.getTenantId()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"pageCode").is((Object)userDefined.getPageCode()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tmProjectId").is((Object)userDefined.getTmProjectId()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tmActivityId").is((Object)userDefined.getTmActivityId()));
        if (StringUtils.isNotBlank((String)userDefined.getPageUniqueCode())) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"pageUniqueCode").is((Object)userDefined.getPageUniqueCode()));
        }
        return query;
    }

    protected Query getQueryInTable(UserDefinedPO userDefined) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"purpose").is((Object)userDefined.getPurpose()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tableSchema").is((Object)userDefined.getTableSchema()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"userId").is((Object)userDefined.getUserId()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)userDefined.getTenantId()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"pageCode").is((Object)userDefined.getPageCode()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tmProjectId").is((Object)userDefined.getTmProjectId()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tmActivityId").is((Object)userDefined.getTmActivityId()));
        return query;
    }

    public List<UserDefinedFieldsBO> getFieldSeqList(List<String> tmActivityIdList) {
        Criteria criteria = Criteria.where((String)"tmActivityId").in(tmActivityIdList);
        Query query = Query.query((CriteriaDefinition)criteria);
        List UserDefinedPOList = this.getUserdefinedMongoTemplate().find(query, UserDefinedPO.class, COLLECTION_NAME);
        ArrayList resultList = Lists.newArrayList();
        Map<String, List<UserDefinedPO>> taskIdMap = UserDefinedPOList.stream().collect(Collectors.groupingBy(UserDefinedPO::getTmActivityId));
        for (Map.Entry<String, List<UserDefinedPO>> entry : taskIdMap.entrySet()) {
            String activityId = entry.getKey();
            List<UserDefinedPO> userDefineList = entry.getValue();
            ArrayList distinctFieldList = Lists.newArrayList();
            userDefineList.forEach(userDefined -> {
                List<UserDefinedMetadataPO> metadataTags = userDefined.getMetadataTags();
                List fields = Optional.ofNullable(metadataTags).orElse(Lists.newArrayList()).stream().map(UserDefinedMetadataPO::getResourceContent).map(UserDefinedTagResponsePO::getResponse).filter(fieldName -> fieldName.contains(".")).map(fieldName -> fieldName.substring(fieldName.lastIndexOf(".") + 1)).distinct().collect(Collectors.toList());
                if (!distinctFieldList.contains(fields)) {
                    distinctFieldList.add(fields);
                }
            });
            UserDefinedFieldsBO userDefinedFields = UserDefinedFieldsBO.builder().activityId(activityId).userDefinedFieldList(distinctFieldList).build();
            resultList.add(userDefinedFields);
        }
        return resultList;
    }

    public List<UserDefinedPO> getFieldSeqs(UserDefinedPO userDefined) {
        Query query = this.getQuery(userDefined);
        if (StringUtils.isNotEmpty((String)userDefined.getTableSchema())) {
            query = this.getQueryInTable(userDefined);
        }
        ArrayList lists = Lists.newArrayList();
        List list = this.getUserdefinedMongoTemplate().find(query, UserDefinedPO.class, COLLECTION_NAME);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (UserDefinedPO userDefinedNew : list) {
                int i;
                if (CollectionUtils.isNotEmpty(userDefinedNew.getMetadataTags())) {
                    userDefinedNew.getMetadataTags().stream().forEach(tag -> tag.setTableSchema(userDefinedNew.getTableSchema()));
                }
                if (PURPOSE_FIELDSEQBYUSER.equals(userDefined.getPurpose())) {
                    if (list.size() > 1) {
                        for (int i2 = 1; i2 < list.size(); ++i2) {
                            if (CollectionUtils.isNotEmpty(((UserDefinedPO)list.get(i2)).getMetadataTags())) {
                                int finalI = i2;
                                ((UserDefinedPO)list.get(i2)).getMetadataTags().stream().forEach(tag -> tag.setTableSchema(((UserDefinedPO)list.get(finalI)).getTableSchema()));
                            }
                            userDefinedNew.getMetadataTags().addAll(((UserDefinedPO)list.get(i2)).getMetadataTags());
                        }
                    }
                } else if (StringUtils.isNotEmpty((String)userDefinedNew.getTableSchema())) {
                    JSONObject settingWithTable = new JSONObject();
                    settingWithTable.put((Object)userDefinedNew.getTableSchema(), (Object)userDefinedNew.getSettings());
                    userDefinedNew.setSettings(settingWithTable);
                    if (list.size() > 1) {
                        for (i = 1; i < list.size(); ++i) {
                            UserDefinedPO oneUserDefined = (UserDefinedPO)list.get(i);
                            if (!StringUtils.isNotEmpty((String)oneUserDefined.getTableSchema())) continue;
                            settingWithTable.put((Object)oneUserDefined.getTableSchema(), (Object)oneUserDefined.getSettings());
                        }
                    }
                } else if (list.size() > 1) {
                    JSONArray options = userDefinedNew.getSettings().getJSONObject("order").getJSONArray("options");
                    for (i = 1; i < list.size(); ++i) {
                        options.addAll((Collection)((UserDefinedPO)list.get(i)).getSettings().getJSONObject("order").getJSONArray("options"));
                    }
                }
                lists.add(userDefinedNew);
            }
        }
        return lists;
    }

    public List<UserDefinedPO> getSearchConditions(UserDefinedPO userDefined) {
        userDefined.setPurpose(PURPOSE_SEARCH_CONDITIONS);
        Query query = this.getSearchConditionsQuery(userDefined);
        String name = userDefined.getName();
        if (StringUtils.isNotBlank((String)name)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"name").is((Object)name));
        }
        return this.getUserdefinedMongoTemplate().find(query, UserDefinedPO.class, COLLECTION_NAME);
    }

    protected Query getSearchConditionsQuery(UserDefinedPO userDefined) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"purpose").is((Object)userDefined.getPurpose()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tableSchema").is((Object)userDefined.getTableSchema()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"userId").is((Object)userDefined.getUserId()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)userDefined.getTenantId()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"pageCode").is((Object)userDefined.getPageCode()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tmActivityId").is((Object)userDefined.getTmActivityId()));
        if (StringUtils.isNotBlank((String)userDefined.getPageUniqueCode())) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"pageUniqueCode").is((Object)userDefined.getPageUniqueCode()));
        }
        return query;
    }

    public UserGridPO getUserGrid(UserGridPO userGridDTO) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"code").is((Object)userGridDTO.getCode()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)userGridDTO.getTenantId()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"userId").is((Object)userGridDTO.getUserId()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"pageCode").is((Object)userGridDTO.getPageCode()));
        List list = this.getUserdefinedMongoTemplate().find(query, UserGridPO.class, GRID_COLLECTION_NAME);
        if (!list.isEmpty()) {
            return (UserGridPO)list.get(0);
        }
        return new UserGridPO();
    }
}

