/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.sdk.audc.application.service.watermark;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.atdm.annocache.Cache;
import com.digiwin.athena.base.sdk.audc.application.meta.converter.AudcSdkConverter;
import com.digiwin.athena.base.sdk.audc.application.meta.response.watermark.WaterMarkConfigVO;
import com.digiwin.athena.base.sdk.audc.application.service.watermark.QueryWatermarkConfigService;
import com.digiwin.athena.iam.sdk.manager.IamManager;
import com.digiwin.athena.iam.sdk.meta.dto.response.UserTypeRespDTO;
import com.digiwin.athena.tdd.sdk.manager.TddManager;
import com.digiwin.athena.tdd.sdk.meta.dto.request.WaterMarkConfigReqDTO;
import com.digiwin.athena.tdd.sdk.meta.dto.response.WaterMarkConfigRespDTO;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class QueryWatermarkConfigServiceImpl
implements QueryWatermarkConfigService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QueryWatermarkConfigServiceImpl.class);

    @Override
    @Cache(key="'uibot:cache:'+ctx_auth.authoredUser.tenantId+':'+'getWaterMarkConfig_'+waterMarkConfigReqDTO.getPattern()+waterMarkConfigReqDTO.getActivityCode()", ttlSecs=1000L, cacheNull=true)
    public WaterMarkConfigVO getWaterMarkConfig(WaterMarkConfigReqDTO waterMarkConfigReqDTO) {
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        AuthoredUser proxyAuthoredUser = AppAuthContextHolder.getContext().getProxyAuthoredUser();
        String token = Objects.nonNull(proxyAuthoredUser) ? proxyAuthoredUser.getToken() : authoredUser.getToken();
        WaterMarkConfigRespDTO waterMarkConfigResp = (WaterMarkConfigRespDTO)TddManager.getWaterMarkConfig((WaterMarkConfigReqDTO)waterMarkConfigReqDTO, (String)token).getResponse();
        if (Objects.isNull(waterMarkConfigResp)) {
            return null;
        }
        WaterMarkConfigVO waterMarkConfigVO = AudcSdkConverter.INTENSIVE.toWaterMarkConfigVO(waterMarkConfigResp);
        UserTypeRespDTO userTypeRespDTO = IamManager.queryPersonalizedInfo((String)authoredUser.getUserId(), (String)token);
        if (null != userTypeRespDTO) {
            waterMarkConfigVO.setUserType(userTypeRespDTO.getUserType());
        }
        return waterMarkConfigVO;
    }
}

