package com.digiwin.athena.base.sdk.audc.infrastructure.meta.po;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.appcore.util.SnowflakeIdWorker;
import com.digiwin.athena.base.sdk.db.infrastructure.meta.po.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * the_principal_task_type表模型
 *
 * @author chenpeng
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Accessors(chain = true)
@TableName(autoResultMap = true, value = "the_principal_task_type")
public class ThePrincipalTaskType extends BaseEntity<ThePrincipalTaskType> {
    @TableId()
    private Long id;
    /**
     * 被代理人id
     */
    private String thePrincipalId;
    /**
     * 代理人id
     */
    private String agentId;
    /**
     * 租户id
     */
    private String tenantId;
    /**
     * 不可被代理的任务类型
     */
    private String taskDefCode;

    /**
     * 是否为行事历任务 1-是；0或空-否
     */
    private Integer calendarTask;

    /**
     * 逻辑删除标记 0:未删除 1:已删除
     */
    private Integer deleted;

    public ThePrincipalTaskType(String thePrincipalId, String agentId, String tenantId, String taskDefCode, Integer calendarTask) {
        this.id = SnowflakeIdWorker.getInstance().newId();
        this.thePrincipalId = thePrincipalId;
        this.agentId = agentId;
        this.tenantId = tenantId;
        this.taskDefCode = taskDefCode;
        this.createDate = LocalDateTime.now();
        this.modifyDate = LocalDateTime.now();
        this.calendarTask = calendarTask;
        this.deleted = 0;
    }
}
