package com.digiwin.athena.base.sdk.audc.application.config;

import com.alibaba.druid.pool.DruidDataSource;
import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.core.MybatisConfiguration;
import com.baomidou.mybatisplus.core.config.GlobalConfig;
import com.baomidou.mybatisplus.core.toolkit.GlobalConfigUtils;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.PaginationInnerInterceptor;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import com.digiwin.athena.base.sdk.db.infrastructure.meta.handler.BaseEntityMetaObjectHandler;
import com.digiwin.athena.base.sdk.db.infrastructure.meta.injector.BatchInsertSqlInjector;
import org.apache.ibatis.logging.log4j2.Log4j2Impl;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.type.JdbcType;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

import javax.sql.DataSource;

@ConditionalOnProperty(name = "spring.datasource.druid.audc.enable", havingValue = "true")
@Configuration
@MapperScan(value = "com.digiwin.athena.base.sdk.audc.infrastructure.mapper", sqlSessionFactoryRef = AudcSDKDataSourceConfig.AUDC_SDK_SQL_SESSION_FACTORY_NAME)
@EnableTransactionManagement
public class AudcSDKDataSourceConfig {
    private static final String DATASOURCE_NAME = "audcSdkDataSource";

    /**
     * 数据源配置的前缀，必须与application.yaml中配置的对应数据源的前缀一致
     */
    private static final String BUSINESS_DATASOURCE_PREFIX = "spring.datasource.druid.audc";

    public static final String AUDC_SDK_SQL_SESSION_FACTORY_NAME = "audcSqlSessionFactory";

    public static final String AUDC_SDK_DATASOURCE_TRANSACTION_MANAGER_BUSINESS = "audcSDKDataSourceTransactionManager";

    @Bean(name = DATASOURCE_NAME)
    @ConfigurationProperties(prefix = BUSINESS_DATASOURCE_PREFIX)
    public DruidDataSource audcDruidDataSource() {
        System.err.println("初始化AudcSDKDataSourceConfig中。。。");
        return new DruidDataSource();
    }

    @Bean(name = AUDC_SDK_SQL_SESSION_FACTORY_NAME)
    public SqlSessionFactory sqlSessionFactory(@Qualifier(DATASOURCE_NAME) DataSource dataSource) throws Exception {
        MybatisSqlSessionFactoryBean bean = new MybatisSqlSessionFactoryBean();
        bean.setDataSource(dataSource);
        bean.setMapperLocations(new PathMatchingResourcePatternResolver().getResources("classpath*:mapper/sdk/audc/*.xml"));

        MybatisConfiguration configuration = new MybatisConfiguration();
        configuration.setCacheEnabled(false);
        configuration.setLogImpl(Log4j2Impl.class);
        configuration.setJdbcTypeForNull(JdbcType.NULL);
        configuration.setMapUnderscoreToCamelCase(true);
        bean.setConfiguration(configuration);
        GlobalConfig globalConfig = GlobalConfigUtils.defaults();
        globalConfig.setBanner(false);
        globalConfig.setSqlInjector(new BatchInsertSqlInjector());
        globalConfig.setMetaObjectHandler(new BaseEntityMetaObjectHandler());

        bean.setGlobalConfig(globalConfig);

        MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
        interceptor.addInnerInterceptor(new PaginationInnerInterceptor(DbType.MYSQL));
        bean.setPlugins(interceptor);

        bean.setPlugins();
        return bean.getObject();
    }

    @Bean(name = AUDC_SDK_DATASOURCE_TRANSACTION_MANAGER_BUSINESS)
    public DataSourceTransactionManager transactionManager(@Qualifier(DATASOURCE_NAME) DataSource dataSource) {
        return new DataSourceTransactionManager(dataSource);
    }

}

