package com.digiwin.athena.base.sdk.audc.application.service.userdefined;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.base.sdk.audc.application.util.LocaleUtils;
import com.digiwin.athena.base.sdk.audc.infrastructure.meta.bo.userdefined.mongo.UserDefinedFieldsBO;
import com.digiwin.athena.base.sdk.audc.infrastructure.meta.po.userdefined.mongo.UserDefinedPO;
import com.digiwin.athena.base.sdk.audc.infrastructure.meta.po.userdefined.mongo.UserDefinedSearchConditionGroupPO;
import com.digiwin.athena.base.sdk.audc.infrastructure.meta.po.userdefined.mongo.UserDefinedSearchConditionPO;
import com.digiwin.athena.base.sdk.audc.infrastructure.meta.po.userdefined.mongo.UserGridPO;
import com.digiwin.athena.base.sdk.audc.infrastructure.mongo.QueryUserDefinedMapper;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

import java.util.Comparator;
import java.util.List;

@Slf4j
@Service
public class QueryUserDefinedServiceImpl implements QueryUserDefinedService {
    //字段排序
    public static String PURPOSE_FIELDSEQBYUSER = "FieldSeqByUser";

    //数据排序条件
    public static String PURPOSE_ORDERCONDITIONS = "OrderConditions";

    @Autowired
    private QueryUserDefinedMapper queryUserDefinedMapper;


    @Override
    public MongoTemplate getUserDefinedMongoTemplate() {
        return queryUserDefinedMapper.getUserdefinedMongoTemplate();
    }

    @Override
    public UserDefinedPO getFieldSeqList(AuthoredUser user, String pageCode, String tmProjectId, String tmActivityId, String tableSchema, String pageUniqueCode) {
        UserDefinedPO userDefined = new UserDefinedPO();
        userDefined.setUserId(user.getUserId());
        userDefined.setTenantId(user.getTenantId());
        userDefined.setPageCode(pageCode);
        userDefined.setTmProjectId(tmProjectId);
        userDefined.setTableSchema(tableSchema);
        userDefined.setTmActivityId(tmActivityId);
        userDefined.setPurpose(PURPOSE_FIELDSEQBYUSER);
        userDefined.setPageUniqueCode(pageUniqueCode);
        return queryUserDefinedMapper.getFieldSeqList(userDefined);
    }

    @Override
    public List<UserDefinedFieldsBO> getFieldSeqList(List<String> tmActivityIdList) {
        return queryUserDefinedMapper.getFieldSeqList(tmActivityIdList);
    }

    @Override
    public UserDefinedPO getOrderConditionsByUser(AuthoredUser user, String pageCode, String tmProjectId, String tmActivityId, String tableSchema, String pageUniqueCode) {
        UserDefinedPO userDefined = new UserDefinedPO();
        userDefined.setUserId(user.getUserId());
        userDefined.setTenantId(user.getTenantId());
        userDefined.setPageCode(pageCode);
        userDefined.setTmProjectId(tmProjectId);
        userDefined.setTableSchema(tableSchema);
        userDefined.setTmActivityId(tmActivityId);
        userDefined.setPurpose(PURPOSE_ORDERCONDITIONS);
        userDefined.setPageUniqueCode(pageUniqueCode);
        return queryUserDefinedMapper.getFieldSeqList(userDefined);
    }

    @Override
    public List<UserDefinedPO> getOrderConditionsFields(AuthoredUser user, String pageCode, String tmProjectId, String tmActivityId, String tableSchema) {
        UserDefinedPO userDefined = new UserDefinedPO();
        userDefined.setUserId(user.getUserId());
        userDefined.setTenantId(user.getTenantId());
        userDefined.setPageCode(pageCode);
        userDefined.setTmProjectId(tmProjectId);
        userDefined.setTableSchema(tableSchema);
        userDefined.setTmActivityId(tmActivityId);
        userDefined.setPurpose(PURPOSE_ORDERCONDITIONS);
        return queryUserDefinedMapper.getFieldSeqs(userDefined);
    }

    /**
     * 查询表格高级查询常用条件配置
     *
     * @param user
     * @param userDefined
     * @return
     */
    @Override
    public List<UserDefinedPO> getSearchConditions(AuthoredUser user, UserDefinedPO userDefined) {
        // 存入当前用户租户
        setUserInfo(user, userDefined);
        List<UserDefinedPO> searchConditions = queryUserDefinedMapper.getSearchConditions(userDefined);
        if (CollectionUtils.isNotEmpty(searchConditions)) {
            for (UserDefinedPO searchCondition : searchConditions) {
                List<UserDefinedSearchConditionGroupPO> groupList = searchCondition.getSearchConditions();
                if (CollectionUtils.isEmpty(groupList)) {
                    continue;
                }
                for (UserDefinedSearchConditionGroupPO searchConditionGroup : groupList) {
                    List<UserDefinedSearchConditionPO> queryGroup = searchConditionGroup.getQueryGroup();
                    if (CollectionUtils.isEmpty(queryGroup)) {
                        continue;
                    }
                    // 常用搜索条件国际化
                    for (UserDefinedSearchConditionPO condition : queryGroup) {
                        LocaleUtils.valueLocale(condition.getOptions());
                    }
                }
            }
            searchConditions.sort(Comparator.comparingLong(UserDefinedPO::getUniqueId).reversed());
        }
        return searchConditions;
    }

    protected void setUserInfo(AuthoredUser user, UserDefinedPO userDefined) {
        userDefined.setUserId(user.getUserId());
        userDefined.setTenantId(user.getTenantId());
    }

    @Override
    public UserGridPO getGridItems(UserGridPO userGridDTO) {
        return queryUserDefinedMapper.getUserGrid(userGridDTO);
    }
}
