package com.digiwin.athena.base.sdk.audc.infrastructure.meta.po.userdefined.mongo;

import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

/**
 * Description 用户保存items数据结构
 * Author hebaokai
 * Date 2024/7/11 11:44
 *
 * @Version 1.0
 **/
@Data
public class UserGridPO {

    /**
     * 利用雪花生成的唯一ID
     */
    private Long uniqueId;

    /**
     * 作业code
     */
    private String code;

    /**
     * 用户id
     */
    private String userId;

    /**
     * 租户id
     */
    private String tenantId;

    /**
     * "task-detail",
     * "project-detail"
     */
    private String pageCode;

    /**
     * item集合
     */
    private List<UserGridItemsPO> items;


    /**
     * 记录的落表时间-时间戳
     */
    protected LocalDateTime createDate;

    /**
     * 记录的落表时间-时间戳
     */
    protected LocalDateTime updateDate;
}
