/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.sdk.audc.application.service.userdefined;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.base.sdk.audc.application.service.userdefined.QueryUserDefinedService;
import com.digiwin.athena.base.sdk.audc.application.util.LocaleUtils;
import com.digiwin.athena.base.sdk.audc.infrastructure.meta.bo.userdefined.mongo.UserDefinedFieldsBO;
import com.digiwin.athena.base.sdk.audc.infrastructure.meta.po.userdefined.mongo.UserDefinedPO;
import com.digiwin.athena.base.sdk.audc.infrastructure.meta.po.userdefined.mongo.UserDefinedSearchConditionGroupPO;
import com.digiwin.athena.base.sdk.audc.infrastructure.meta.po.userdefined.mongo.UserDefinedSearchConditionPO;
import com.digiwin.athena.base.sdk.audc.infrastructure.meta.po.userdefined.mongo.UserGridPO;
import com.digiwin.athena.base.sdk.audc.infrastructure.mongo.QueryUserDefinedMapper;
import java.util.Comparator;
import java.util.List;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

@Service
public class QueryUserDefinedServiceImpl
implements QueryUserDefinedService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QueryUserDefinedServiceImpl.class);
    public static String PURPOSE_FIELDSEQBYUSER = "FieldSeqByUser";
    public static String PURPOSE_ORDERCONDITIONS = "OrderConditions";
    @Autowired
    private QueryUserDefinedMapper queryUserDefinedMapper;

    @Override
    public MongoTemplate getUserDefinedMongoTemplate() {
        return this.queryUserDefinedMapper.getUserdefinedMongoTemplate();
    }

    @Override
    public UserDefinedPO getFieldSeqList(AuthoredUser user, String pageCode, String tmProjectId, String tmActivityId, String tableSchema, String pageUniqueCode) {
        UserDefinedPO userDefined = new UserDefinedPO();
        userDefined.setUserId(user.getUserId());
        userDefined.setTenantId(user.getTenantId());
        userDefined.setPageCode(pageCode);
        userDefined.setTmProjectId(tmProjectId);
        userDefined.setTableSchema(tableSchema);
        userDefined.setTmActivityId(tmActivityId);
        userDefined.setPurpose(PURPOSE_FIELDSEQBYUSER);
        userDefined.setPageUniqueCode(pageUniqueCode);
        return this.queryUserDefinedMapper.getFieldSeqList(userDefined);
    }

    @Override
    public List<UserDefinedFieldsBO> getFieldSeqList(List<String> tmActivityIdList) {
        return this.queryUserDefinedMapper.getFieldSeqList(tmActivityIdList);
    }

    @Override
    public UserDefinedPO getOrderConditionsByUser(AuthoredUser user, String pageCode, String tmProjectId, String tmActivityId, String tableSchema, String pageUniqueCode) {
        UserDefinedPO userDefined = new UserDefinedPO();
        userDefined.setUserId(user.getUserId());
        userDefined.setTenantId(user.getTenantId());
        userDefined.setPageCode(pageCode);
        userDefined.setTmProjectId(tmProjectId);
        userDefined.setTableSchema(tableSchema);
        userDefined.setTmActivityId(tmActivityId);
        userDefined.setPurpose(PURPOSE_ORDERCONDITIONS);
        userDefined.setPageUniqueCode(pageUniqueCode);
        return this.queryUserDefinedMapper.getFieldSeqList(userDefined);
    }

    @Override
    public List<UserDefinedPO> getOrderConditionsFields(AuthoredUser user, String pageCode, String tmProjectId, String tmActivityId, String tableSchema) {
        UserDefinedPO userDefined = new UserDefinedPO();
        userDefined.setUserId(user.getUserId());
        userDefined.setTenantId(user.getTenantId());
        userDefined.setPageCode(pageCode);
        userDefined.setTmProjectId(tmProjectId);
        userDefined.setTableSchema(tableSchema);
        userDefined.setTmActivityId(tmActivityId);
        userDefined.setPurpose(PURPOSE_ORDERCONDITIONS);
        return this.queryUserDefinedMapper.getFieldSeqs(userDefined);
    }

    @Override
    public List<UserDefinedPO> getSearchConditions(AuthoredUser user, UserDefinedPO userDefined) {
        this.setUserInfo(user, userDefined);
        List<UserDefinedPO> searchConditions = this.queryUserDefinedMapper.getSearchConditions(userDefined);
        if (CollectionUtils.isNotEmpty(searchConditions)) {
            for (UserDefinedPO searchCondition : searchConditions) {
                List<UserDefinedSearchConditionGroupPO> groupList = searchCondition.getSearchConditions();
                if (CollectionUtils.isEmpty(groupList)) continue;
                for (UserDefinedSearchConditionGroupPO searchConditionGroup : groupList) {
                    List<UserDefinedSearchConditionPO> queryGroup = searchConditionGroup.getQueryGroup();
                    if (CollectionUtils.isEmpty(queryGroup)) continue;
                    for (UserDefinedSearchConditionPO condition : queryGroup) {
                        LocaleUtils.valueLocale(condition.getOptions());
                    }
                }
            }
            searchConditions.sort(Comparator.comparingLong(UserDefinedPO::getUniqueId).reversed());
        }
        return searchConditions;
    }

    protected void setUserInfo(AuthoredUser user, UserDefinedPO userDefined) {
        userDefined.setUserId(user.getUserId());
        userDefined.setTenantId(user.getTenantId());
    }

    @Override
    public UserGridPO getGridItems(UserGridPO userGridDTO) {
        return this.queryUserDefinedMapper.getUserGrid(userGridDTO);
    }
}

