/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.base.sdk.common.application.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class MessageUtil {
    private static final Map<String, ResourceBundle> MESSAGES = new HashMap<String, ResourceBundle>();
    private static final String BASENAME = "i18n/base";

    public static String getMessage(String key, Object ... params) {
        String locale1 = null;
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (servletRequestAttributes == null) {
            locale1 = "zh_CN";
        } else {
            HttpServletRequest request = servletRequestAttributes.getRequest();
            String string = locale1 = request == null ? "zh_CN" : request.getHeader("locale");
            if (StringUtils.isEmpty((String)locale1)) {
                locale1 = "zh_CN";
            }
        }
        return MessageUtil.getMessageByLocale(key, locale1, params);
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return ResourceBundle.getBundle(BASENAME, locale, classLoader, new ResourceBundle.Control(){

            @Override
            public List<String> getFormats(String baseName) {
                return Arrays.asList("properties");
            }

            @Override
            public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
                String bundleName = this.toBundleName(baseName, locale);
                String resourceName = this.toResourceName(bundleName, "properties");
                Enumeration<URL> urls = loader.getResources(resourceName);
                PropertyResourceBundle result = null;
                while (urls.hasMoreElements()) {
                    URL url = urls.nextElement();
                    InputStream stream = url.openStream();
                    Throwable throwable = null;
                    try {
                        PropertyResourceBundle bundle = new PropertyResourceBundle(stream);
                        if (result == null) {
                            result = bundle;
                            continue;
                        }
                        result = this.mergeBundles(result, bundle);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (stream == null) continue;
                        if (throwable != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        stream.close();
                    }
                }
                return result;
            }

            private PropertyResourceBundle mergeBundles(PropertyResourceBundle main, PropertyResourceBundle additional) throws IOException {
                HashMap merged = new HashMap();
                main.keySet().forEach(k -> merged.put(k, main.getString((String)k)));
                additional.keySet().forEach(k -> merged.put(k, additional.getString((String)k)));
                return new PropertyResourceBundle(new ByteArrayInputStream(merged.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining("\n")).getBytes(StandardCharsets.UTF_8)));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMessageByLocale(String key, String locale1, Object ... params) {
        String[] s = locale1.split("_");
        Locale locale = new Locale(s[0], s[1]);
        ResourceBundle message = MESSAGES.get(locale.toString());
        if (message == null) {
            Map<String, ResourceBundle> map = MESSAGES;
            synchronized (map) {
                message = MESSAGES.get(locale.toString());
                if (message == null) {
                    message = MessageUtil.getResourceBundle(locale);
                    MESSAGES.put(locale.toString(), message);
                }
            }
        }
        if (params != null) {
            try {
                if (locale1.equals("zh_CN")) {
                    return String.format(new String(message.getString(key).getBytes("UTF-8"), "UTF-8"), params);
                }
                return String.format(message.getString(key), params);
            }
            catch (UnsupportedEncodingException e) {
                return "";
            }
        }
        try {
            if (locale1.equals("zh_CN")) {
                return new String(message.getString(key).getBytes("UTF-8"), "UTF-8");
            }
            return String.format(message.getString(key), params);
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public static void flushMessage() {
        MESSAGES.clear();
    }
}

