package com.digiwin.athena.base.sdk.common.application.validator;

import com.digiwin.athena.base.sdk.common.application.annotation.ElementNotBlank;
import org.apache.commons.lang.StringUtils;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.util.Collection;

public class ElementNotBlankConstraint implements ConstraintValidator<ElementNotBlank, Collection<String>> {
    @Override
    public void initialize(ElementNotBlank constraintAnnotation) {
    }

    @Override
    public boolean isValid(Collection<String> values, ConstraintValidatorContext context) {
        if (null == values || 0 == values.size()) {
            return false;
        }

        for (String value : values) {
            if (StringUtils.isBlank(value)) {
                return false;
            }
        }

        return true;
    }
}
