package com.digiwin.athena.atdm.abt;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.atdm.RemoteProperties;
import com.digiwin.athena.atdm.datasource.domain.Action;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.Map;


@Service
@Slf4j
public class CommonReImportServiceImpl implements CommonReImportService {
    public static final String REPUBLISH_ID = "/api/abt/v1/baseDataEntry/republishById";

    @Autowired
    private RestTemplate restTemplate;

    @Autowired
    private RemoteProperties envProperties;

    @Override
    public void execute(Action action) {

        Map<String, Object> paras = action.getParas();

        String url = envProperties.getAbtUri() + REPUBLISH_ID;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity httpEntity = new HttpEntity(paras, headers);

        log.info("republish httpEntity：{}", httpEntity.getBody());
        ResponseEntity<BaseResultDTO> respEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                new ParameterizedTypeReference<BaseResultDTO>() {
                });
        log.info("republish respEntity:{}", respEntity.getBody().getStatus());
    }
}
