package com.digiwin.athena.atdm.esp;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.auth.service.TokenVerifyService;
import com.digiwin.athena.appcore.constant.ErrorTypeEnum;
import com.digiwin.athena.appcore.constant.LogConstant;
import com.digiwin.athena.appcore.domain.log.LogDataDto;
import com.digiwin.athena.appcore.domain.log.LogDto;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.ChainInfoUtil;
import com.digiwin.athena.appcore.util.DataUtils;
import com.digiwin.athena.appcore.util.EspJacksonUtil;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atdm.RemoteProperties;
import com.digiwin.athena.atdm.UiBotConstants;
import com.digiwin.athena.atdm.action.dto.TenantConfigDTO;
import com.digiwin.athena.atdm.audc.CommonAudcService;
import com.digiwin.athena.atdm.constant.ErrorCodeEnum;
import com.digiwin.athena.atdm.constant.Variables;
import com.digiwin.athena.atdm.datasource.domain.Action;
import com.digiwin.athena.atdm.datasource.domain.ActionServiceId;
import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import com.digiwin.athena.atdm.datasource.dto.PageInfo;
import com.digiwin.athena.atdm.esp.dto.EspApiDTO;
import com.digiwin.athena.atdm.esp.dto.EspParam;
import com.digiwin.athena.atdm.util.SearchInfoUtil;
import com.digiwin.athena.esp.sdk.exception.InvocationException;
import com.digiwin.athena.esp.sdk.model.RequestModel;
import com.digiwin.athena.esp.sdk.model.ResponseModel;
import com.digiwin.athena.esp.sdk.util.CompressUtil;
import com.digiwin.athena.smartdata.sdk.InvokerProxy;
import com.google.common.collect.Maps;
import io.seata.core.context.RootContext;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import static com.digiwin.service.permission.consts.ConstDef.KEY_SECURITY_TOKEN;

@Service
@Slf4j
public class CommonESPServiceImpl implements CommonESPService {
    @Autowired
    RestTemplate restTemplate;

    @Autowired
    RemoteProperties envProperties;

    @Autowired
    MessageUtils messageUtils;


    @Autowired
    private TokenVerifyService tokenVerifyService;

    @Resource
    private CommonAudcService audcService;

    public static final String TX_XID = "tx-xid";

    /**
     * 直接接口查询API数据
     *
     * @param action
     * @param parameter
     * @return
     */
    @Override
    public HashMap<String, Object> query(ExecuteContext executeContext, Action action, Map<String, Object> parameter) {
        if (parameter != null && action.getParas() == null && action.getActionParams() == null) {
            action.setParas(new HashMap<>());
            Map paras = action.getParas();
            for (Map.Entry<String, Object> stringObjectEntry : parameter.entrySet()) {
                paras.put(stringObjectEntry.getKey(), stringObjectEntry.getValue());
            }
        }
        ActionServiceId serviceId = getActionServiceId(executeContext.getTenantId(), executeContext.getPageCode(), executeContext.getPattern(), action, executeContext.getAuthoredUser());

        Map<String, String> headers = createHeaders(serviceId, serviceId.getProxyToken(), executeContext.getAuthoredUser().getToken(), executeContext.getLocale(), action);

        //todo：特殊处理
        if ("esp_doapi.input.invoice.query".equals(action.getActionId())) {
            headers.put("digi-appname", "bwcloudpi");
        }

        String body = EspJacksonUtil.toStringFromMapIgnoreKeys(action.initParas(action.getParas()));
        EspParam espParam = new EspParam();
        espParam.setBusinessUnit(action.getBusinessUnit());
        espParam.setActionExtendFields(action.getExtendedFields());
        espParam.setServiceId(serviceId);
        espParam.setHeaders(headers);
        espParam.setBody(body);
        espParam.setSync(true);
        espParam.setApplication(executeContext.getApplication());
        espParam.setTmActivityId(executeContext.getTmActivityId());
        espParam.setPattern(executeContext.getPattern());
        espParam.setPageCode(executeContext.getPageCode());
        return invokeEsp(espParam);


    }

    private ActionServiceId getActionServiceId(String tenantId, String pageCode, String pattern, Action action, AuthoredUser authoredUser) {
        ActionServiceId serviceId = action.getServiceId();
        if (serviceId == null) {
            serviceId = new ActionServiceId();
            serviceId.setTenant_id(tenantId);
            serviceId.setHostAcct("athena");
            serviceId.setName(action.getActionId().replace("esp_", ""));
        }
        if (StringUtils.isEmpty(serviceId.getName())) {
            serviceId.setName(action.getActionId().replace("esp_", ""));
        }
        if (StringUtils.isEmpty(serviceId.getTenant_id())) {
            serviceId.setTenant_id(tenantId);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank(AppAuthContextHolder.getContext().getProxyToken())) {
            serviceId.setProxyToken(AppAuthContextHolder.getContext().getProxyToken());
        }

        String hostAcct = getHostAcct(pageCode, pattern, authoredUser);
        serviceId.setHostAcct(hostAcct);
        return serviceId;
    }


    @Override
    public HashMap<String, Object> queryByApiName(ExecuteContext executeContext, String apiName, Map<String, Object> parameter, PageInfo pageInfo, List<Map> sortInfo, List<Map> searchInfo) {

        Action tmAction = new Action();
        tmAction.setCategory("ESP");
        if (!apiName.startsWith("esp")) {
            tmAction.setActionId("esp_" + apiName);
        } else {
            tmAction.setActionId(apiName);
        }

        ActionServiceId actionServiceId = getActionServiceId(executeContext.getTenantId(), executeContext.getPageCode(), executeContext.getPattern(), tmAction, executeContext.getAuthoredUser());


        Map<String, String> headers = createHeaders(actionServiceId, actionServiceId.getProxyToken(), executeContext.getAuthoredUser().getToken(), executeContext.getLocale(), null);


        Map<String, Object> bodyMap = new HashMap<String, Object>();
        Map<String, Object> std_data = new HashMap<>();
        if (parameter == null) {
            parameter = new HashMap<>();
        }
        //处理分页信息
        if (pageInfo != null) {
            if (pageInfo.getPageSize() != null) {
                parameter.put("use_has_next", true);
                parameter.put("page_size", pageInfo.getPageSize());
            }
            if (pageInfo.getPageNo() != null) {
                parameter.put("page_no", pageInfo.getPageNo());
            }
        }
        //排序
        if (CollectionUtils.isNotEmpty(sortInfo)) {
            parameter.put("sort_info", sortInfo);
        }
        //查询
        if (CollectionUtils.isNotEmpty(searchInfo)) {
            parameter.put(Variables.SEARCH_VALUE, "");
            parameter.put(Variables.SEARCH_INFO, SearchInfoUtil.mergeSearchInfo((List<Map>) parameter.get(Variables.SEARCH_INFO), searchInfo));
        }
        bodyMap.put("std_data", std_data);
        std_data.put("parameter", parameter);
        if (!parameter.containsKey("enterprise_no")) {
            if (executeContext.getBusinessUnit() != null) {
                if (executeContext.getBusinessUnit().containsKey("eoc_company_id")) {
                    parameter.put("enterprise_no", executeContext.getBusinessUnit().get("eoc_company_id"));
                } else {
                    //todo: wf的api有问题，必须传一个值
                    parameter.put("enterprise_no", "enterprise_no");
                }
                if (executeContext.getBusinessUnit().containsKey("eoc_site_id")) {
                    parameter.put("site_no", executeContext.getBusinessUnit().get("eoc_site_id"));
                } else {
                    //todo: wf的api有问题，必须传一个值
                    parameter.put("site_no", "site_no");
                }
            }
        }
        String body = EspJacksonUtil.toStringFromMapIgnoreKeys(bodyMap);
        EspParam espParam = new EspParam();
        espParam.setBusinessUnit(executeContext.getBusinessUnit());
        espParam.setActionExtendFields(null);
        espParam.setServiceId(actionServiceId);
        espParam.setHeaders(headers);
        espParam.setBody(body);
        espParam.setSync(true);
        espParam.setApplication(executeContext.getApplication());
        espParam.setTmActivityId(executeContext.getTmActivityId());
        espParam.setPattern(executeContext.getPattern());
        espParam.setPageCode(executeContext.getPageCode());
        return invokeEsp(espParam);
    }

    /**
     * 执行ESP ACTION操作
     * 1.这边存在批量操作
     *
     * @return
     * @throws Exception
     */
    @Override
    public HashMap execute(SubmitExecuteContext executeContext, Action action) {
       /* ActionServiceId serviceId = getActionServiceId(executeContext.getTenantId(),executeContext.getPageCode(),executeContext.getPattern(), action,executeContext.getAuthoredUser());

        Map<String, String> headers = createHeaders(serviceId, serviceId.getProxyToken(), executeContext.getAuthoredUser().getToken(), executeContext.getLocale(), action);

        String body = "";
        if (action.getParas() != null && action.getParas().size() > 0) {
            Optional<Map<String, Object>> optionalStringObjectMap = DataUtils.mergeMap(action.getParas());
            body = JsonUtils.objectToString(action.initParas(optionalStringObjectMap.get()));//NOSONAR
        }

        //同步调用还是异步调用
        if ( StringUtils.isEmpty(action.getInvokeType()) ){
            action.setInvokeType(getApiMetadataInvokeType(serviceId.getName()));
        }
        boolean sync = StringUtils.isEmpty(action.getInvokeType()) || "sync".equals(action.getInvokeType());
        return invokeEsp(action.getBusinessUnit(), action.getExtendedFields(), serviceId, headers, body, sync);*/

        HashMap resultMap = executeReturnAll(executeContext, action);
        if (MapUtils.isEmpty(resultMap) || !resultMap.containsKey("data") || null == resultMap.get("data")) {
            return null;
        }
        return (HashMap<String, Object>) resultMap.get("data");
    }


    /**
     * 执行ESP ACTION操作
     * 1.这边存在批量操作
     *
     * @return
     * @throws Exception
     */
    @Override
    public HashMap executeReturnAll(SubmitExecuteContext executeContext, Action action) {
        ActionServiceId serviceId = getActionServiceId(executeContext.getTenantId(), executeContext.getPageCode(), executeContext.getPattern(), action, executeContext.getAuthoredUser());

        Map<String, String> headers = createHeaders(serviceId, serviceId.getProxyToken(), executeContext.getAuthoredUser().getToken(), executeContext.getLocale(), action);

        String body = "";
        if (action.getParas() != null && action.getParas().size() > 0) {
            Optional<Map<String, Object>> optionalStringObjectMap = DataUtils.mergeMap(action.getParas());
            body = EspJacksonUtil.toStringFromMapIgnoreKeys(action.initParas(optionalStringObjectMap.get()));//NOSONAR
        }
        //假设为需要压缩
        if (Boolean.TRUE.equals(action.getNeedCompress())) {
            //请求头添加参数
            headers.put("digi-use-compressed", "true");
            body = CompressUtil.compressBody(body);
        }
        //同步调用还是异步调用
        if (StringUtils.isEmpty(action.getInvokeType())) {
            action.setInvokeType(getApiMetadataInvokeType(serviceId.getName()));
        }
        boolean sync = StringUtils.isEmpty(action.getInvokeType()) || "sync".equals(action.getInvokeType());
        EspParam espParam = new EspParam();
        espParam.setBusinessUnit(action.getBusinessUnit());
        espParam.setActionExtendFields(action.getExtendedFields());
        espParam.setServiceId(serviceId);
        espParam.setHeaders(headers);
        espParam.setBody(body);
        espParam.setSync(sync);
        espParam.setApplication(executeContext.getApplication());
        espParam.setTmActivityId(executeContext.getTmActivityId());
        espParam.setPattern(executeContext.getPattern());
        espParam.setPageCode(executeContext.getPageCode());
        return invokeEspReturnAll(espParam);

    }

    @Override
    public String getApiMetadataInvokeType(String apiName) {
        HttpHeaders headerMap = new HttpHeaders();
        headerMap.add("Content-Type", "application/json;charset=UTF-8");
        Map<String, Object> paraMap = new HashMap<>();
        paraMap.put("api_name", apiName);

        String uri = envProperties.getMdcLbUri() + "/restful/standard/mdc/ApiMetadata/Get";
        HttpEntity httpEntity = new HttpEntity<Map>(paraMap, headerMap);
        ResponseEntity<EspApiDTO> responseEntity = restTemplate.postForEntity(uri, httpEntity, EspApiDTO.class);
        if (responseEntity.getBody().getExecution() != null && !"000".equals(responseEntity.getBody().getExecution().getCode())) {
            return "sync";
        }

        EspApiDTO resultDTO = responseEntity.getBody();
        return resultDTO.getData().getType();
    }


    private HashMap invokeEsp(EspParam espParam) {

       /* RequestModel requestModel = createEspRequestModel(businessUnit, actionExtendFields, serviceId, headers, body);
        ResponseModel responseModel;
        try{
            if (sync) {
                // 同步
                responseModel = InvokerProxy.invokeRestSync(requestModel);
            } else {
                //全异步
                responseModel = InvokerProxy.invokeRestFasync(requestModel);
            }
        }catch (Exception e){
            String error=  String.format(messageUtils.getMessage("exception.execution.api.fail"), serviceId.getName(),e.getMessage());
            throw  BusinessException.create(error,e);
        }

        HashMap resultMap = throwEspError(serviceId.getName(), responseModel);*/
        HashMap resultMap = invokeEspReturnAll(espParam);
        if (MapUtils.isEmpty(resultMap) || !resultMap.containsKey("data") || null == resultMap.get("data")) {
            return null;
        }
        return (HashMap<String, Object>) resultMap.get("data");
    }

    /**
     * 执行esp返回数据
     *
     * @param espParam
     * @return
     */
    private HashMap invokeEspReturnAll(EspParam espParam) {
        ActionServiceId serviceId = espParam.getServiceId();
        serviceId = serviceId == null ? ActionServiceId.empty() : serviceId;
        String tenantId = serviceId.getTenant_id();
        String serviceName = serviceId.getName();
//        LogDto logDto = new LogDto("执行esp开始，service name：" + serviceName, tenantId + LogConstant.TRACE_SEPARATOR + serviceName);
//        LogDataDto logDataDto = new LogDataDto(serviceId.getServiceUri(), "调用url", LogConstant.TYPE_LINK, LogConstant.LABEL_ESP);
//        logDto.setData(Arrays.asList(logDataDto));
//        log.info(logDto.toString());
        RequestModel requestModel = createEspRequestModel(espParam);
        ResponseModel responseModel;
        try {
            if (espParam.isSync()) {
                // 同步
                responseModel = InvokerProxy.invokeRestSync(requestModel);
            } else {
                //全异步
                responseModel = InvokerProxy.invokeRestFasync(requestModel);
            }
        } catch (Exception e) {
            if (e instanceof InvocationException) {
                InvocationException invocationException = (InvocationException) e;

                BusinessException businessException = BusinessException.create(invocationException.getErrorCode(), invocationException.getErrorMessage(), e);
                businessException.setErrorInstructors(Maps.newHashMap());
                businessException.getErrorInstructors().put(GlobalConstant.CHAIN_INFO, invocationException.getChainInfo());
                throw businessException;
            } else {
                String error = String.format(messageUtils.getMessage("exception.execution.api.fail"), serviceId.getName(), e.getMessage());
                throw BusinessException.create(ErrorCodeEnum.ESP_EXECUTE_ERROR.getErrCode(), error, e);
            }
        }


        HashMap resultMap = new HashMap();
        HashMap responseMap = throwEspError(serviceId.getName(), responseModel, requestModel);
        HashMap stdDataMap = (HashMap) responseMap.getOrDefault("std_data", null);
        if (stdDataMap != null) {
            resultMap.put("data", stdDataMap.getOrDefault("parameter", null));
        }
        resultMap.put("sync", espParam.isSync());
        resultMap.put("reqId", responseModel.getReqid());
        LogDto logDtoEnd = new LogDto("执行esp结束，service name：" + serviceName, tenantId + LogConstant.TRACE_SEPARATOR + serviceName);
        LogDataDto logDataDtoEnd = new LogDataDto(responseModel.getReqid(), "esp请求id", LogConstant.TYPE_LINK, LogConstant.LABEL_ESP);
        logDtoEnd.setData(Arrays.asList(logDataDtoEnd));
        log.info(logDtoEnd.toString());
        return resultMap;
    }


    private HashMap throwEspError(String serviceId, ResponseModel responseModel, RequestModel requestModel) {

        String serviceProd = requestModel.getServiceProd();
        String errorCode = ErrorCodeEnum.ESP_EXECUTE_RETURN_ERROR.getErrCode();
        if (!StringUtils.isEmpty(serviceProd)) {
            errorCode = "P." + serviceProd + ".500.599";
        }
        // 稳敏API发生调用异常  => digi-code 非0开头
        if (!responseModel.getEspCode().startsWith("0")) {
            String error = String.format(messageUtils.getMessage("exception.execution.api.fail"), serviceId, responseModel.getEspMessage());
            throw BusinessException.create(599, errorCode, error);
        }
        if (StringUtils.isEmpty(responseModel.getBodyJsonString())) {
            String error = String.format(messageUtils.getMessage("exception.execution.api.fail2"), serviceId);
            throw BusinessException.create(599, errorCode, error);
        }
        HashMap espResponse = JsonUtils.jsonToObject(responseModel.getBodyJsonString(), HashMap.class);
        if (espResponse.containsKey("error")) {
            String error = String.format(messageUtils.getMessage("exception.execution.api.fail"), serviceId, espResponse.get("error"));
            throw BusinessException.create(599, errorCode, error);
        }
        HashMap stdDataMap = (HashMap) espResponse.getOrDefault("std_data", null);
        if (stdDataMap == null) {
            String error = String.format(messageUtils.getMessage("exception.execution.api.fail3"), serviceId, responseModel.getBodyJsonString());
            throw BusinessException.create(599, errorCode, error);
        }
        HashMap execution = (HashMap) stdDataMap.getOrDefault("execution", null);
        if (execution == null) {
            String error = String.format(messageUtils.getMessage("exception.execution.api.fail4"), serviceId, responseModel.getBodyJsonString());
            throw BusinessException.create(599, errorCode, error);
        }

        // 业务异常
        if (!"000".equals(responseModel.getSrvCode())) {
            String description = (String) execution.getOrDefault("description", "");
            String code = (String) execution.getOrDefault("code", "");
            //TODO 后续看有机会抽出 对接告警平台-如果应用返回错误码为-1那么将errorCode变成.9999.9999结尾
            errorCode = StringUtils.isEmpty(code) ? errorCode : code;
            if ("-1".equals(code)) {
                errorCode = "P." + serviceProd + ".9999.9999";
            }
            String displayDescription = String.format(messageUtils.getMessage("exception.execution.api.fail5"), serviceId, responseModel.getBodyJsonString());
            BusinessException businessException = BusinessException.create(500, errorCode, description, displayDescription, "", ErrorTypeEnum.BUSINESS.getValue(), null);
            businessException.setErrorInstructors(Maps.newHashMap());
            businessException.getErrorInstructors().put(GlobalConstant.SOURCE, GlobalConstant.SOURCE_TYPE_APP);
            businessException.setEspError(execution);
            throw businessException;
        }

        return espResponse;
    }

    /**
     * 创建ESP请求参数
     *
     * @param espParam
     * @return
     */
    private RequestModel createEspRequestModel(EspParam espParam) {
        Map businessUnit = espParam.getBusinessUnit();
        Map<String, Object> actionExtendFields = espParam.getActionExtendFields();
        ActionServiceId serviceId = espParam.getServiceId();
        Map<String, String> headers = espParam.getHeaders();
        String body = espParam.getBody();
        String application = espParam.getApplication();
        log.error("serviceId: {}", JsonUtils.objectToString(serviceId));
        serviceId = serviceId == null ? ActionServiceId.empty() : serviceId;
        RequestModel requestModel = new RequestModel();
        requestModel.setHostProd("Athena");
        requestModel.setHostVer("1.0");
        requestModel.setHostId("AgileInteraction");
        requestModel.setHostAcct(serviceId.getHostAcct());
        requestModel.setTenantId(serviceId.getTenant_id());
        requestModel.setServiceProd(serviceId.getProd());
        requestModel.setServiceProdUid(serviceId.getUid());
        requestModel.setServiceName(serviceId.getName());
        requestModel.setDatakeyMap(null);
        requestModel.setHeaderMap(headers);
        requestModel.setBodyJsonString(body);
        requestModel.setEocMap(businessUnit);
        if (headers.containsKey("locale")) {
            requestModel.setLanguage(headers.get("locale"));
        } else {
            //传默认多语言
            requestModel.setLanguage(LocaleContextHolder.getLocale().toString());
        }

        Map<String, String> dataKeyMap = Maps.newHashMap();
        if (MapUtils.isNotEmpty(actionExtendFields)) {
            actionExtendFields.forEach((key, value) -> dataKeyMap.put(key, String.valueOf(value)));
        }
        dataKeyMap.put("__PtxId", MDC.get("PtxId"));
        // 42420 将作业 code 和 type 拿到，透传给 esp，esp 给到业务中台用作运营统计分析
        // 有些应用在解析 digi-datakey 的时候，如果里面的值有 null 会报错
        if (org.apache.commons.lang3.StringUtils.isNotBlank(application)) {
            dataKeyMap.put("appCode", application);
        }
        String taskType = Optional.ofNullable(espParam.getPageCode())
                .map(pageCode -> {
                    switch (pageCode) {
                        case "task-card":
                        case "task-detail":
                        case "project-card":
                        case "project-detail":
                            return "TASK";
                        case "basic-data":
                        case "browse-page":
                        case "edit-page":
                            return "DATA_ENTRY";
                        default:
                            return null;
                    }
                })
                .orElse(null);
        if (org.apache.commons.lang3.StringUtils.isNotBlank(taskType) &&
                org.apache.commons.lang3.StringUtils.isNotBlank(espParam.getTmActivityId())) {
            dataKeyMap.put("taskType", taskType);
            dataKeyMap.put("taskCode", espParam.getTmActivityId());
        }
        requestModel.setDatakeyMap(dataKeyMap);
        return requestModel;
    }

    private Map createHeaders(ActionServiceId serviceId, String proxyToken, String token, String local, Action action) {
        Map<String, String> headers = new HashMap<>();
        //代理token有，使用，没有使用当前登陆的用户的token
        if (proxyToken != null) {
            headers.put(GlobalConstant.IAM_IDENTITY_TYPE_TOKEN, proxyToken);
        } else if (AppAuthContextHolder.getContext().getProxyToken() != null) {
            AuthoredUser proxyAuthoredUser = tokenVerifyService.getUserInfo(AppAuthContextHolder.getContext().getProxyToken());
            serviceId.setTenant_id(proxyAuthoredUser.getTenantId());
            headers.put(GlobalConstant.IAM_IDENTITY_TYPE_TOKEN, AppAuthContextHolder.getContext().getProxyToken());
        } else if (AppAuthContextHolder.getContext().getAuthoredUser() != null) {
            headers.put(GlobalConstant.IAM_IDENTITY_TYPE_TOKEN, AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        } else if (token != null) {
            headers.put(GlobalConstant.IAM_IDENTITY_TYPE_TOKEN, token);
        }
        //添加信任链路
        if (AppAuthContextHolder.getContext().getSecurityToken() != null) {
            headers.put(KEY_SECURITY_TOKEN, AppAuthContextHolder.getContext().getSecurityToken());
        }
        //添加routerKey,有传递则使用传递的，没传递，则使用当前登陆用户的。
        if (!headers.containsKey(GlobalConstant.ROUTER_KEY)) {
            String routerKey = MDC.get(GlobalConstant.ROUTER_KEY);
            if (StringUtils.hasText(routerKey)) {
                headers.put(GlobalConstant.ROUTER_KEY, routerKey);
            } else {
                //如有有代理的，取代理的先，最后取当前登陆用户的
                if (AppAuthContextHolder.getContext().getProxyAuthoredUser() != null) {
                    headers.put(GlobalConstant.ROUTER_KEY, AppAuthContextHolder.getContext().getProxyAuthoredUser().getTenantId());
                } else if (AppAuthContextHolder.getContext().getAuthoredUser() != null) {
                    headers.put(GlobalConstant.ROUTER_KEY, AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
                }
            }
        }
        headers.put("locale", local);
        // 塞入调用链
        headers.put(GlobalConstant.DIGI_DAP_SERVICE_CHAIN_INFO, ChainInfoUtil.genInvokeChainInfo(MDC.get(GlobalConstant.DIGI_DAP_SERVICE_CHAIN_INFO)));
        if (RootContext.getXID() != null) {
            headers.put(TX_XID, RootContext.getXID());
        }
        return headers;
    }

    private String getHostAcct(String pageCode, String pattern, AuthoredUser executeContextUser) {
        if (UiBotConstants.PAGE_CODE_BASIC_DATA.equals(pageCode) || UiBotConstants.PATTERN_DIALOG.equals(pattern)) {
            AuthoredUser authoredUser = null;
            if (null != AppAuthContextHolder.getContext().getProxyAuthoredUser()) {
                authoredUser = AppAuthContextHolder.getContext().getProxyAuthoredUser();
            } else if (AppAuthContextHolder.getContext().getAuthoredUser() != null) {
                authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
            } else if (null != executeContextUser) {
                authoredUser = executeContextUser;
            }

            if (enableTenantDataManage(authoredUser)) {//NOSONAR
                return authoredUser.getUserId();//NOSONAR
            }
        }
        return "athena";
    }

    private boolean enableTenantDataManage(AuthoredUser authoredUser) {
        if (null == authoredUser || !StringUtils.hasText(authoredUser.getTenantId())) {
            return false;
        }

        String tenantId = authoredUser.getTenantId();
        String category = "enableDataManage";
        try {
            TenantConfigDTO tenantConfig = audcService.getTenantConfig(tenantId, category);
            return null != tenantConfig && "TRUE".equalsIgnoreCase(tenantConfig.getConfigValue());
        } catch (Exception ex) {
            // 吃掉异常，hostAcct传最高权限
            log.error("[EspServiceImpl] query enableTenantDataManage for tenantId: {}, category: {} failed: {} ", tenantId, category, ex);
            return false;
        }
    }

//    @Override
//    public String getTenantProductList(String tenantId, String apiName) {
//        String prodName = "";
//        HttpHeaders headers = new HttpHeaders();
//        headers.setContentType(MediaType.APPLICATION_JSON);
//        Map<String, String> param = new HashMap<>();
//        param.put("tenant_id",tenantId);
//        param.put("api_name",apiName);
//        HttpEntity httpEntity = new HttpEntity<>(param,headers);
//
//        String url = envProperties.getMdcUri() + "/restful/standard/mdc/TenantProductList/Get";
//        ResponseEntity<Map> responseEntity =  restTemplate.postForEntity(url,httpEntity,Map.class);
//        if (responseEntity.getBody()==null){
//            return prodName;
//        }else {
//            if(responseEntity.getBody().containsKey("data")){
//                JSONObject data = JSONObject.fromObject(responseEntity.getBody().get("data"));
//                if (!data.containsKey("gateway")){
//                    return prodName;
//                }
//                JSONArray gatewayAttr = JSONArray.fromObject(data.get("gateway"));
//                if (gatewayAttr.isEmpty()){
//                    return prodName;
//                }
//                JSONObject gateway = JSONObject.fromObject(gatewayAttr.get(0));
//                if (gateway.isEmpty()){
//                    return prodName;
//                }
//                JSONArray productAttr = JSONArray.fromObject(gateway.get("product"));
//                if (productAttr.isEmpty()){
//                    return prodName;
//                }
//                JSONObject product = JSONObject.fromObject(productAttr.get(0));
//                if (product.isEmpty()){
//                    return prodName;
//                }
//                prodName = product.get("name").toString();
//            }
//            return prodName;
//        }
//    }
}

