package com.digiwin.athena.atdm.esp;

import com.digiwin.athena.atdm.RemoteProperties;
import com.digiwin.athena.esp.sdk.connection.HttpClientFactory;
import com.digiwin.athena.esp.sdk.init.EspSdkInitialize;
import com.digiwin.athena.smartdata.sdk.EspProxyInitialize;
import lombok.Data;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.CloseableHttpClient;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;

import java.lang.reflect.Field;

@Component
@Data
public class InitEspProperties implements InitializingBean {

    @Value("atdm")
    private String appId;

    @Value("eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6IkF0aGVuYSIsInNpZCI6MTYzNjc3NzI1NzgyNTkyfQ.3QLTPVKsk2Mp3j_aQ3X8bQW1wCJMNWeCkL6VPoK352c")
    private String token;

    @Autowired
    private RemoteProperties envProperties;

    @Autowired
    private HttpClient httpClient;

    public void run(ApplicationArguments args) throws NoSuchFieldException, IllegalAccessException {
        Field field = HttpClientFactory.class.getDeclaredField("closeableHttpClient");
        field.setAccessible(true);
        field.set(null, (CloseableHttpClient)httpClient);

        EspProxyInitialize.initConfig(envProperties.getRabbitMqUri(),envProperties.getEspUri(),envProperties.getMdcUri(), envProperties.getWebThemeMapDomainUri(), envProperties.getEocUri());
        EspSdkInitialize.initMQConfig(envProperties.getRabbitMqUri());
        EspSdkInitialize.initAppConfig(appId, token);
        EspSdkInitialize.initLmcConfig(envProperties.getDapLmcUri());
        EspSdkInitialize.enableEspRouting(true);
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        run(null);
    }
}
