package com.digiwin.athena.atdm.recycle.po;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;


/**
 * 回收站表
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Accessors(chain = true)
public class RecycleDO {
    // 过期
    public static final int STATE_EXPIRED = 9;
    // 正常激活状态
    public static final int STATE_ACTIVE = 1;

    /**
     * 租户Id
     */
    private String tenantId;

    /**
     * 活动编码
     */
    private String activityCode;

    /**
     * 活动名称
     */
    private String activityName;

    /**
     * 每次删除的数量
     */
    private int dataSize;

    /**
     * 每次删除的内容
     */
    private List<Map<String, Object>> pageData;

    /**
     * 版本号
     */
    private int version;

    /**
     * 删除日期
     */
    private LocalDateTime dateTime;

    /**
     * 序列号
     */
    private String sequenceNo;

    /**
     * 状态：11：过期
     */
    private Integer state;
}
