package com.digiwin.athena.atdm.retrieveData.dto;

import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

/**
 * RetrieveDataDTO Description
 *
 * @author majianfu
 * @date 2022/10/13
 * @since
 */
@Data
public class RetrieveDataDTO {
    /**
     * 执行终止用户id
     */
    private String userId;

    /**
     * 执行终止用户名称
     */
    private String userName;

    /**
     * 租户Id
     */
    private String tenantId;

    /**
     * 活动ID，如待办项ID
     */
    private String activityId;

    /**
     * 发起“撤回”的任务backlogId
     */
    private String initiateActivityId;

    /**
     * BK列表
     */
    private List<String> bkList;

    /**
     * BK data列表
     */
    private List<Map<String, Object>> bkDataList;

    /**
     * 终止的数据集
     */
    private List<Map<String, Object>> pageData;

    /**
     * 终止的数据行数
     */
    private Integer pageDataSize;

    /**
     * 终止日期
     */
    private LocalDateTime terminateTime;
}
