package com.digiwin.athena.atdm.thememap;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atdm.RemoteProperties;
import com.digiwin.athena.atdm.thememap.dto.BaseItemDto;
import com.digiwin.athena.atdm.thememap.dto.SuggestPlanDTO;
import com.digiwin.athena.atdm.thememap.dto.SuggestPlanItemsDTO;
import com.digiwin.athena.atdm.thememap.dto.TmAppDTO;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Slf4j
@Service
public class CommonThemeMapServiceImpl implements CommonThemeMapService {

    @Autowired
    private RemoteProperties envProperties;

    @Autowired
    private RestTemplate restTemplate;

    public HashMap<String,Object> executeFormula(String formulaId){

        String uri = envProperties.getKnowledgeGraphUri()+"knowledgegraph/tenantSettings/formula?formulaId={formulaId}";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);

        Map<String, String> param = new HashMap<>();
        param.put("formulaId",formulaId);

        HttpEntity<?> httpEntity = new HttpEntity<>(headers);
        try {
            ResponseEntity<BaseResultDTO> responseEntity = restTemplate.exchange(uri, HttpMethod.GET, httpEntity, new ParameterizedTypeReference<BaseResultDTO>() {
            });
            return ( HashMap<String,Object>) responseEntity.getBody().getResponseWithException("");
        } catch (Exception ex) {
            log.error("url: {}, error: ", uri, ex);
            throw ex;
        }

//        return ( HashMap<String,Object>) responseEntity.getBody().get("response");
    }

    public  HashMap<String,Object> post(String uri,Map parameter){
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("locale", LocaleContextHolder.getLocale().toString());

        HttpEntity httpEntity = new HttpEntity<Map>(parameter,headers);
        try {
            ResponseEntity<BaseResultDTO> responseEntity = restTemplate.exchange(uri, HttpMethod.POST, httpEntity, new ParameterizedTypeReference<BaseResultDTO>() {
            });

            Object response = responseEntity.getBody().getResponseWithException("");
            if (response instanceof Map) {
                return (HashMap) response;
            } else if (response instanceof List) {
                List respList = (List) response;
                if (CollectionUtils.isNotEmpty(respList)) {
                    return (HashMap<String, Object>) respList.get(0);
                } else {
                    return null;
                }
            } else {
                return null;
            }
        } catch (Exception ex) {
            log.error("body: {}, error: ", JsonUtils.objectToString(parameter), ex);
            throw ex;
        }
    }

    public HashMap<String,Object> postByRelativeUri(String relativeUri,Map parameter){

        String uri = envProperties.getWebThemeMapUri() + relativeUri;
        return post(uri,parameter);
    }


    /**
     * 获取方案数据
     * @return
     */
    @Override
    public List<SuggestPlanItemsDTO> getSuggestPlan(String locale, String decisionCode, List<Map<String,Object>> data){
        String url=envProperties.getDataMapUri()+"/restful/standard/datamap/mechanismEngine/sourceData";
        HttpHeaders headers = new HttpHeaders();
        headers.add("locale",locale);
        HashMap<String,Object> body = new HashMap();
        body.put("type","decision");
        body.put("code",decisionCode);
        body.put("datas",data);
        HttpEntity<HashMap<String,Object>> requestEntity = new HttpEntity<>(body, headers);

        try {
            ResponseEntity<BaseResultDTO<SuggestPlanDTO>> responseEntity = restTemplate.exchange(url, HttpMethod.POST, requestEntity,
                    new ParameterizedTypeReference<BaseResultDTO<SuggestPlanDTO>>() {
                    });
            if (responseEntity.getBody().getResponseWithException("")==null){
                log.warn(url+"返回null");
                return null;
            }
            return responseEntity.getBody().getResponseWithException("").getSuggest();
        }catch (Exception ex) {
            //吃掉异常
            log.error("body: {}, error: ", JsonUtils.objectToString(body), ex);
            throw ex;
        }
    }

    @Override
    public List<BaseItemDto> getActivitiesByPattern(String pattern){

        String url=envProperties.getKnowledgeGraphUri()+"/knowledgegraph/task/activitiesAndSortByPattern?pattern={pattern}";

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);

        Map<String,Object> param = new HashMap();
        param.put("pattern", pattern);

        HttpEntity<?> httpEntity = new HttpEntity<>(headers);

        ResponseEntity<BaseResultDTO<List<BaseItemDto>>> responseEntity = restTemplate.exchange(url, HttpMethod.GET, httpEntity, new ParameterizedTypeReference<BaseResultDTO<List<BaseItemDto>>>() {
        }, param);
        return responseEntity.getBody().getResponseWithException("");
    }

    @Override
    public List<TmAppDTO> getAppInfoByCodeAndType(String type, List<String> codeList) {

        String url = envProperties.getKnowledgeGraphUri() +  "knowledgegraph/task/applicationRelation";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("locale", LocaleContextHolder.getLocale().toString());

        Map<String, Object> params = new HashMap<>();
        params.put("type", type);
        params.put("codes", codeList);
        HttpEntity<?> httpEntity = new HttpEntity<>(params,headers);
        ResponseEntity<BaseResultDTO<List<TmAppDTO>>> respEntity = null;
        try {
            respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, new ParameterizedTypeReference<BaseResultDTO<List<TmAppDTO>>>() {
            });
        }
        catch (Exception e){
            log.error("execute km [knowledgegraph/task/applicationRelation] fail, error = {}", e.getMessage());
        }

        if (null != respEntity && null != respEntity.getBody()){
            return  respEntity.getBody().getResponseWithException("");
        }
        return null;
    }
}
