package com.digiwin.athena.atdm.uibot;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.HttpUtils;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atdm.RemoteProperties;
import com.digiwin.athena.atdm.ptm.dto.PtmWorkItemDTO;
import com.digiwin.athena.atdm.uibot.dto.UiBotTaskWithdrawReqDTO;
import com.digiwin.athena.atdm.datasource.domain.StatementConfig;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.fasterxml.jackson.core.type.TypeReference;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * UiBotServiceImpl Description
 *
 * @author majianfu
 * @date 2022/2/17
 * @since
 */
@Slf4j
@Service
public class CommonUiBotServiceImpl implements CommonUiBotService {
    @Resource
    private RemoteProperties remoteProperties;

    @Resource
    private RestTemplate restTemplate;

    @Resource
    private MessageUtils messageUtils;

    /**
     * {@inheritDoc}
     */
    @Override
    public Map queryTerminateDataPageDefine(String tmProjectId, String tmActivityId, Long workItemId, List bkList) {
        String url = MessageFormat.format(remoteProperties.getUibotUri() + "api/ai/v1/bot/terminateData/page/define/{0}/{1}/{2}", tmProjectId, tmActivityId, String.valueOf(workItemId));

        Map body = new HashMap();
        body.put("bkList", bkList);

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity reqEntity = new HttpEntity<>(body, headers);
        try {
            ResponseEntity<BaseResultDTO<Map>> respEntity = this.restTemplate.exchange(url, HttpMethod.POST, reqEntity, new ParameterizedTypeReference<BaseResultDTO<Map>>() {
            });
            return respEntity.getBody().getResponseWithException("");

//            if (HttpStatus.SC_OK == respEntity.getStatusCodeValue() && respEntity.getBody().isOK()) {
//                return respEntity.getBody().getResponse();
//            } else {
//                // 抛出异常
//                throw BusinessException.create(respEntity.getStatusCodeValue(), messageUtils.getMessage("exception.uibot.activity.DynamicForm") + JsonUtils.objectToString(respEntity.getBody()));
//            }
        } catch (Exception ex) {
            log.error("body: {}, error: ", JsonUtils.objectToString(body), ex);
            throw ex;

//            String errMsg = messageUtils.getMessage("exception.uibot.activity.DynamicForm");
//            throw BusinessException.create(599, "599", errMsg, ex.getMessage(), messageUtils.getMessage("exception.accessing.external.API"), ex);
        }
    }

    @Override
    public List<Map> queryDataUniformityPageDefine(String tmProjectId, String tmActivityId, String workItemId) {
        String url = MessageFormat.format(remoteProperties.getUibotUri() + "api/ai/v1/bot/dataUniformity/pageDefine/{0}/{1}/{2}", tmProjectId, tmActivityId, workItemId);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity reqEntity = new HttpEntity<>(headers);
        try {
            ResponseEntity<BaseResultDTO<List<Map>>> respEntity = this.restTemplate.exchange(url, HttpMethod.GET, reqEntity,
                    new ParameterizedTypeReference<BaseResultDTO<List<Map>>>() {
                    });
            return respEntity.getBody().getResponseWithException("");
//            if (HttpStatus.SC_OK == respEntity.getStatusCodeValue() && respEntity.getBody().isOK()) {
//                return respEntity.getBody().getResponse();
//            } else {
//                // 抛出异常
//                throw BusinessException.create(respEntity.getStatusCodeValue(),
//                        messageUtils.getMessage("exception.uibot.dataUniformity.pageDefine")
//                                + JsonUtils.objectToString(respEntity.getBody()));
//            }
        } catch (Exception ex) {
            log.error("url: {}, error: ", url, ex);
            throw ex;

//            String errMsg = messageUtils.getMessage("exception.uibot.dataUniformity.pageDefine");
//            throw BusinessException.create(599, "599", errMsg, ex.getMessage(), errMsg, ex);
        }
    }

    @Override
    public List<Map<String, Object>> getUnfinishedData(String tmProjectId, String tmActivityId, String workItemId) {
        String url = MessageFormat.format(remoteProperties.getUibotUri() + "api/ai/v1/data/query/unfinished/task/data/{0}/{1}/{2}",
                tmProjectId, tmActivityId, workItemId);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity reqEntity = new HttpEntity<>(headers);
        try {
            ResponseEntity<BaseResultDTO<List<Map<String, Object>>>> respEntity = this.restTemplate.exchange(url, HttpMethod.GET, reqEntity,
                    new ParameterizedTypeReference<BaseResultDTO<List<Map<String, Object>>>>() {
                    });
            return respEntity.getBody().getResponseWithException("");

//            if (HttpStatus.SC_OK == respEntity.getStatusCodeValue() && respEntity.getBody().isOK()) {
//                return respEntity.getBody().getResponse();
//            } else {
//                // 抛出异常
//                throw BusinessException.create(respEntity.getStatusCodeValue(), messageUtils.getMessage("exception.uibot.find.incomplete.data")
//                        + JsonUtils.objectToString(respEntity.getBody()));
//            }
        } catch (Exception ex) {
            log.error("url: {}, error: ", url, ex);
            throw ex;

//            String errMsg = messageUtils.getMessage("exception.uibot.find.incomplete.data");
//            throw BusinessException.create(599, "599", errMsg, ex.getMessage(), errMsg, ex);
        }
    }

    @Override
    public Map<String, Object> getAFCData() {
//        String url = remoteProperties.getUibotUri() + "/api/v1/ai/report/queryModelInfo";
        String url = remoteProperties.getIdriveBusinessReportUri() + "/api/v1/afc/report/queryModelInfo";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity reqEntity = new HttpEntity<>(headers);
        try {
            ResponseEntity<BaseResultDTO<Map<String, Object>>> respEntity = this.restTemplate.exchange(url, HttpMethod.GET, reqEntity,
                    new ParameterizedTypeReference<BaseResultDTO<Map<String, Object>>>() {
                    });
            return respEntity.getBody().getResponseWithException("");
//            if (HttpStatus.SC_OK == respEntity.getStatusCodeValue() && respEntity.getBody().isOK()) {
//                return respEntity.getBody().getResponse();
//            } else {
//                // 抛出异常
//                throw BusinessException.create(respEntity.getStatusCodeValue(),
//                        messageUtils.getMessage("exception.uibot.find.afc.data")
//                                + JsonUtils.objectToString(respEntity.getBody()));
//            }
        } catch (Exception ex) {
            log.error("url: {}, error: ", url, ex);
            throw ex;

//            String errMsg = messageUtils.getMessage("exception.uibot.find.afc.data");
//            throw BusinessException.create(599, "599", errMsg, ex.getMessage(), errMsg, ex);
        }
    }

    @Override
    public Map<Long, List<Map>> queryTaskWithdrawPageDefine(List<UiBotTaskWithdrawReqDTO> uiBotTaskWithdrawReqList) {
        String url = remoteProperties.getUibotUri() + "api/ai/v1/bot/taskWithdraw/page/define";

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity reqEntity = new HttpEntity<>(uiBotTaskWithdrawReqList, headers);
        try {
            ResponseEntity<BaseResultDTO<Map<Long, List<Map>>>> respEntity = this.restTemplate.exchange(url, HttpMethod.POST, reqEntity, new ParameterizedTypeReference<BaseResultDTO<Map<Long, List<Map>>>>() {
            });
            return respEntity.getBody().getResponseWithException("");

//            if (HttpStatus.SC_OK == respEntity.getStatusCodeValue() && respEntity.getBody().isOK()) {
//                return respEntity.getBody().getResponse();
//            } else {
//                // 抛出异常
//                throw BusinessException.create(respEntity.getStatusCodeValue(), messageUtils.getMessage("exception.task.withdraw.invoke.uibot") + JsonUtils.objectToString(respEntity.getBody()));
//            }
        } catch (Exception ex) {
            String message = messageUtils.getMessage("exception.task.withdraw.invoke.uibot");
            log.error("{}, reqBody: {}, error:{}", message, JsonUtils.objectToString(uiBotTaskWithdrawReqList), ex.getMessage());
            throw ex;

//            throw BusinessException.create(599, "599", message, ex.getMessage(), messageUtils.getMessage("exception.accessing.external.API"), ex);
        }
    }

    @Override
    public Map<Long, List<Map>> queryTaskCrossBkWithdrawPageDefine(List<PtmWorkItemDTO> uiBotTaskWithdrawReqList) {
        String url = remoteProperties.getUibotUri() + "api/ai/v1/bot/taskCrossBkWithdraw/page/define";

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity reqEntity = new HttpEntity<>(uiBotTaskWithdrawReqList, headers);
        try {
            ResponseEntity<BaseResultDTO<Map<Long, List<Map>>>> respEntity = this.restTemplate.exchange(url, HttpMethod.POST, reqEntity, new ParameterizedTypeReference<BaseResultDTO<Map<Long, List<Map>>>>() {
            });
            return respEntity.getBody().getResponseWithException("");

//            if (HttpStatus.SC_OK == respEntity.getStatusCodeValue() && respEntity.getBody().isOK()) {
//                return respEntity.getBody().getResponse();
//            } else {
//                // 抛出异常
//                throw BusinessException.create(respEntity.getStatusCodeValue(), messageUtils.getMessage("exception.task.withdraw.invoke.uibot") + JsonUtils.objectToString(respEntity.getBody()));
//            }
        } catch (Exception ex) {
            String message = messageUtils.getMessage("exception.task.withdraw.invoke.uibot");
            log.error("{}, reqBody: {}, error:{}", message, JsonUtils.objectToString(uiBotTaskWithdrawReqList), ex.getMessage());
            throw ex;

//            throw BusinessException.create(599, "599", message, ex.getMessage(), messageUtils.getMessage("exception.accessing.external.API"), ex);
        }
    }

    @Override
    public List<SubmitAction> getTaskPageSubmitActions(String tmTaskId, String tmActivityId, Map<String, Object> activityData) {
        String url = MessageFormat.format(remoteProperties.getUibotUri() + "/api/ai/v1/bot/task/submitactions/{0}/{1}", tmTaskId, tmActivityId);

        HttpHeaders headers = new HttpHeaders();
        headers.add("locale", LocaleContextHolder.getLocale().toString());

        HttpEntity<Map<String, Object>> reqEntity = new HttpEntity<>(activityData, headers);
        ResponseEntity<Object> respEntity = restTemplate.exchange(url, HttpMethod.POST, reqEntity, new ParameterizedTypeReference<Object>() {
        });
        return HttpUtils.descResponseBody(url, null, respEntity, new TypeReference<List<SubmitAction>>() {
        });
    }


    @Override
    public StatementConfig getStatementConfig(String reportCode) {
        String url = MessageFormat.format(remoteProperties.getUibotUri() + "api/ai/v1/bot/template/statement/condition/actions/{0}", reportCode);

        HttpHeaders headers = new HttpHeaders();
        headers.add("locale", LocaleContextHolder.getLocale().toString());

        HttpEntity<Map<String, Object>> reqEntity = new HttpEntity<>(null, headers);
        ResponseEntity<Object> respEntity = restTemplate.exchange(url, HttpMethod.GET, reqEntity, new ParameterizedTypeReference<Object>() {
        });
        return HttpUtils.descResponseBody(url, null, respEntity, new TypeReference<StatementConfig>() {
        });
    }

}
