/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.activity.service;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atdm.action.dto.ActionInfo;
import com.digiwin.athena.atdm.activity.domain.TmAction;
import com.digiwin.athena.atdm.activity.domain.TmActionBase;
import com.digiwin.athena.atdm.activity.domain.TmQueryAction;
import com.digiwin.athena.atdm.datasource.domain.Action;
import com.digiwin.athena.atdm.datasource.domain.ActionParameterMapping;
import com.digiwin.athena.atdm.datasource.domain.ActionServiceId;
import com.digiwin.athena.atdm.datasource.domain.QueryAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.iam.CommonUserService;
import com.digiwin.athena.atdm.thememap.CommonThemeMapQueryService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class BaseActionCreateService {
    @Autowired
    private CommonUserService commonUserService;
    @Autowired
    private CommonThemeMapQueryService themeMapService;

    protected void appendActionInfo(String tenantId, TmActionBase tmAction) {
        block6: {
            TmAction submitAction;
            block5: {
                ActionInfo actionInfo;
                if (StringUtils.isEmpty((Object)tmAction.getProductName()) && (actionInfo = this.themeMapService.getActionInfo(tenantId, tmAction.getActionId())) != null) {
                    tmAction.setProductName(actionInfo.getProductName());
                    tmAction.setUrl(actionInfo.getUrl());
                    tmAction.setServiceName(actionInfo.getServiceName());
                }
                if (!(tmAction instanceof TmQueryAction)) break block5;
                TmQueryAction tmQueryAction = (TmQueryAction)tmAction;
                if (tmQueryAction.getLeft() != null) {
                    this.appendActionInfo(tenantId, tmQueryAction.getLeft());
                }
                if (tmQueryAction.getRightList() == null) break block6;
                for (TmQueryAction action : tmQueryAction.getRightList()) {
                    this.appendActionInfo(tenantId, action);
                }
                break block6;
            }
            if (tmAction instanceof TmAction && (submitAction = (TmAction)tmAction).getAttachActions() != null) {
                for (TmAction action : submitAction.getAttachActions()) {
                    this.appendActionInfo(tenantId, action);
                }
            }
        }
    }

    public SubmitAction createSubmitAction(TmAction tmActionDTO, String tenantId, Map<String, Object> businessUnit) {
        SubmitAction action = new SubmitAction();
        this.appendActionInfo(tenantId, tmActionDTO);
        action.setActionId(tmActionDTO.getActionId());
        action.setServiceId(this.createActionServiceId(tmActionDTO, tenantId));
        action.setCategory(tmActionDTO.getType());
        action.setTitle(tmActionDTO.getTitle());
        action.setReturnText(tmActionDTO.getReturnText());
        action.setBusinessUnit(businessUnit);
        action.setExtendParas(tmActionDTO.getExtendParas());
        action.setAddShowFileds(tmActionDTO.getAddShowFileds());
        action.setBackFills(tmActionDTO.getBackFills());
        return action;
    }

    protected QueryAction createAction(TmQueryAction tmActionDTO, String tenantId, Map<String, Object> businessUnit) {
        QueryAction action = new QueryAction();
        this.appendActionInfo(tenantId, tmActionDTO);
        action.setActionId(tmActionDTO.getActionId());
        action.setServiceId(this.createActionServiceId(tmActionDTO, tenantId));
        action.setCategory(tmActionDTO.getType());
        action.setTitle(tmActionDTO.getTitle());
        action.setBusinessUnit(businessUnit);
        return action;
    }

    public QueryAction createQueryAction(String tenantId, Map<String, Object> businessUnit, TmQueryAction tmAction, Map<String, Object> bpmData) {
        QueryAction action = this.createAction(tmAction, tenantId, businessUnit);
        action.setParas(this.setActionParameter(tmAction.getActionParams(), (JSONObject)JsonUtils.jsonToObject((String)JsonUtils.objectToString(bpmData), JSONObject.class)));
        action.setActionParams(new ArrayList<ActionParameterMapping>());
        for (ActionParameterMapping actionParam : tmAction.getActionParams()) {
            if (!"ACTIVE_ROW".equals(actionParam.getType()) && !"ACTIVE_ROW_CONSTANT".equals(actionParam.getType()) && !"PAGE_DATA_CONSTANT".equals(actionParam.getType()) && !"PAGE_DATA".equals(actionParam.getType())) continue;
            action.getActionParams().add(actionParam);
        }
        action.setBusinessUnit(businessUnit);
        return action;
    }

    public QueryAction createQueryHasParasAction(String tenantId, Map<String, Object> businessUnit, TmQueryAction tmAction, Map<String, Object> paras) {
        QueryAction action = this.createAction(tmAction, tenantId, businessUnit);
        action.setParas(paras);
        action.setBusinessUnit(businessUnit);
        return action;
    }

    private ActionServiceId createActionServiceId(TmActionBase tmActionDTO, String tenantId) {
        ActionServiceId actionServiceId = new ActionServiceId();
        actionServiceId.setProd(tmActionDTO.getProductName());
        actionServiceId.setTenant_id(tenantId);
        actionServiceId.setHostAcct(this.getHostAcct());
        if (tmActionDTO.getNeedProxyToken() != null && tmActionDTO.getNeedProxyToken().booleanValue() && AppAuthContextHolder.getContext().getAuthoredUser() != null) {
            actionServiceId.setProxyToken(AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        }
        actionServiceId.setServiceUri(tmActionDTO.getUrl());
        actionServiceId.setName(tmActionDTO.getServiceName());
        return actionServiceId;
    }

    private String getHostAcct() {
        return "athena";
    }

    public SubmitAction createEspSubmitAction(String tenantId, Map businessUnit, TmAction tmAction) {
        SubmitAction action = this.createSubmitAction(tmAction, tenantId, businessUnit);
        action.setActionParams(tmAction.getActionParams());
        HashMap<String, Object> batch = new HashMap<String, Object>();
        batch.put("submitAll", tmAction.getSubmitAll());
        action.setBatch(batch);
        action.setExtendParas(tmAction.getExtendParas());
        action.setAddShowFileds(tmAction.getAddShowFileds());
        action.setDefaultAction(tmAction.isDefaultAction());
        action.setActionScript(tmAction.getActionScript());
        this.processActionParas(action);
        return action;
    }

    protected Map<String, Object> setActionParameter(List<ActionParameterMapping> actionParameterMappings, JSONObject dataJson) {
        HashMap<String, Object> paraMap = new HashMap<String, Object>();
        if (dataJson != null && !CollectionUtils.isEmpty(actionParameterMappings)) {
            for (ActionParameterMapping tmActionRequestParameter : actionParameterMappings) {
                if (!"PROCESS_VARIABLE".equals(tmActionRequestParameter.getType()) || !dataJson.containsKey((Object)tmActionRequestParameter.getValue())) continue;
                paraMap.put(tmActionRequestParameter.getName(), dataJson.get(tmActionRequestParameter.getValue()));
            }
            for (ActionParameterMapping tmActionRequestParameter : actionParameterMappings) {
                if (!"RAW_ARRAY_PARAS".equals(tmActionRequestParameter.getType())) continue;
                String[] pathName = StringUtils.split((String)tmActionRequestParameter.getName(), (String)".");
                String paramKey = pathName[0];
                String paramNodeKey = pathName[1];
                String value = tmActionRequestParameter.getValue();
                List dataList = new ArrayList();
                if (null != paraMap.get(paramKey)) {
                    dataList = (List)paraMap.get(paramKey);
                }
                Map<String, Object> dataP = new HashMap();
                if (!CollectionUtils.isEmpty(dataList)) {
                    dataP = (Map)dataList.get(0);
                } else {
                    dataList.add(dataP);
                }
                for (Object o : dataJson.keySet()) {
                    String dataKey = (String)o;
                    if (!dataKey.equals(value)) continue;
                    dataP.put(paramNodeKey, dataJson.get(dataKey));
                }
                if (CollectionUtils.isEmpty(dataList)) continue;
                paraMap.put(paramKey, dataList);
            }
            for (ActionParameterMapping tmActionRequestParameter : actionParameterMappings) {
                if ("PROCESS_VARIABLE".equals(tmActionRequestParameter.getType()) || "ACTIVE_ROW".equals(tmActionRequestParameter.getType()) || "RAW_ARRAY_PARAS".equals(tmActionRequestParameter.getType()) || "PAGE_DATA".equals(tmActionRequestParameter.getType()) || "PAGE_DATA_CONSTANT".equals(tmActionRequestParameter.getType())) continue;
                this.setSinglePara(paraMap, tmActionRequestParameter);
            }
        }
        return paraMap;
    }

    private void setSinglePara(Map<String, Object> paraMap, ActionParameterMapping tmActionRequestParameter) {
        String conName = tmActionRequestParameter.getName();
        if (conName.contains(".")) {
            String[] conNames = conName.split("\\.");
            Object p = paraMap.get(conNames[0]);
            if (p instanceof JSONObject) {
                JSONObject pJson = (JSONObject)p;
                if ("{@SYSTEM_USER_ID}".equals(tmActionRequestParameter.getValue())) {
                    pJson.put((Object)conNames[1], (Object)AppAuthContextHolder.getContext().getAuthoredUser().getUserId());
                } else if ("{@SYSTEM_EMPLOYEE_ID}".equals(tmActionRequestParameter.getValue())) {
                    pJson.put((Object)conNames[1], (Object)this.commonUserService.getEmpIdByUserId(AppAuthContextHolder.getContext().getAuthoredUser().getUserId(), AppAuthContextHolder.getContext().getAuthoredUser().getToken()));
                } else if ("[]".equals(tmActionRequestParameter.getValue())) {
                    pJson.put((Object)tmActionRequestParameter.getName(), new ArrayList());
                } else {
                    pJson.put((Object)conNames[1], (Object)tmActionRequestParameter.getValue());
                }
            } else if (p instanceof Map) {
                Map pJson = (Map)p;
                if ("{@SYSTEM_USER_ID}".equals(tmActionRequestParameter.getValue())) {
                    pJson.put(conNames[1], AppAuthContextHolder.getContext().getAuthoredUser().getUserId());
                } else if ("{@SYSTEM_EMPLOYEE_ID}".equals(tmActionRequestParameter.getValue())) {
                    pJson.put(conNames[1], this.commonUserService.getEmpIdByUserId(AppAuthContextHolder.getContext().getAuthoredUser().getUserId(), AppAuthContextHolder.getContext().getAuthoredUser().getToken()));
                } else if ("[]".equals(tmActionRequestParameter.getValue())) {
                    pJson.put(tmActionRequestParameter.getName(), new ArrayList());
                } else {
                    pJson.put(conNames[1], tmActionRequestParameter.getValue());
                }
            } else if (p instanceof JSONArray) {
                JSONArray pJsonArray = (JSONArray)p;
                for (Object oJson : pJsonArray.toArray()) {
                    if (!(oJson instanceof JSONObject)) continue;
                    JSONObject pJson = (JSONObject)oJson;
                    if ("[]".equals(tmActionRequestParameter.getValue())) {
                        pJson.put((Object)tmActionRequestParameter.getName(), new ArrayList());
                        continue;
                    }
                    pJson.put((Object)conNames[1], (Object)tmActionRequestParameter.getValue());
                }
            } else if (p instanceof List) {
                List pJsonArray = (List)p;
                for (Object o : pJsonArray) {
                    if (!(o instanceof Map)) continue;
                    Map pJson = (Map)o;
                    if ("[]".equals(tmActionRequestParameter.getValue())) {
                        pJson.put(tmActionRequestParameter.getName(), new ArrayList());
                        continue;
                    }
                    pJson.put(conNames[1], tmActionRequestParameter.getValue());
                }
            }
        } else if ("{@SYSTEM_USER_ID}".equals(tmActionRequestParameter.getValue())) {
            paraMap.put(tmActionRequestParameter.getName(), AppAuthContextHolder.getContext().getAuthoredUser().getUserId());
        } else if ("{@SYSTEM_EMPLOYEE_ID}".equals(tmActionRequestParameter.getValue())) {
            paraMap.put(tmActionRequestParameter.getName(), this.commonUserService.getEmpIdByUserId(AppAuthContextHolder.getContext().getAuthoredUser().getUserId(), AppAuthContextHolder.getContext().getAuthoredUser().getToken()));
        } else if ("[]".equals(tmActionRequestParameter.getValue())) {
            paraMap.put(tmActionRequestParameter.getName(), new ArrayList());
        } else {
            paraMap.put(tmActionRequestParameter.getName(), tmActionRequestParameter.getValue());
        }
    }

    protected void processActionParas(Action action) {
        SubmitAction submitAction;
        if (!CollectionUtils.isEmpty(action.getActionParams())) {
            for (ActionParameterMapping actionParam : action.getActionParams()) {
                if (!"SYSTEM".equals(actionParam.getType())) continue;
                if ("SYSTEM_EMPLOYEE_ID".equals(actionParam.getValue())) {
                    actionParam.setValue(this.commonUserService.getEmpIdByUserId(AppAuthContextHolder.getContext().getAuthoredUser().getUserId(), AppAuthContextHolder.getContext().getAuthoredUser().getToken()));
                    actionParam.setType("CONSTANT");
                    continue;
                }
                if (!"SYSTEM_USER_ID".equals(actionParam.getValue())) continue;
                actionParam.setValue(AppAuthContextHolder.getContext().getAuthoredUser().getUserId());
                actionParam.setType("CONSTANT");
            }
        }
        if (action instanceof SubmitAction && (submitAction = (SubmitAction)action).getAttachActions() != null) {
            submitAction.getAttachActions().forEach(actionDTO -> this.processActionParas((Action)actionDTO));
        }
    }
}

