/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.uibot;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.HttpUtils;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atdm.RemoteProperties;
import com.digiwin.athena.atdm.datasource.domain.StatementConfig;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.ptm.dto.PtmWorkItemDTO;
import com.digiwin.athena.atdm.uibot.CommonUiBotService;
import com.digiwin.athena.atdm.uibot.dto.UiBotTaskWithdrawReqDTO;
import com.fasterxml.jackson.core.type.TypeReference;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class CommonUiBotServiceImpl
implements CommonUiBotService {
    private static final Logger log = LoggerFactory.getLogger(CommonUiBotServiceImpl.class);
    @Resource
    private RemoteProperties remoteProperties;
    @Resource
    private RestTemplate restTemplate;
    @Resource
    private MessageUtils messageUtils;

    @Override
    public Map queryTerminateDataPageDefine(String tmProjectId, String tmActivityId, Long workItemId, List bkList) {
        String url = MessageFormat.format(this.remoteProperties.getUibotUri() + "api/ai/v1/bot/terminateData/page/define/{0}/{1}/{2}", tmProjectId, tmActivityId, String.valueOf(workItemId));
        HashMap<String, List> body = new HashMap<String, List>();
        body.put("bkList", bkList);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity reqEntity = new HttpEntity(body, (MultiValueMap)headers);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, reqEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Map>>(){}, new Object[0]);
            return (Map)((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
        }
        catch (Exception ex) {
            log.error("body: {}, error: ", (Object)JsonUtils.objectToString(body), (Object)ex);
            throw ex;
        }
    }

    @Override
    public List<Map> queryDataUniformityPageDefine(String tmProjectId, String tmActivityId, String workItemId) {
        String url = MessageFormat.format(this.remoteProperties.getUibotUri() + "api/ai/v1/bot/dataUniformity/pageDefine/{0}/{1}/{2}", tmProjectId, tmActivityId, workItemId);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity reqEntity = new HttpEntity((MultiValueMap)headers);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.GET, reqEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<Map>>>(){}, new Object[0]);
            return (List)((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
        }
        catch (Exception ex) {
            log.error("url: {}, error: ", (Object)url, (Object)ex);
            throw ex;
        }
    }

    @Override
    public List<Map<String, Object>> getUnfinishedData(String tmProjectId, String tmActivityId, String workItemId) {
        String url = MessageFormat.format(this.remoteProperties.getUibotUri() + "api/ai/v1/data/query/unfinished/task/data/{0}/{1}/{2}", tmProjectId, tmActivityId, workItemId);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity reqEntity = new HttpEntity((MultiValueMap)headers);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.GET, reqEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<Map<String, Object>>>>(){}, new Object[0]);
            return (List)((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
        }
        catch (Exception ex) {
            log.error("url: {}, error: ", (Object)url, (Object)ex);
            throw ex;
        }
    }

    @Override
    public Map<String, Object> getAFCData() {
        String url = this.remoteProperties.getIdriveBusinessReportUri() + "/api/v1/afc/report/queryModelInfo";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity reqEntity = new HttpEntity((MultiValueMap)headers);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.GET, reqEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Map<String, Object>>>(){}, new Object[0]);
            return (Map)((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
        }
        catch (Exception ex) {
            log.error("url: {}, error: ", (Object)url, (Object)ex);
            throw ex;
        }
    }

    @Override
    public Map<Long, List<Map>> queryTaskWithdrawPageDefine(List<UiBotTaskWithdrawReqDTO> uiBotTaskWithdrawReqList) {
        String url = this.remoteProperties.getUibotUri() + "api/ai/v1/bot/taskWithdraw/page/define";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity reqEntity = new HttpEntity(uiBotTaskWithdrawReqList, (MultiValueMap)headers);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, reqEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Map<Long, List<Map>>>>(){}, new Object[0]);
            return (Map)((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
        }
        catch (Exception ex) {
            String message = this.messageUtils.getMessage("exception.task.withdraw.invoke.uibot");
            log.error("{}, reqBody: {}, error:{}", new Object[]{message, JsonUtils.objectToString(uiBotTaskWithdrawReqList), ex.getMessage()});
            throw ex;
        }
    }

    @Override
    public Map<Long, List<Map>> queryTaskCrossBkWithdrawPageDefine(List<PtmWorkItemDTO> uiBotTaskWithdrawReqList) {
        String url = this.remoteProperties.getUibotUri() + "api/ai/v1/bot/taskCrossBkWithdraw/page/define";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity reqEntity = new HttpEntity(uiBotTaskWithdrawReqList, (MultiValueMap)headers);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, reqEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Map<Long, List<Map>>>>(){}, new Object[0]);
            return (Map)((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
        }
        catch (Exception ex) {
            String message = this.messageUtils.getMessage("exception.task.withdraw.invoke.uibot");
            log.error("{}, reqBody: {}, error:{}", new Object[]{message, JsonUtils.objectToString(uiBotTaskWithdrawReqList), ex.getMessage()});
            throw ex;
        }
    }

    @Override
    public List<SubmitAction> getTaskPageSubmitActions(String tmTaskId, String tmActivityId, Map<String, Object> activityData) {
        String url = MessageFormat.format(this.remoteProperties.getUibotUri() + "/api/ai/v1/bot/task/submitactions/{0}/{1}", tmTaskId, tmActivityId);
        HttpHeaders headers = new HttpHeaders();
        headers.add("locale", LocaleContextHolder.getLocale().toString());
        HttpEntity reqEntity = new HttpEntity(activityData, (MultiValueMap)headers);
        ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, reqEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<Object>(){}, new Object[0]);
        return (List)HttpUtils.descResponseBody((String)url, null, (ResponseEntity)respEntity, (TypeReference)new TypeReference<List<SubmitAction>>(){});
    }

    @Override
    public StatementConfig getStatementConfig(String reportCode) {
        String url = MessageFormat.format(this.remoteProperties.getUibotUri() + "api/ai/v1/bot/template/statement/condition/actions/{0}", reportCode);
        HttpHeaders headers = new HttpHeaders();
        headers.add("locale", LocaleContextHolder.getLocale().toString());
        HttpEntity reqEntity = new HttpEntity(null, (MultiValueMap)headers);
        ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.GET, reqEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<Object>(){}, new Object[0]);
        return (StatementConfig)HttpUtils.descResponseBody((String)url, null, (ResponseEntity)respEntity, (TypeReference)new TypeReference<StatementConfig>(){});
    }
}

