package com.digiwin.athena.atdm.abt;

import com.digiwin.athena.atdm.RemoteProperties;
import com.digiwin.athena.atdm.action.dto.RefreshCardDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;
@Service
public class CommonAbtServiceImpl implements CommonAbtService {

    public static final String POST_REFRESH_CARD = "/api/abt/v1/refresh/card/message/refreshCard";

    @Autowired
    private RemoteProperties envProperties;

    @Autowired
    private RestTemplate restTemplate;
    @Override
    public void refreshCard(RefreshCardDto refreshCardDto) {
        String url = envProperties.getAbtUri() + POST_REFRESH_CARD;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        restTemplate.exchange(url, HttpMethod.POST, new HttpEntity(refreshCardDto, headers),Object.class);
    }
}
