package com.digiwin.athena.atdm.activity.service;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atdm.action.dto.ActionInfo;
import com.digiwin.athena.atdm.thememap.CommonThemeMapQueryService;
import com.digiwin.athena.atdm.iam.CommonUserService;
import com.digiwin.athena.atdm.activity.ActivityConstants;
import com.digiwin.athena.atdm.activity.domain.TmAction;
import com.digiwin.athena.atdm.activity.domain.TmActionBase;
import com.digiwin.athena.atdm.activity.domain.TmQueryAction;
import com.digiwin.athena.atdm.datasource.domain.*;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @description: 查询数据ACTION
 * @author: wangminga
 * @create: 2020-09-02 18:58
 **/
@Service
public class BaseActionCreateService {
    @Autowired
    private CommonUserService commonUserService;

    @Autowired
    private CommonThemeMapQueryService themeMapService;


    protected void appendActionInfo(String  tenantId, TmActionBase tmAction) {
        if (StringUtils.isEmpty( tmAction.getProductName())) {
            ActionInfo actionInfo = themeMapService.getActionInfo(tenantId, tmAction.getActionId());
            if (actionInfo != null) {
                tmAction.setProductName(actionInfo.getProductName());
                tmAction.setUrl(actionInfo.getUrl());
                tmAction.setServiceName(actionInfo.getServiceName());
            }
        }

        if (tmAction instanceof  TmQueryAction){
            TmQueryAction tmQueryAction = (TmQueryAction) tmAction;
            if (tmQueryAction.getLeft() != null){
                appendActionInfo(tenantId,tmQueryAction.getLeft());
            }
            if (tmQueryAction.getRightList() != null){
                for (TmQueryAction action : tmQueryAction.getRightList()) {
                    appendActionInfo(tenantId,action);
                }
            }
        } else if(tmAction instanceof TmAction){
            TmAction submitAction = (TmAction)tmAction;
            if (submitAction.getAttachActions() != null){
                for (TmAction action : submitAction.getAttachActions()) {
                    appendActionInfo(tenantId,action);
                }
            }
        }

    }


    /**
     * 创建 查询 ACTION
     *
     * @param tmActionDTO
     * @param tenantId
     * @return
     */
    public SubmitAction createSubmitAction(TmAction tmActionDTO, String tenantId, Map<String,Object> businessUnit) {
        SubmitAction action = new SubmitAction();
        appendActionInfo(tenantId,tmActionDTO);
        action.setActionId(tmActionDTO.getActionId());
        action.setServiceId(this.createActionServiceId(tmActionDTO, tenantId));
//        action.setInvokeType(this.createActionInvokeType(action.getServiceId()));
        action.setCategory(tmActionDTO.getType());
        action.setTitle(tmActionDTO.getTitle());
        action.setReturnText(tmActionDTO.getReturnText());
        action.setBusinessUnit(businessUnit);
        action.setExtendParas(tmActionDTO.getExtendParas());
        action.setAddShowFileds(tmActionDTO.getAddShowFileds());
        action.setBackFills(tmActionDTO.getBackFills());
        return action;
    }

    /**
     * 创建 查询 ACTION
     *
     * @param tmActionDTO
     * @param tenantId
     * @return
     */
    protected QueryAction createAction(TmQueryAction tmActionDTO, String tenantId, Map<String,Object> businessUnit) {
        QueryAction action = new QueryAction();
        appendActionInfo(tenantId,tmActionDTO);
        action.setActionId(tmActionDTO.getActionId());
        action.setServiceId(this.createActionServiceId(tmActionDTO, tenantId));
//        action.setInvokeType(this.createActionInvokeType(action.getServiceId()));
        action.setCategory(tmActionDTO.getType());
        action.setTitle(tmActionDTO.getTitle());
        action.setBusinessUnit(businessUnit);
        return action;
    }

    /**
     * 创建 查询 ACTION 根据 activityTaskData
     *
     * @param tmAction
     * @return
     */
    public QueryAction createQueryAction(String tenantId, Map<String, Object> businessUnit,  TmQueryAction tmAction,Map<String, Object> bpmData ) {
        QueryAction action = this.createAction(tmAction, tenantId, businessUnit);
        // 直接使用JSONObject.fromObject会报NPE: json key must not be null
        action.setParas(this.setActionParameter(tmAction.getActionParams(), JsonUtils.jsonToObject(JsonUtils.objectToString(bpmData), JSONObject.class)));
        //如果需要前端传如参数,则把需要传的参数放入到ActionParams
        action.setActionParams(new ArrayList<>());
        for (ActionParameterMapping actionParam : tmAction.getActionParams()) {
            if ("ACTIVE_ROW" .equals(actionParam.getType())
                    ||"ACTIVE_ROW_CONSTANT" .equals(actionParam.getType())
                    || "PAGE_DATA_CONSTANT" .equals(actionParam.getType())
                    || "PAGE_DATA" .equals(actionParam.getType())){
                action.getActionParams().add(actionParam);
            }
        }
        action.setBusinessUnit(businessUnit);
        return action;
    }


    /**
     * 直接组装好参数--无需在此转换
     *
     * @param tmAction
     * @return
     */
    public QueryAction createQueryHasParasAction(String tenantId, Map<String, Object> businessUnit, TmQueryAction tmAction, Map<String,Object> paras ) {
        QueryAction action = this.createAction(tmAction, tenantId, businessUnit);
        action.setParas(paras);
        action.setBusinessUnit(businessUnit);
        return action;
    }


    /**
     * 创建服务信息节点
     *
     * @param tmActionDTO
     * @param tenantId
     */
    private ActionServiceId createActionServiceId(TmActionBase tmActionDTO, String tenantId) {

        ActionServiceId actionServiceId = new ActionServiceId();
        actionServiceId.setProd(tmActionDTO.getProductName());
        actionServiceId.setTenant_id(tenantId);
        actionServiceId.setHostAcct(getHostAcct());
//        if (!StringUtils.isEmpty(tmActionDTO.getUrl()) && !tmActionDTO.getUrl().contains("CROSS")) {
//            actionServiceId.setProd("SPT");
//        }
        if (tmActionDTO.getNeedProxyToken() != null && tmActionDTO.getNeedProxyToken() && AppAuthContextHolder.getContext().getAuthoredUser() != null) {
            actionServiceId.setProxyToken(AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        }
        actionServiceId.setServiceUri(tmActionDTO.getUrl());
        actionServiceId.setName(tmActionDTO.getServiceName());
        return actionServiceId;
    }

    private String getHostAcct() {
        // TODO 具体策略待讨论
        return "athena";
//        if (null != AppAuthContextHolder.getContext().getProxyAuthoredUser()) {
//            return AppAuthContextHolder.getContext().getProxyAuthoredUser().getUserId();
//        } else if (AppAuthContextHolder.getContext().getAuthoredUser() != null) {
//            return AppAuthContextHolder.getContext().getAuthoredUser().getUserId();
//        } else {
//            return "athena";
//        }
    }

    public SubmitAction createEspSubmitAction(String tenantId, Map businessUnit, TmAction tmAction) {
        SubmitAction action = createSubmitAction(tmAction, tenantId,businessUnit);
        //没有数据源，直接将ThemeMap中的参数传入即可
        action.setActionParams(tmAction.getActionParams());
        //如果支持分批提交，则设置分批提交的数据源
        Map<String,Object> batch=new HashMap<>();
        batch.put("submitAll",tmAction.getSubmitAll());
        action.setBatch(batch);

        action.setExtendParas(tmAction.getExtendParas());
        action.setAddShowFileds(tmAction.getAddShowFileds());
        action.setDefaultAction(tmAction.isDefaultAction());
        action.setActionScript(tmAction.getActionScript());
        processActionParas(action);
        return action;
    }


    /**
     * 处理 查询ACTION 参数
     * @param dataJson
     */
    protected  Map<String, Object> setActionParameter(List<ActionParameterMapping> actionParameterMappings, JSONObject dataJson) {

        Map<String, Object> paraMap = new HashMap<>();

        if (dataJson != null && !CollectionUtils.isEmpty(actionParameterMappings)) {
            //优先处理流程参数，因为其他参数是附加到流程参数内部的
            for (ActionParameterMapping tmActionRequestParameter : actionParameterMappings) {
                if (ActivityConstants.TASK_QUERY_PROCESS_VARIABLE.equals(tmActionRequestParameter.getType()) && dataJson.containsKey(tmActionRequestParameter.getValue())) {
                    //流程参数
                    paraMap.put(tmActionRequestParameter.getName(), dataJson.get(tmActionRequestParameter.getValue()));
                }
            }

            //优先处理指定参数，因为其他参数是附加到参数内部的
            for (ActionParameterMapping tmActionRequestParameter : actionParameterMappings) {
                //结构 xxx.aa xxx:数组节点 aa: 对象KEY
                if ("RAW_ARRAY_PARAS".equals(tmActionRequestParameter.getType())) {
                    //流程参数
                    String pathName[] = StringUtils.split(tmActionRequestParameter.getName(), ".");
                    String paramKey = pathName[0];
                    String paramNodeKey = pathName[1];
                    String value = tmActionRequestParameter.getValue();
                    List<Map<String, Object>> dataList = new ArrayList<>();
                    if (null != paraMap.get(paramKey)) {
                        dataList = (List<Map<String, Object>>) paraMap.get(paramKey);
                    }
                    Map dataP = new HashMap<>();
                    if (!CollectionUtils.isEmpty(dataList)) {
                        dataP = dataList.get(0);
                    } else {
                        dataList.add(dataP);
                    }
                    for (Object o : dataJson.keySet()) {
                        String dataKey = (String) o;
                        if (dataKey.equals(value)) {
                            dataP.put(paramNodeKey, dataJson.get(dataKey));
                        }

                    }
                    if (!CollectionUtils.isEmpty(dataList)) {
                        paraMap.put(paramKey, dataList);
                    }
                }
            }

            //最后再处理其他单个参数,ACTIVE_ROW 是前端参数，需要排除
            for (ActionParameterMapping tmActionRequestParameter : actionParameterMappings) {
                if (!ActivityConstants.TASK_QUERY_PROCESS_VARIABLE.equals(tmActionRequestParameter.getType())
                        && !"ACTIVE_ROW".equals(tmActionRequestParameter.getType())
                        && !"RAW_ARRAY_PARAS".equals(tmActionRequestParameter.getType())
                        && !"PAGE_DATA".equals(tmActionRequestParameter.getType())
                        && !"PAGE_DATA_CONSTANT".equals(tmActionRequestParameter.getType())) {
                    //常规参数处理
                    setSinglePara(paraMap, tmActionRequestParameter);
                }
            }

        }
        return paraMap;
    }

    /**
     * 增加action的后端过滤条件
     *
     * @param paraMap
     */
    private void setSinglePara(Map<String, Object> paraMap, ActionParameterMapping tmActionRequestParameter) {

        //服务端 过滤
        String conName = tmActionRequestParameter.getName();
        if (conName.contains(".")) {
            //指定过滤条件加在哪个参数中
            String[] conNames = conName.split("\\.");
            Object p = paraMap.get(conNames[0]);
            if (p instanceof JSONObject) {
                JSONObject pJson = (JSONObject) p;
                if ("{@SYSTEM_USER_ID}".equals(tmActionRequestParameter.getValue())) {
                    pJson.put(conNames[1], AppAuthContextHolder.getContext().getAuthoredUser().getUserId());
                } else if ("{@SYSTEM_EMPLOYEE_ID}".equals(tmActionRequestParameter.getValue())) {
                    pJson.put(conNames[1], commonUserService.getEmpIdByUserId(AppAuthContextHolder.getContext().getAuthoredUser().getUserId(), AppAuthContextHolder.getContext().getAuthoredUser().getToken()));
                } else {
                    if ("[]".equals(tmActionRequestParameter.getValue())) {
                        //常量为[]进行特殊处理，表示空组数
                        pJson.put(tmActionRequestParameter.getName(), new ArrayList());
                    } else {
                        pJson.put(conNames[1], tmActionRequestParameter.getValue());
                    }
                }
            } else if (p instanceof Map) {
                Map pJson = (Map) p;
                if ("{@SYSTEM_USER_ID}".equals(tmActionRequestParameter.getValue())) {
                    pJson.put(conNames[1], AppAuthContextHolder.getContext().getAuthoredUser().getUserId());
                } else if ("{@SYSTEM_EMPLOYEE_ID}".equals(tmActionRequestParameter.getValue())) {
                    pJson.put(conNames[1], commonUserService.getEmpIdByUserId(AppAuthContextHolder.getContext().getAuthoredUser().getUserId(), AppAuthContextHolder.getContext().getAuthoredUser().getToken()));
                } else {
                    if ("[]".equals(tmActionRequestParameter.getValue())) {
                        //常量为[]进行特殊处理，表示空组数
                        pJson.put(tmActionRequestParameter.getName(), new ArrayList());
                    } else {
                        pJson.put(conNames[1], tmActionRequestParameter.getValue());
                    }
                }
            } else if (p instanceof JSONArray) {
                JSONArray pJsonArray = (JSONArray) p;
                for (Object oJson : pJsonArray.toArray()) {
                    if (oJson instanceof JSONObject) {
                        JSONObject pJson = (JSONObject) oJson;
                        if ("[]".equals(tmActionRequestParameter.getValue())) {
                            //常量为[]进行特殊处理，表示空组数
                            pJson.put(tmActionRequestParameter.getName(), new ArrayList());
                        } else {
                            pJson.put(conNames[1], tmActionRequestParameter.getValue());
                        }
                    }
                }
            } else if (p instanceof List) {
                List pJsonArray = (List) p;
                for (Object o : pJsonArray) {
                    if (o instanceof Map) {
                        Map pJson = (Map) o;
                        if ("[]".equals(tmActionRequestParameter.getValue())) {
                            //常量为[]进行特殊处理，表示空组数
                            pJson.put(tmActionRequestParameter.getName(), new ArrayList());
                        } else {
                            pJson.put(conNames[1], tmActionRequestParameter.getValue());
                        }
                    }
                }
            }
        } else {
            if ("{@SYSTEM_USER_ID}".equals(tmActionRequestParameter.getValue())) {
                paraMap.put(tmActionRequestParameter.getName(), AppAuthContextHolder.getContext().getAuthoredUser().getUserId());
            } else if ("{@SYSTEM_EMPLOYEE_ID}".equals(tmActionRequestParameter.getValue())) {
                paraMap.put(tmActionRequestParameter.getName(), commonUserService.getEmpIdByUserId(AppAuthContextHolder.getContext().getAuthoredUser().getUserId(), AppAuthContextHolder.getContext().getAuthoredUser().getToken()));
            }else {
                if ("[]".equals(tmActionRequestParameter.getValue())) {
                    //常量为[]进行特殊处理，表示空组数
                    paraMap.put(tmActionRequestParameter.getName(), new ArrayList());
                } else {
                    paraMap.put(tmActionRequestParameter.getName(), tmActionRequestParameter.getValue());
                }
            }
        }
    }


    /**
     * 统一处理参数转化
     * @param action
     */
    protected  void processActionParas(Action action){
        if (!CollectionUtils.isEmpty(action.getActionParams())){
            for (ActionParameterMapping actionParam : action.getActionParams()) {
                if("SYSTEM".equals(actionParam.getType())){
                    if ("SYSTEM_EMPLOYEE_ID".equals(actionParam.getValue())){
                        actionParam.setValue(commonUserService.getEmpIdByUserId(AppAuthContextHolder.getContext().getAuthoredUser().getUserId(),AppAuthContextHolder.getContext().getAuthoredUser().getToken()));
                        actionParam.setType("CONSTANT");
                    }else if ("SYSTEM_USER_ID".equals(actionParam.getValue())){
                        actionParam.setValue( AppAuthContextHolder.getContext().getAuthoredUser().getUserId());
                        actionParam.setType("CONSTANT");
                    }

                }
            }
        }
        if (action instanceof SubmitAction){
            SubmitAction submitAction = (SubmitAction)action;
            if (submitAction.getAttachActions() !=null) {
                submitAction.getAttachActions().forEach(
                        actionDTO -> processActionParas(actionDTO)
                );
            }
        }
    }
}
