package com.digiwin.athena.atdm.adsc;


import com.digiwin.athena.atdm.datasource.domain.Action;
import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import com.digiwin.athena.atdm.datasource.dto.PageInfo;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
/**
 * ATMC 提供相关服务
 */
public interface CommonAdscService {

    /**
     * 通过adsc查询应用数据
     * @param executeContext 执行上下文
     * @param action 操作信息
     * @param parameter 附加参数
     * @return
     */
    HashMap<String,Object> query(ExecuteContext executeContext, Action action, Map<String, Object> parameter,PageInfo pageInfo, List<Map> orderInfo, List<Map> searchInfo);

    /**
     * 查询adsc应用数据对应字段的值，用于下拉框
     * @param executeContext 执行上下文
     * @param conFileds 查询字段数组
     * @param searchInfo 搜索条件
     * @return
     */
    Map<String,List<Map>> queryConditions(ExecuteContext executeContext , List<String> conFileds, List<Map> searchInfo) ;
}
