package com.digiwin.athena.atdm.datasource.domain;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;

/**
 * Action对应的服务实体
 * @author zhujg
 */

@Data
@AllArgsConstructor
@NoArgsConstructor
public class ActionServiceId implements Serializable {

    private String proxyToken;

    /**
     * 租户Id
     */
    private String tenant_id;

    /**
     * 产品名称
     */
    private String prod;

    /**
     * 账套Id
     */
    private String  uid;

    private String hostAcct;

    /**
     * 服务名称，例如http://athena.digiwincloud.com.cn/restful/service/spt/Purchaselnfo/PoInfo、purchase.info.get
     */
    private  String name;

    private  String serviceUri;

    /**
     * BMP服务的相对地址
     */
    private String relativeUrl;

    public static ActionServiceId empty() {
        ActionServiceId actionServiceId = new ActionServiceId();
        actionServiceId.setProxyToken(StringUtils.EMPTY);
        actionServiceId.setTenant_id(StringUtils.EMPTY);
        actionServiceId.setProd(StringUtils.EMPTY);
        actionServiceId.setUid(StringUtils.EMPTY);
        actionServiceId.setHostAcct(StringUtils.EMPTY);
        actionServiceId.setName(StringUtils.EMPTY);
        actionServiceId.setServiceUri(StringUtils.EMPTY);
        actionServiceId.setRelativeUrl(StringUtils.EMPTY);
        return actionServiceId;
    }
}
