package com.digiwin.athena.atdm.lcdp;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atdm.RemoteProperties;
import com.digiwin.athena.atdm.constant.ErrorCodeEnum;
import com.digiwin.athena.atdm.datasource.domain.Action;
import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.HashMap;
import java.util.Map;

@Slf4j
@Service
public class CommonLcdpServiceImpl implements CommonLcdpService {

    @Autowired
    RestTemplate restTemplate;

    @Autowired
    private RemoteProperties envProperties;

    @Autowired
    private MessageUtils messageUtils;


    @Override
    public HashMap<String, Object> query(ExecuteContext executeContext, Action action) {
        String url = envProperties.getWebLcdpUri() + action.getServiceId().getServiceUri();

        HashMap body = new HashMap();
        body.put("params", action.getParas());
        HttpHeaders headerMap = new HttpHeaders();
        headerMap.setContentType(MediaType.APPLICATION_JSON);
        //如有有代理的，取代理的先，最后取当前登陆用户的
        if (AppAuthContextHolder.getContext().getProxyAuthoredUser() != null) {
            headerMap.add(GlobalConstant.IAM_IDENTITY_TYPE_TOKEN, AppAuthContextHolder.getContext().getProxyAuthoredUser().getToken());
        } else if (AppAuthContextHolder.getContext().getAuthoredUser() != null) {
            headerMap.add(GlobalConstant.IAM_IDENTITY_TYPE_TOKEN, AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        }
        HttpEntity httpEntity = new HttpEntity<Map>(body, headerMap);
        try {
            ResponseEntity<HashMap> responseEntity = restTemplate.postForEntity(url, httpEntity, HashMap.class);
            if (responseEntity.getStatusCode() != null &&  200 == responseEntity.getStatusCode().value()) {
                HashMap result = responseEntity.getBody();
                if(result.containsKey("response")) {
                    if (result.get("response") instanceof Map) {
                        Map response = (Map) result.get("response");
                        if (response.containsKey("success") && !Boolean.valueOf(response.get("success").toString())) {
                            String message = result.get("response").toString();
                            if (response.containsKey("message")) {
                                message = response.get("message").toString();
                            }
                            throw BusinessException.create(ErrorCodeEnum.LDCP_QUERY.getErrCode(), message);
                        }
                    }
                }
                // 返回真实业务数据
                if (result instanceof Map) {

                    return (HashMap<String, Object>) result;
                } else {
                    return null;
                }
            }else {
                throw BusinessException.create(ErrorCodeEnum.LDCP_QUERY.getErrCode(), String.format(messageUtils.getMessage("exception.execution.lcdp"), action.getServiceId().getServiceUri(), responseEntity.getBody().toString()));
            }
        } catch (Exception e) {
            log.error("[execute] {}, body: {}", ErrorCodeEnum.LDCP_QUERY.getErrCode(), JsonUtils.objectToString(body));
            throw BusinessException.create(ErrorCodeEnum.LDCP_QUERY.getErrCode(), String.format(messageUtils.getMessage("exception.execution.lcdp"), action.getServiceId().getServiceUri(), e.getMessage()));
        }
    }

    @Override
    public  HashMap<String,Object> execute(SubmitExecuteContext executeContext, Action action){
        String url = envProperties.getWebLcdpUri() + action.getServiceId().getServiceUri();

        HashMap body = new HashMap();
        body.put("params", action.getParas());
        HttpHeaders headerMap = new HttpHeaders();
        headerMap.setContentType(MediaType.APPLICATION_JSON);
        //如有有代理的，取代理的先，最后取当前登陆用户的
        if (AppAuthContextHolder.getContext().getProxyAuthoredUser() != null) {
            headerMap.add(GlobalConstant.IAM_IDENTITY_TYPE_TOKEN, AppAuthContextHolder.getContext().getProxyAuthoredUser().getToken());
        } else if (AppAuthContextHolder.getContext().getAuthoredUser() != null) {
            headerMap.add(GlobalConstant.IAM_IDENTITY_TYPE_TOKEN, AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        }
        HttpEntity httpEntity = new HttpEntity<Map>(body, headerMap);
        try {
            ResponseEntity<HashMap> responseEntity = restTemplate.postForEntity(url, httpEntity, HashMap.class);
            if (responseEntity.getStatusCode() != null &&  200 == responseEntity.getStatusCode().value()) {
                HashMap result = responseEntity.getBody();
                if(result.containsKey("response")) {
                    if (result.get("response") instanceof Map) {
                        Map response = (Map) result.get("response");
                        if (response.containsKey("success") && !Boolean.valueOf(response.get("success").toString())) {
                            String message = result.get("response").toString();
                            if (response.containsKey("message")) {
                                message = response.get("message").toString();
                            }
                            throw BusinessException.create(ErrorCodeEnum.LDCP_EXECUTE.getErrCode(), message);
                        }
                    }
                }
                // 返回真实业务数据
                if (result instanceof Map) {
                    return (HashMap<String, Object>) result;
                } else {
                    return null;
                }
            }else {
                throw BusinessException.create(ErrorCodeEnum.LDCP_EXECUTE.getErrCode(), String.format(messageUtils.getMessage("exception.execution.lcdp.submit"), action.getServiceId().getServiceUri(), responseEntity.getBody().toString()));
            }
        } catch (Exception e) {
            log.error("[execute] {}, body: {}", ErrorCodeEnum.LDCP_EXECUTE.getErrCode(), JsonUtils.objectToString(body));
            throw BusinessException.create(ErrorCodeEnum.LDCP_EXECUTE.getErrCode(), String.format(messageUtils.getMessage("exception.execution.lcdp.submit"), action.getServiceId().getServiceUri(), e.getMessage()));
        }
    }
}
