package com.digiwin.athena.atdm.thememap;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atdm.RemoteProperties;
import com.digiwin.athena.atdm.datasource.domain.ApiMetadata;
import com.digiwin.athena.atdm.datasource.domain.MetadataField;
import com.digiwin.athena.atdm.thememap.dto.MetadataDataDTO;
import com.digiwin.athena.atdm.thememap.dto.MetadataFieldDTO;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @description: 元数据服务
 * @author: wangminga
 * @create: 2020-05-14 15:02
 **/
@Slf4j
@Service
public class CommonMetadataServiceImpl implements CommonMetadataService {

    @Autowired
    private RemoteProperties envProperties;

    @Autowired
    private RestTemplate restTemplate;

    @Autowired
    private MessageUtils messageUtils;

    private static String patternStr = "^\\((?<length>\\d*?),(?<place>\\d*?)\\)$|^(?<size>\\d*?)$";
    private static Pattern pattern = Pattern.compile(patternStr);
    /**
     * 元数据获取地址
     */
   static String METADATA_URL ="knowledgegraph/Action/Metadata";

    @Override
    public ApiMetadata getMetadata(String locale, String actionId) {
        if (!StringUtils.hasText(actionId)) {
            return null;
        }
        String url = envProperties.getKnowledgeGraphUri() + METADATA_URL + "?actionId=" + actionId;

        HttpHeaders headers = new HttpHeaders();
        headers.add("locale", locale);
        HttpEntity<String> requestEntity = new HttpEntity<>(null, headers);
        try {
            ResponseEntity<BaseResultDTO<MetadataDataDTO>> response = restTemplate.exchange(url, HttpMethod.GET, requestEntity,
                    new ParameterizedTypeReference<BaseResultDTO<MetadataDataDTO>>() {
                    });
            return createApiMetadata(response.getBody().getResponseWithException(messageUtils.getMessage("exception.find.data.from.KG")));
        } catch (Exception e) {
            log.error("url: {}, error: ", url, e);
            throw e;

//            String message = messageUtils.getMessage("exception.find.data.from.KG") + url;
//            throw BusinessException.create(599, "599", message, message, messageUtils.getMessage("exception.accessing.external.API"), e);
        }

    }

    /**
     * 创建单个元数据结构
     * @param metadataDataDTO
     * @return
     */
    public static ApiMetadata createApiMetadata(MetadataDataDTO metadataDataDTO){
        ApiMetadata apiMetadata = new ApiMetadata();
        String actionId = metadataDataDTO.getActionId();
        String serviceName =  metadataDataDTO.getServiceName();
        apiMetadata.setActionId(actionId);
        apiMetadata.setServiceName(serviceName);
        apiMetadata.setInvokeType(metadataDataDTO.getInvokeType());
        if(metadataDataDTO.getRequest() != null && metadataDataDTO.getRequest().getParameters() != null){
            apiMetadata.addRequestFields(createMetadataField(new ArrayList<>(),metadataDataDTO.getRequest().getParameters()));
        }
        if(metadataDataDTO.getResponse() != null && metadataDataDTO.getResponse().getData() != null){
            apiMetadata.addResponseFields(createMetadataField(new ArrayList<>(),metadataDataDTO.getResponse().getData()));
        }

        return apiMetadata;
    }

    /**
     * 创建对象
     * @param metadataFieldDTOs
     * @return
     */
    private static List<MetadataField> createMetadataField(List<MetadataField> requestFields, List<MetadataFieldDTO>  metadataFieldDTOs){
        for (MetadataFieldDTO metadataFieldDTO : metadataFieldDTOs) {
            MetadataField metadataField = new MetadataField();
            metadataField.setName(metadataFieldDTO.getData_name());
            if(metadataFieldDTO.getRequired()==null){
                metadataField.setRequired(false);
            }else {
                metadataField.setRequired(metadataFieldDTO.getRequired());
            }
            metadataField.setDescription(metadataFieldDTO.getDescription());
            metadataField.setRemark(metadataFieldDTO.getRemark());
            metadataField.setBusinessKey(metadataFieldDTO.getIs_businesskey());
            metadataField.setDataKey(metadataFieldDTO.getIs_datakey());
            metadataField.setDataType(metadataFieldDTO.getData_type());
            metadataField.setCanSort(metadataFieldDTO.getCan_sort());
            metadataField.setCanFilter(metadataFieldDTO.getCan_filter());
            metadataField.setEnumKey(metadataFieldDTO.getEnum_key());
            //解析数据精度或者长度
            if (metadataFieldDTO.getPrecision() != null){
                Matcher m = pattern.matcher(metadataFieldDTO.getPrecision());
                if (m.matches() ){
                    Map<String,Integer> precision =new HashMap<>();
                    //如果只有长度
                    if (m.group("size") != null){
                        precision.put("length", Integer.parseInt( m.group("size")));
                        metadataField.setPrecision(precision);
                    }else  if (m.group("length") != null && m.group("place") != null){
                        precision.put("length", Integer.parseInt( m.group("length")));
                        precision.put("place", Integer.parseInt( m.group("place")));
                        metadataField.setPrecision(precision);
                    }
                }
            }
            metadataField.setArray(metadataFieldDTO.getIs_array());
            if(CollectionUtils.isNotEmpty(metadataFieldDTO.getField())){
                List<MetadataField> subRequestFields = new ArrayList<>();
                metadataField.setSubFields(createMetadataField(subRequestFields,metadataFieldDTO.getField()));
            }
            requestFields.add(metadataField);
        }
        return requestFields;
    }


    /**
     * 创建对象
     * @param metadataFieldDTO
     * @return
     */
    private static List<MetadataField> createMetadataField(List<MetadataField> requestFields,MetadataFieldDTO  metadataFieldDTO){
        MetadataField metadataField = new MetadataField();
        metadataField.setName(metadataFieldDTO.getData_name());
        if(metadataFieldDTO.getRequired()==null){
            metadataField.setRequired(false);
        }else {
            metadataField.setRequired(metadataFieldDTO.getRequired());
        }
        metadataField.setDescription(metadataFieldDTO.getDescription());
        metadataField.setRemark(metadataFieldDTO.getRemark());
        metadataField.setDataKey(metadataFieldDTO.getIs_datakey());
        metadataField.setBusinessKey(metadataFieldDTO.getIs_businesskey());
        metadataField.setDataType(metadataFieldDTO.getData_type());
        metadataField.setArray(metadataFieldDTO.getIs_array());
        metadataField.setEnumKey(metadataFieldDTO.getEnum_key());
        metadataField.setCanSort(metadataFieldDTO.getCan_sort());
        metadataField.setCanFilter(metadataFieldDTO.getCan_filter());
        if(CollectionUtils.isNotEmpty(metadataFieldDTO.getField())){
            List<MetadataField> subRequestFields = new ArrayList<>();
            metadataField.setSubFields(createMetadataField(subRequestFields,metadataFieldDTO.getField()));
        }
        requestFields.add(metadataField);
        return requestFields;
    }

}
